/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.help.helpui.DocConfig;
import com.mathworks.help.helpui.DocLocation;
import com.mathworks.help.helpui.DocRoot;
import com.mathworks.html.BrowserRequest;
import com.mathworks.html.CustomProtocolUrl;
import com.mathworks.html.FileUrl;
import com.mathworks.html.Url;
import com.mathworks.html.UrlTransformer;
import com.mathworks.html.WebUrl;
import com.mathworks.mde.help.HelpBrowserLinkClickedHandler;
import com.mathworks.mde.help.InstalledFileUrlResolver;
import com.mathworks.mde.help.MLHelpBrowser;
import com.mathworks.mde.help.UrlDisplayBehavior;
import com.mathworks.mlwidgets.help.DocCenterDocConfig;
import com.mathworks.mwswing.MJOptionPane;
import java.awt.Component;
import java.net.MalformedURLException;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;

class InstalledLinkClickedHandler
extends HelpBrowserLinkClickedHandler {
    private static final ResourceBundle RES = ResourceBundle.getBundle("com.mathworks.mde.help.resources.RES_HelpBrowser");
    private final MLHelpBrowser fMLHelpBrowser;
    private final DocCenterDocConfig<FileUrl> fLocalConfig;

    InstalledLinkClickedHandler(MLHelpBrowser mLHelpBrowser, DocCenterDocConfig<FileUrl> docCenterDocConfig) {
        this.fMLHelpBrowser = mLHelpBrowser;
        this.fLocalConfig = docCenterDocConfig;
    }

    protected boolean handleLinkClickRequest(BrowserRequest browserRequest) {
        RedirectTransformer redirectTransformer = new RedirectTransformer(UrlDisplayBehavior.Destination.NO_REDIRECT);
        return (Boolean)redirectTransformer.transformUrl(browserRequest.getUrl());
    }

    public void linkClicked(Url url) {
        RedirectTransformer redirectTransformer = new RedirectTransformer(UrlDisplayBehavior.Destination.CURRENT_HELP_BROWSER);
        redirectTransformer.transformUrl(url);
    }

    @Override
    protected MLHelpBrowser getHelpBrowser() {
        return this.fMLHelpBrowser;
    }

    @Override
    protected DocLocation getDocLocation() {
        return DocLocation.INSTALLED;
    }

    private void promptUserAndDisplayUrl(final Url url) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                PromptUserDisplayUrl promptUserDisplayUrl = new PromptUserDisplayUrl(url);
                SwingUtilities.invokeLater(promptUserDisplayUrl);
            }
        };
        new Thread(runnable).start();
    }

    private class PromptUserDisplayUrl
    implements Runnable {
        private final Url iResolvedUrl;

        PromptUserDisplayUrl(Url url) {
            this.iResolvedUrl = url;
        }

        @Override
        public void run() {
            boolean bl;
            int n = MJOptionPane.showConfirmDialog((Component)InstalledLinkClickedHandler.this.fMLHelpBrowser.getComponent(), (Object)RES.getString("doccenter.view-link-on-web.text"), (String)RES.getString("doccenter.view-link-on-web.title"), (int)0, (int)1);
            boolean bl2 = bl = n == 0;
            if (bl) {
                InstalledLinkClickedHandler.this.handleLinkClicked(this.iResolvedUrl, UrlDisplayBehavior.Destination.SYSTEM_BROWSER);
            } else {
                InstalledLinkClickedHandler.this.fMLHelpBrowser.requestFocusInBrowser();
            }
        }
    }

    private class RedirectTransformer
    extends UrlTransformer<Boolean> {
        private final UrlDisplayBehavior.Destination iDefaultDestination;

        private RedirectTransformer(UrlDisplayBehavior.Destination destination) {
            this.iDefaultDestination = destination;
        }

        protected Boolean transformWebUrl(WebUrl webUrl) {
            return InstalledLinkClickedHandler.this.handleLinkClicked((Url)webUrl, this.iDefaultDestination);
        }

        protected Boolean transformFileUrl(FileUrl fileUrl) {
            DocRoot docRoot;
            try {
                docRoot = DocCenterDocConfig.getSystemBrowserDocUrlBuilder();
            }
            catch (MalformedURLException malformedURLException) {
                return InstalledLinkClickedHandler.this.handleLinkClicked((Url)fileUrl, this.iDefaultDestination);
            }
            InstalledFileUrlResolver installedFileUrlResolver = new InstalledFileUrlResolver((DocConfig<FileUrl>)InstalledLinkClickedHandler.this.fLocalConfig, (DocRoot<WebUrl>)docRoot);
            Url url = installedFileUrlResolver.resolveFileUrl(fileUrl);
            if (url.getType() == Url.UrlType.WEB) {
                InstalledLinkClickedHandler.this.promptUserAndDisplayUrl(url);
                return true;
            }
            UrlDisplayBehavior.Destination destination = this.createResolvedUrlDestination((Url)fileUrl, url);
            return InstalledLinkClickedHandler.this.handleLinkClicked(url, destination);
        }

        private UrlDisplayBehavior.Destination createResolvedUrlDestination(Url url, Url url2) {
            if (!url.equals((Object)url2) && this.iDefaultDestination == UrlDisplayBehavior.Destination.NO_REDIRECT) {
                return UrlDisplayBehavior.Destination.CURRENT_HELP_BROWSER;
            }
            return this.iDefaultDestination;
        }

        protected Boolean transformCustomProtocolUrl(CustomProtocolUrl customProtocolUrl) {
            return InstalledLinkClickedHandler.this.handleLinkClicked((Url)customProtocolUrl, this.iDefaultDestination);
        }
    }
}

