/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mde.help.HelpUtils;
import com.mathworks.mlwidgets.html.LanguageLocale;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.util.LanguageUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.border.Border;

class LanguagePrefsPanel {
    private MJPanel fLanguagePrefsPanel = new MJPanel();
    private MJRadioButton fEnglishButton;

    LanguagePrefsPanel() {
        this.fLanguagePrefsPanel.setLayout((LayoutManager)new BorderLayout());
        MJMultilineLabel mJMultilineLabel = new MJMultilineLabel(HelpUtils.getLocalizedString((String)"prefs.language.label"));
        mJMultilineLabel.setName("HelpLanguageLabel");
        boolean bl = LanguagePrefsPanel.shouldSelectEnglish();
        ButtonGroup buttonGroup = new ButtonGroup();
        String string = LanguagePrefsPanel.getDefaultLanguageText();
        MJRadioButton mJRadioButton = new MJRadioButton(string);
        mJRadioButton.setName("HelpLanguageDefaultButton");
        mJRadioButton.setSelected(!bl);
        buttonGroup.add((AbstractButton)mJRadioButton);
        this.fEnglishButton = new MJRadioButton(HelpUtils.getLocalizedString((String)"prefs.language.english"));
        this.fEnglishButton.setName("HelpLanguageEnglishButton");
        this.fEnglishButton.setSelected(bl);
        buttonGroup.add((AbstractButton)this.fEnglishButton);
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("2dlu, pref", "pref, 3dlu, pref, pref"));
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)mJMultilineLabel, cellConstraints.xy(2, 1));
        panelBuilder.add((Component)mJRadioButton, cellConstraints.xy(2, 3));
        panelBuilder.add((Component)this.fEnglishButton, cellConstraints.xy(2, 4));
        panelBuilder.getPanel().getAccessibleContext().setAccessibleName(HelpUtils.getLocalizedString((String)"prefs.language.title"));
        panelBuilder.setBorder((Border)BorderFactory.createTitledBorder(HelpUtils.getLocalizedString((String)"prefs.language.title")));
        this.fLanguagePrefsPanel.add((Component)panelBuilder.getPanel());
    }

    private static boolean shouldSelectEnglish() {
        return HelpUtils.getLanguageLocale().equals((Object)LanguageLocale.ENGLISH);
    }

    private static String getDefaultLanguageText() {
        switch (LanguageLocale.getSupportedLanguageLocale((Locale)LanguageUtils.getHelpLocale())) {
            case JAPANESE: {
                return HelpUtils.getLocalizedString((String)"prefs.language.japanese");
            }
            case SIMPLIFIED_CHINESE: {
                return HelpUtils.getLocalizedString((String)"prefs.language.simplified_chinese");
            }
            case KOREAN: {
                return HelpUtils.getLocalizedString((String)"prefs.language.korean");
            }
        }
        return HelpUtils.getLocalizedString((String)"prefs.language.default_language");
    }

    JComponent getComponent() {
        return this.fLanguagePrefsPanel;
    }

    Locale getSelectedLocale() {
        return this.fEnglishButton != null && this.fEnglishButton.isSelected() ? Locale.ENGLISH : LanguageUtils.getHelpLocale();
    }
}

