/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.help.helpui.DocLocation;
import com.mathworks.html.CustomProtocolUrl;
import com.mathworks.html.FileUrl;
import com.mathworks.html.Url;
import com.mathworks.html.UrlTransformer;
import com.mathworks.html.WebUrl;
import com.mathworks.mde.help.UrlDisplayBehavior;
import com.mathworks.mde.help.UrlDisplayDefaultDependencyProvider;
import com.mathworks.mde.help.UrlDisplayDependencyProvider;

public class LinkClickedUrlDisplayBehaviorFactory
extends UrlTransformer<UrlDisplayBehavior> {
    private final DocLocation fDocLocation;
    private final UrlDisplayBehavior.Destination fDefaultDestination;
    private final UrlDisplayDependencyProvider fDependencyProvider;
    private boolean fLocalized;
    private Url fCorrectedUrl;

    LinkClickedUrlDisplayBehaviorFactory(DocLocation docLocation, UrlDisplayBehavior.Destination destination) {
        this(docLocation, destination, new UrlDisplayDefaultDependencyProvider());
    }

    LinkClickedUrlDisplayBehaviorFactory(DocLocation docLocation, UrlDisplayBehavior.Destination destination, UrlDisplayDependencyProvider urlDisplayDependencyProvider) {
        this.fDocLocation = docLocation;
        this.fDefaultDestination = destination;
        this.fDependencyProvider = urlDisplayDependencyProvider;
    }

    public UrlDisplayBehavior transformUrl(Url url) {
        Url url2 = this.localizeUrl(url);
        this.fLocalized = !url2.equals((Object)url);
        return (UrlDisplayBehavior)super.transformUrl(url2);
    }

    private Url localizeUrl(Url url) {
        return this.fDependencyProvider.getLocalizedUrl(url);
    }

    protected UrlDisplayBehavior transformWebUrl(WebUrl webUrl) {
        this.fCorrectedUrl = webUrl;
        if (this.fDocLocation == DocLocation.INSTALLED) {
            return new UrlDisplayBehavior(this.fCorrectedUrl, UrlDisplayBehavior.Destination.SYSTEM_BROWSER);
        }
        return new UrlDisplayBehavior(this.fCorrectedUrl, this.fDefaultDestination);
    }

    protected UrlDisplayBehavior transformFileUrl(FileUrl fileUrl) {
        this.fCorrectedUrl = fileUrl;
        if (this.fLocalized || this.fDependencyProvider.isSearchResultsPage(this.fCorrectedUrl)) {
            return new UrlDisplayBehavior(this.fCorrectedUrl, UrlDisplayBehavior.Destination.CURRENT_HELP_BROWSER);
        }
        if (!this.fDependencyProvider.isDocPage((Url)fileUrl)) {
            return new UrlDisplayBehavior(this.fCorrectedUrl, UrlDisplayBehavior.Destination.SYSTEM_BROWSER);
        }
        return new UrlDisplayBehavior(this.fCorrectedUrl, this.fDefaultDestination);
    }

    protected UrlDisplayBehavior transformCustomProtocolUrl(CustomProtocolUrl customProtocolUrl) {
        this.fCorrectedUrl = customProtocolUrl;
        return new UrlDisplayBehavior(this.fCorrectedUrl, UrlDisplayBehavior.Destination.CURRENT_HELP_BROWSER);
    }
}

