/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.help.helpui.DocLocation;
import com.mathworks.html.CustomProtocolUrl;
import com.mathworks.html.FileUrl;
import com.mathworks.html.Url;
import com.mathworks.html.UrlTransformer;
import com.mathworks.html.WebUrl;
import com.mathworks.mde.help.MLHelpBrowser;
import com.mathworks.mde.help.UrlDisplayBehavior;
import com.mathworks.mde.help.UrlDisplayDefaultDependencyProvider;
import com.mathworks.mde.help.UrlDisplayDependencyProvider;

public class OpenBrowserUrlDisplayBehaviorFactory
extends UrlTransformer<UrlDisplayBehavior> {
    private final DocLocation fDocLocation;
    private final UrlDisplayBehavior.Destination fDefaultDestination;
    private final UrlDisplayDependencyProvider fDependencyProvider;
    private Url fCorrectedUrl;
    private UrlDisplayData fUrlDisplayData;

    OpenBrowserUrlDisplayBehaviorFactory(DocLocation docLocation, UrlDisplayBehavior.Destination destination) {
        this(docLocation, destination, new UrlDisplayDefaultDependencyProvider());
    }

    OpenBrowserUrlDisplayBehaviorFactory(DocLocation docLocation, UrlDisplayBehavior.Destination destination, UrlDisplayDependencyProvider urlDisplayDependencyProvider) {
        this.fDocLocation = docLocation;
        this.fDefaultDestination = destination;
        this.fDependencyProvider = urlDisplayDependencyProvider;
    }

    public UrlDisplayBehavior transformUrl(Url url) {
        return (UrlDisplayBehavior)super.transformUrl(url);
    }

    protected UrlDisplayBehavior transformWebUrl(WebUrl webUrl) {
        this.fCorrectedUrl = webUrl;
        this.fUrlDisplayData = this.fDocLocation == DocLocation.INSTALLED ? new UrlDisplayData(UrlDisplayBehavior.Destination.SYSTEM_BROWSER) : this.getUrlDisplayData(this.fCorrectedUrl.toString(), this.fDefaultDestination);
        return new UrlDisplayBehavior(this.fCorrectedUrl, this.fUrlDisplayData.getDestination(), this.fUrlDisplayData.getHelpBrowser());
    }

    protected UrlDisplayBehavior transformFileUrl(FileUrl fileUrl) {
        this.fCorrectedUrl = fileUrl;
        this.fUrlDisplayData = !this.fDependencyProvider.isDocPage(this.fCorrectedUrl) && !this.fDependencyProvider.isSearchResultsPage(this.fCorrectedUrl) ? new UrlDisplayData(UrlDisplayBehavior.Destination.SYSTEM_BROWSER) : this.getUrlDisplayData(this.fCorrectedUrl.toString(), this.fDefaultDestination);
        return new UrlDisplayBehavior(this.fCorrectedUrl, this.fUrlDisplayData.getDestination(), this.fUrlDisplayData.getHelpBrowser());
    }

    private UrlDisplayData getUrlDisplayData(String string, UrlDisplayBehavior.Destination destination) {
        switch (destination) {
            case NEW_HELP_BROWSER: {
                return this.createNewBrowserData();
            }
            case CURRENT_HELP_BROWSER: {
                return this.createCurrentBrowserData();
            }
        }
        return this.createDefaultData(string);
    }

    private UrlDisplayData createNewBrowserData() {
        if (this.fDependencyProvider.getNumberHelpBrowserTabs() >= this.fDependencyProvider.getBrowserTabMaximum()) {
            return new UrlDisplayData(UrlDisplayBehavior.Destination.CURRENT_HELP_BROWSER, this.fDependencyProvider.getActiveHelpBrowserTab());
        }
        return new UrlDisplayData(UrlDisplayBehavior.Destination.NEW_HELP_BROWSER, null);
    }

    private UrlDisplayData createCurrentBrowserData() {
        MLHelpBrowser mLHelpBrowser = this.fDependencyProvider.getActiveHelpBrowserTab();
        if (mLHelpBrowser == null) {
            return new UrlDisplayData(UrlDisplayBehavior.Destination.NEW_HELP_BROWSER, null);
        }
        return new UrlDisplayData(UrlDisplayBehavior.Destination.CURRENT_HELP_BROWSER, mLHelpBrowser);
    }

    private UrlDisplayData createDefaultData(String string) {
        MLHelpBrowser mLHelpBrowser = this.fDependencyProvider.getHelpBrowserTabShowingUrl(string);
        if (mLHelpBrowser != null) {
            return new UrlDisplayData(UrlDisplayBehavior.Destination.REQUEST_FOCUS_IN_HELP_BROWSER, mLHelpBrowser);
        }
        return this.createNewBrowserData();
    }

    protected UrlDisplayBehavior transformCustomProtocolUrl(CustomProtocolUrl customProtocolUrl) {
        this.fCorrectedUrl = customProtocolUrl;
        return new UrlDisplayBehavior(this.fCorrectedUrl, UrlDisplayBehavior.Destination.NEW_HELP_BROWSER);
    }

    private static class UrlDisplayData {
        private final UrlDisplayBehavior.Destination iDestination;
        private final MLHelpBrowser iHelpBrowser;

        private UrlDisplayData(UrlDisplayBehavior.Destination destination) {
            this(destination, (MLHelpBrowser)null);
        }

        private UrlDisplayData(UrlDisplayBehavior.Destination destination, MLHelpBrowser mLHelpBrowser) {
            this.iDestination = destination;
            this.iHelpBrowser = mLHelpBrowser;
        }

        private UrlDisplayBehavior.Destination getDestination() {
            return this.iDestination;
        }

        private MLHelpBrowser getHelpBrowser() {
            return this.iHelpBrowser;
        }
    }
}

