/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.helpsearch.ContentFormat;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTable;
import com.mathworks.product.util.ProductIdentifier;
import com.mathworks.services.ColorPrefs;
import com.mathworks.widgets.ComponentBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.EventObject;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

class ProductTablePanel
implements ComponentBuilder {
    private final MJPanel fTablePanel = new MJPanel((LayoutManager)new BorderLayout());
    private final ProductFilterModel fTableModel;
    private final MJTable fTable;
    private boolean fProductFilterEnabled;
    private boolean fEnableNonRefPages = true;

    ProductTablePanel() {
        this(false);
    }

    ProductTablePanel(boolean bl) {
        this.fTablePanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.fTablePanel.putClientProperty((Object)"mwjavaguitest.instance", (Object)this);
        this.fTableModel = new ProductFilterModel(this, bl);
        this.fTable = new MJTable((TableModel)this.fTableModel);
        this.fTable.setName("Product Filter Table");
        this.fTable.setShowGrid(false);
        this.fTable.setAutoResizeMode(3);
        this.fTable.setTableHeader(null);
        this.fTable.setRowSelectionAllowed(true);
        this.fTable.setColumnSelectionAllowed(false);
        this.fTable.setCellViewerEnabled(true);
        this.fTable.setRowSelectionInterval(0, 0);
        TableColumn tableColumn = this.fTable.getColumnModel().getColumn(0);
        ProductTableEditor productTableEditor = new ProductTableEditor();
        tableColumn.setCellEditor(productTableEditor);
        ProductTableRenderer productTableRenderer = new ProductTableRenderer();
        tableColumn.setCellRenderer(productTableRenderer);
        tableColumn.setMaxWidth((int)productTableRenderer.getPreferredSize().getWidth() + 5);
        tableColumn.setResizable(false);
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.fTable);
        mJScrollPane.getViewport().setBackground(Color.white);
        this.fTable.setBackground(ColorPrefs.getBackgroundColor());
        mJScrollPane.getViewport().setBackground(ColorPrefs.getBackgroundColor());
        this.fTable.setForeground(ColorPrefs.getTextColor());
        this.fTablePanel.add((Component)mJScrollPane, (Object)"Center");
    }

    public JComponent getComponent() {
        return this.fTablePanel;
    }

    int getTableRowHeight() {
        return this.fTable.getRowHeight();
    }

    void addTableModelListener(TableModelListener tableModelListener) {
        if (tableModelListener != null) {
            this.fTableModel.addTableModelListener(tableModelListener);
        }
    }

    void removeTableModelListener(TableModelListener tableModelListener) {
        if (tableModelListener != null) {
            this.fTableModel.removeTableModelListener(tableModelListener);
        }
    }

    void resetProducts() {
        this.fTableModel.resetProducts();
    }

    Set<ProductIdentifier> getSelectedProducts() {
        return this.fTableModel.getSelectedProducts();
    }

    void fireTableDataChanged() {
        this.fTableModel.fireTableDataChanged();
    }

    public void selectAll() {
        this.fTableModel.selectAll();
    }

    public void clearAll() {
        this.fTableModel.clearAll();
    }

    public boolean isAllSelected() {
        return this.fTableModel.isAllSelected();
    }

    public boolean isAllCleared() {
        return this.fTableModel.isAllCleared();
    }

    void enableProductTable(boolean bl) {
        this.fProductFilterEnabled = bl;
        this.fTable.setEnabled(this.fProductFilterEnabled);
    }

    boolean isProductFilterEnabled() {
        return this.fProductFilterEnabled;
    }

    void setEnableNonRefPages(boolean bl) {
        this.fEnableNonRefPages = bl;
    }

    private ProductTableItem[] getProductTableItems(boolean bl) {
        return this.getProductIdentifierTableItems(bl);
    }

    private ProductTableItem[] getProductIdentifierTableItems(boolean bl) {
        ProductTableItem[] productTableItemArray;
        Collection collection = HelpPrefs.getInstalledProducts();
        ArrayList<ProductIdentifierTableItem> arrayList = new ArrayList<ProductIdentifierTableItem>();
        for (Object object : collection) {
            boolean bl2 = HelpPrefs.isInstalledProductSelected((String)object.getName());
            arrayList.add(new ProductIdentifierTableItem((ProductIdentifier)object, true, bl2));
        }
        if (bl) {
            productTableItemArray = HelpPrefs.getUninstalledProducts();
            for (ProductIdentifier productIdentifier : productTableItemArray) {
                boolean bl3 = HelpPrefs.isUninstalledProductSelected((String)productIdentifier.getName());
                arrayList.add(new ProductIdentifierTableItem(productIdentifier, false, bl3));
            }
        }
        productTableItemArray = arrayList.toArray(new ProductTableItem[arrayList.size()]);
        return productTableItemArray;
    }

    private class ProductTableEditor
    extends DefaultCellEditor {
        private ProductTableEditor() {
            super((JCheckBox)new MJCheckBox());
            ((JComponent)this.getComponent()).setBorder(BorderFactory.createEmptyBorder());
            ((AbstractButton)this.getComponent()).setHorizontalAlignment(0);
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            MJCheckBox mJCheckBox = (MJCheckBox)super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            mJCheckBox.setForeground(jTable.getForeground());
            mJCheckBox.setBackground(jTable.getBackground());
            mJCheckBox.setSelected(object != null && (Boolean)object != false);
            return mJCheckBox;
        }
    }

    private class ProductTableRenderer
    extends MJCheckBox
    implements TableCellRenderer {
        private ProductTableRenderer() {
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setForeground(jTable.getForeground());
            this.setBackground(jTable.getBackground());
            this.setSelected(object != null && (Boolean)object != false);
            if (ProductTablePanel.this.fProductFilterEnabled && (ProductTablePanel.this.fEnableNonRefPages || ProductTablePanel.this.fTableModel.hasRefPages(n))) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
            if (bl2) {
                this.setBorder(BorderFactory.createLineBorder(jTable.getForeground(), 1));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder());
            }
            this.setBorderPainted(bl2);
            return this;
        }
    }

    private class ProductFilterModel
    extends AbstractTableModel {
        private ProductTableItem[] fProductTableItem;
        private ProductTablePanel fProductTablePanel;

        private ProductFilterModel(ProductTablePanel productTablePanel2, boolean bl) {
            this.fProductTablePanel = productTablePanel2;
            this.fProductTableItem = ProductTablePanel.this.getProductTableItems(bl);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0 && (this.fProductTablePanel.fEnableNonRefPages || this.hasRefPages(n));
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.fProductTableItem.length;
        }

        public boolean isSelected(int n) {
            return this.fProductTableItem[n].isSelected();
        }

        public Set<ProductIdentifier> getSelectedProducts() {
            EnumSet<ProductIdentifier> enumSet = EnumSet.noneOf(ProductIdentifier.class);
            for (ProductTableItem productTableItem : this.fProductTableItem) {
                if (!productTableItem.isSelected()) continue;
                enumSet.add(productTableItem.getProductIdentifier());
            }
            return enumSet;
        }

        public void selectAll() {
            for (int i = 0; i < this.fProductTableItem.length; ++i) {
                if (!this.fProductTablePanel.fEnableNonRefPages && !this.hasRefPages(i)) continue;
                this.setSelected(i, true);
            }
            this.fireTableDataChanged();
        }

        public void clearAll() {
            for (int i = 0; i < this.fProductTableItem.length; ++i) {
                if (!this.fProductTablePanel.fEnableNonRefPages && !this.hasRefPages(i)) continue;
                this.setSelected(i, false);
            }
            this.fireTableDataChanged();
        }

        public boolean isAllSelected() {
            for (int i = 0; i < this.fProductTableItem.length; ++i) {
                if (this.fProductTableItem[i].isSelected()) continue;
                return false;
            }
            return true;
        }

        public boolean isAllCleared() {
            for (int i = 0; i < this.fProductTableItem.length; ++i) {
                if (!this.fProductTableItem[i].isSelected()) continue;
                return false;
            }
            return true;
        }

        public void resetProducts() {
            for (int i = 0; i < this.fProductTableItem.length; ++i) {
                if (this.fProductTableItem[i].getContentFormat() == ContentFormat.CLASSIC_DOC) {
                    this.setSelected(i, true);
                    continue;
                }
                if (this.fProductTableItem[i].isInstalled()) {
                    this.setSelected(i, HelpPrefs.isInstalledProductSelected((String)this.fProductTableItem[i].getProductName()));
                    continue;
                }
                this.setSelected(i, HelpPrefs.isUninstalledProductSelected((String)this.fProductTableItem[i].getProductName()));
            }
            this.fireTableDataChanged();
        }

        public void setSelected(int n, boolean bl) {
            this.setValueAt(bl, n, 0);
        }

        public String getName(int n) {
            return this.fProductTableItem[n].getProductName();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.fProductTableItem[n].isSelected();
            }
            return this.fProductTableItem[n].getProductName();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                this.fProductTableItem[n].setSelected(object != null && (Boolean)object != false);
            }
            this.fireTableCellUpdated(n, n2);
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            return this.fProductTableItem[0].getProductName().getClass();
        }

        public boolean hasRefPages(int n) {
            return this.fProductTableItem[n].hasRefPages();
        }
    }

    private class ProductIdentifierTableItem
    implements ProductTableItem {
        private final ProductIdentifier iProductIdentifier;
        private final boolean iInstalled;
        private boolean iSelected;

        private ProductIdentifierTableItem(ProductIdentifier productIdentifier, boolean bl, boolean bl2) {
            this.iProductIdentifier = productIdentifier;
            this.iInstalled = bl;
            this.iSelected = bl2;
        }

        @Override
        public boolean isSelected() {
            return this.iSelected;
        }

        @Override
        public String getProductName() {
            return this.iProductIdentifier.getName();
        }

        @Override
        public void setSelected(boolean bl) {
            this.iSelected = bl;
        }

        @Override
        public boolean hasRefPages() {
            return true;
        }

        @Override
        public boolean isInstalled() {
            return this.iInstalled;
        }

        @Override
        public ContentFormat getContentFormat() {
            return ContentFormat.DOC_CENTER_DOC;
        }

        @Override
        public ProductIdentifier getProductIdentifier() {
            return this.iProductIdentifier;
        }
    }

    private static interface ProductTableItem {
        public boolean isSelected();

        public String getProductName();

        public void setSelected(boolean var1);

        public boolean hasRefPages();

        public boolean isInstalled();

        public ContentFormat getContentFormat();

        public ProductIdentifier getProductIdentifier();
    }
}

