/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help.search;

import com.mathworks.mde.help.search.HelpBrowserSearchPrefs;
import com.mathworks.mlwidgets.help.search.DemoSearchEngine;
import com.mathworks.mlwidgets.help.search.DemoSearchResult;
import com.mathworks.mlwidgets.help.search.DocSearchEngine;
import com.mathworks.mlwidgets.help.search.DocSearchResult;
import com.mathworks.mlwidgets.help.search.RankedSearchResult;
import com.mathworks.mlwidgets.help.search.SearchCompletionObserver;
import com.mathworks.mlwidgets.help.search.SearchCriteria;
import com.mathworks.mlwidgets.help.search.SearchEngine;
import com.mathworks.mlwidgets.help.search.SearchResults;
import com.mathworks.search.SearchException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class MultiSearchEngine
implements SearchEngine<RankedSearchResult> {
    private SearchEngine<DocSearchResult> fDocEngine;
    private SearchEngine<DemoSearchResult> fDemoEngine;

    MultiSearchEngine() {
    }

    private MultiSearchEngine(SearchEngine<DocSearchResult> searchEngine, SearchEngine<DemoSearchResult> searchEngine2) {
        this.fDocEngine = searchEngine;
        this.fDemoEngine = searchEngine2;
    }

    public void search(SearchCriteria searchCriteria, SearchCompletionObserver<RankedSearchResult> searchCompletionObserver) {
        final ResultsCollector resultsCollector = new ResultsCollector(searchCompletionObserver, 2);
        this.getDocSearchEngine().search(searchCriteria, (SearchCompletionObserver)new SearchCompletionObserver<DocSearchResult>(){

            public void searchComplete(SearchResults<DocSearchResult> searchResults) {
                resultsCollector.addResults((SearchResults<? extends RankedSearchResult>)searchResults);
            }

            public void searchFailed(SearchException searchException) {
                resultsCollector.markFailure(searchException);
            }
        });
        this.getDemoSearchEngine().search(searchCriteria, (SearchCompletionObserver)new SearchCompletionObserver<DemoSearchResult>(){

            public void searchComplete(SearchResults<DemoSearchResult> searchResults) {
                resultsCollector.addResults((SearchResults<? extends RankedSearchResult>)searchResults);
            }

            public void searchFailed(SearchException searchException) {
                resultsCollector.markFailure(searchException);
            }
        });
    }

    private SearchEngine<DocSearchResult> getDocSearchEngine() {
        if (this.fDocEngine == null) {
            return DocSearchEngine.getInstance();
        }
        return this.fDocEngine;
    }

    private SearchEngine<DemoSearchResult> getDemoSearchEngine() {
        if (this.fDemoEngine == null) {
            return DemoSearchEngine.getInstance();
        }
        return this.fDemoEngine;
    }

    public void cleanup() {
    }

    private static int getMaxResults() {
        return HelpBrowserSearchPrefs.getMaxSearchResults();
    }

    private static class MultiSearchResultsIterator
    implements Iterator<RankedSearchResult> {
        private MultiSearchResults iResults;
        private int iNextIndex = 0;

        private MultiSearchResultsIterator(MultiSearchResults multiSearchResults) {
            this.iResults = multiSearchResults;
        }

        @Override
        public boolean hasNext() {
            return this.iNextIndex < this.iResults.getNumResults();
        }

        @Override
        public RankedSearchResult next() {
            if (this.hasNext()) {
                return this.iResults.getResult(this.iNextIndex++);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
        }
    }

    private static class RankedResultQueue
    implements Comparable<RankedResultQueue> {
        private RankedSearchResult iCurrentResult;
        private Iterator<? extends RankedSearchResult> iIterator;

        private RankedResultQueue(Iterator<? extends RankedSearchResult> iterator) {
            this.iIterator = iterator;
            if (this.iIterator.hasNext()) {
                this.iCurrentResult = iterator.next();
            }
        }

        private RankedSearchResult getCurrentResult() {
            return this.iCurrentResult;
        }

        private void next() {
            this.iCurrentResult = this.iIterator.next();
        }

        private boolean hasNext() {
            return this.iIterator.hasNext();
        }

        @Override
        public int compareTo(RankedResultQueue rankedResultQueue) {
            return this.getCurrentResult().compareTo((Object)rankedResultQueue.getCurrentResult());
        }
    }

    private static class MultiSearchResults
    implements SearchResults<RankedSearchResult> {
        private List<RankedSearchResult> iFoundResults = new ArrayList<RankedSearchResult>();
        private List<RankedResultQueue> iResultQueues = new ArrayList<RankedResultQueue>();
        private int iNumResults = 0;

        private MultiSearchResults() {
        }

        public synchronized RankedSearchResult getResult(int n) {
            if (n < this.getNumResults()) {
                if (n >= this.iFoundResults.size()) {
                    this.findResultsUpTo(n);
                }
                return this.iFoundResults.get(n);
            }
            return null;
        }

        public int getNumResults() {
            return Math.min(this.iNumResults, MultiSearchEngine.getMaxResults());
        }

        public Iterator<RankedSearchResult> iterator() {
            return new MultiSearchResultsIterator(this);
        }

        private synchronized void addResults(SearchResults<? extends RankedSearchResult> searchResults) {
            if (searchResults.getNumResults() > 0) {
                this.iResultQueues.add(new RankedResultQueue(searchResults.iterator()));
                this.iNumResults += searchResults.getNumResults();
            }
        }

        private void findResultsUpTo(int n) {
            int n2 = this.getNumResults();
            int n3 = Math.min(n2, n + 1) - this.iFoundResults.size();
            for (int i = 0; i < n3; ++i) {
                this.findNextResult();
            }
        }

        private void findNextResult() {
            RankedResultQueue rankedResultQueue = null;
            for (RankedResultQueue rankedResultQueue2 : this.iResultQueues) {
                if (rankedResultQueue != null && rankedResultQueue.compareTo(rankedResultQueue2) <= 0) continue;
                rankedResultQueue = rankedResultQueue2;
            }
            if (rankedResultQueue != null) {
                this.iFoundResults.add(rankedResultQueue.getCurrentResult());
                if (rankedResultQueue.hasNext()) {
                    rankedResultQueue.next();
                } else {
                    this.iResultQueues.remove(rankedResultQueue);
                }
            }
        }
    }

    private static class ResultsCollector {
        private int iNumExpected;
        private MultiSearchResults iMultiResults = new MultiSearchResults();
        private int iNumCompleted = 0;
        private SearchCompletionObserver<RankedSearchResult> iParentObserver;
        private boolean iFailed = false;

        private ResultsCollector(SearchCompletionObserver<RankedSearchResult> searchCompletionObserver, int n) {
            this.iNumExpected = n;
            this.iParentObserver = searchCompletionObserver;
        }

        private synchronized void markFailure(SearchException searchException) {
            if (!this.iFailed) {
                this.iFailed = true;
                this.iParentObserver.searchFailed(searchException);
            }
        }

        private synchronized void addResults(SearchResults<? extends RankedSearchResult> searchResults) {
            if (!this.iFailed) {
                this.iMultiResults.addResults((SearchResults<? extends RankedSearchResult>)searchResults);
                this.incrementCompletedSearches();
            }
        }

        private synchronized void incrementCompletedSearches() {
            ++this.iNumCompleted;
            if (this.iNumCompleted == this.iNumExpected) {
                this.iParentObserver.searchComplete((SearchResults)this.iMultiResults);
            }
        }
    }
}

