/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.inspector;

import com.mathworks.jmi.Matlab;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mde.inspector.InspectorClient;
import com.mathworks.mde.inspector.SelectedBeanDisplay;
import com.mathworks.mlwidgets.inspector.InspectorUIResources;
import com.mathworks.mlwidgets.inspector.InspectorUpdateListener;
import com.mathworks.mlwidgets.inspector.JidePropertyViewTable;
import com.mathworks.mlwidgets.inspector.PropertyView;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.SynchronousInvokeUtility;
import com.mathworks.services.ObjectRegistry;
import com.mathworks.services.Prefs;
import com.mathworks.widgets.desk.DTClientBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public final class Inspector
extends MJPanel {
    private static final String BOUNDS_PREF = "InspectorWindowBounds";
    private static final int INSPECTOR = 0;
    private static final int NUM_ICONS = 1;
    private boolean fShowReadOnly = true;
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.mathworks.mde.inspector.resources.RES_PropView");
    private static String INSPECTOR_TITLE = resourceBundle.getString("frame.titleInspector");
    private static String INSPECTOR_NAME = "Property Inspector";
    private static ImageIcon[] sIcons;
    private static MJFrame sInspectorWin;
    private static Inspector sInspector;
    private static InspectorClient sInspectorClient;
    private SelectedBeanDisplay fSelBeanDisplay;
    private PropertyView fPropView;
    private MJPanel fMainPanel;
    private MJFrame fFrame;
    private static boolean sIsDesktopClient;

    public static void setDesktopClient(boolean bl) {
        sIsDesktopClient = bl;
    }

    private Inspector(ObjectRegistry objectRegistry) {
        this.setOpaque(false);
        this.fPropView = new PropertyView(objectRegistry, PropertyView.ToolBarStyle.GROUPTOOLBAR);
        this.fPropView.setName("Properties Panel");
        this.fPropView.addInspectorUpdateListener(new InspectorUpdateListener(){

            public void inspectorUpdated(Object[] objectArray) {
                Inspector.this.updateMenuBar_EventThread(objectArray);
            }
        });
        this.fMainPanel = new MJPanel((LayoutManager)new BorderLayout());
        this.fMainPanel.add((Component)this.fPropView, (Object)"Center");
        this.setLayout(new BorderLayout());
        this.add((Component)this.fMainPanel, "Center");
        this.setPreferredSize(InspectorUIResources.getPreferredSize());
    }

    private Inspector(MJFrame mJFrame, ObjectRegistry objectRegistry) {
        this.fFrame = mJFrame;
        this.setOpaque(false);
        this.fPropView = new PropertyView(objectRegistry, PropertyView.ToolBarStyle.GROUPTOOLBAR);
        this.fPropView.setName("Properties Panel");
        this.fPropView.addInspectorUpdateListener(new InspectorUpdateListener(){

            public void inspectorUpdated(Object[] objectArray) {
                Inspector.this.updateMenuBar_EventThread(objectArray);
            }
        });
        this.fMainPanel = new MJPanel((LayoutManager)new BorderLayout());
        this.fMainPanel.add((Component)this.fPropView, (Object)"Center");
        if (!sIsDesktopClient && !PropertyView.isJide()) {
            this.fSelBeanDisplay = new SelectedBeanDisplay((JComponent)this.fMainPanel);
            this.fMainPanel.add((Component)((Object)this.fSelBeanDisplay), (Object)"North");
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.fMainPanel, "Center");
        this.setName("PropertyInspector");
        this.setPreferredSize(InspectorUIResources.getPreferredSize());
    }

    public PropertyView getPropertyView() {
        return this.fPropView;
    }

    public static void doRefresh() {
        if (sInspector != null) {
            sInspector.getPropertyView().doRefresh();
        }
    }

    public static String getRenderedTextForTesting(String string) {
        return sInspector.getPropertyView().getRenderedTextForTesting(string);
    }

    public static void setAutoUpdate(boolean bl) {
        PropertyView.setAutoUpdate((boolean)bl);
    }

    public static boolean isAutoUpdate() {
        return PropertyView.isAutoUpdate();
    }

    public static void setPropertyGrouping(boolean bl) {
        PropertyView.setPropertyGrouping((boolean)bl);
    }

    public static boolean isPropertyGrouping() {
        return PropertyView.isPropertyGrouping();
    }

    SelectedBeanDisplay getMenuBar() {
        return this.fSelBeanDisplay;
    }

    public void toTheFront() {
        if (sIsDesktopClient) {
            if (sInspectorClient != null) {
                System.out.println("ToDo: Inspector.java, toTheFront");
            }
        } else if (sInspectorWin != null) {
            sInspectorWin.toFront();
        }
    }

    private static void createInspectorDTClient() {
        SynchronousInvokeUtility.queueSynchronousEvent((SynchronousInvokeUtility.SynchronousEvent)new SynchronousInvokeUtility.SynchronousEventAdapter(new Runnable(){

            @Override
            public void run() {
                Inspector.createInspectorDTClientFcn();
            }
        }));
    }

    private static void createInspectorDTClientFcn() {
        assert (SwingUtilities.isEventDispatchThread());
        if (sInspectorClient == null || sInspector == null) {
            sInspectorClient = new InspectorClient();
            sInspector = new Inspector(ObjectRegistry.getLayoutRegistry());
            sInspectorClient.add((Component)((Object)sInspector));
            MLDesktop.getInstance().addClient((Component)((Object)sInspectorClient), INSPECTOR_NAME, true, null, true, null);
        }
    }

    private static void createInspector() {
        SynchronousInvokeUtility.queueSynchronousEvent((SynchronousInvokeUtility.SynchronousEvent)new SynchronousInvokeUtility.SynchronousEventAdapter(new Runnable(){

            @Override
            public void run() {
                Inspector.createInspectorFcn();
            }
        }));
    }

    private static void createInspectorFcn() {
        assert (SwingUtilities.isEventDispatchThread());
        if (sInspector == null || sInspectorWin == null) {
            sInspectorWin = new MJFrame(INSPECTOR_NAME);
            sInspectorWin.setName(INSPECTOR_NAME);
            sInspector = new Inspector(sInspectorWin, ObjectRegistry.getLayoutRegistry());
            sInspector.initIcons();
            sInspectorWin.setIconImage(sIcons[0].getImage());
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = sInspector.getPreferredSize();
            sInspectorWin.getContentPane().add("Center", (Component)((Object)sInspector));
            sInspectorWin.addWindowListener((WindowListener)new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    if (sInspector != null) {
                        sInspector.closeWindow();
                    }
                }
            });
            if (Prefs.exists((String)BOUNDS_PREF)) {
                Rectangle rectangle = Prefs.getRectanglePref((String)BOUNDS_PREF);
                Dimension dimension3 = PropertyView.isJide() ? InspectorUIResources.getPreferredSize() : new Dimension(rectangle.width, rectangle.height);
                Point point = MJUtilities.ensureOnScreen((Point)new Point(rectangle.x, rectangle.y), (Dimension)dimension3, (int)0);
                sInspectorWin.setBounds(point.x, point.y, rectangle.width, rectangle.height);
            } else {
                sInspectorWin.setLocation(dimension.width - dimension2.width - 10, 10);
                sInspectorWin.setBounds(new Rectangle(dimension2.width, dimension2.height));
            }
        }
    }

    void updateMenuBar_EventThread(final Object[] objectArray) {
        if (sIsDesktopClient && sInspectorClient != null) {
            Matlab.whenMatlabReady((Runnable)new Runnable(){

                @Override
                public void run() {
                    final String string = SelectedBeanDisplay.getLabel_MatlabThread(objectArray);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            sInspectorClient.setWindowTitle(INSPECTOR_TITLE + ":  " + string);
                        }
                    });
                }
            });
        } else if (PropertyView.isJide() && sInspectorWin != null) {
            Matlab.whenMatlabReady((Runnable)new Runnable(){

                @Override
                public void run() {
                    final String string = SelectedBeanDisplay.getLabel_MatlabThread(JidePropertyViewTable.filterOutInvalidObjects((Object[])objectArray));
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (sInspectorWin != null) {
                                sInspectorWin.setTitle(INSPECTOR_TITLE + ":  " + string);
                            }
                        }
                    });
                }
            });
        } else if (this.fSelBeanDisplay != null) {
            this.fSelBeanDisplay.updateNameAndLabel_AnyThread(objectArray);
        }
    }

    private static int closeDesktopClient() {
        sInspectorClient = null;
        return 0;
    }

    public int closeWindow() {
        if (sIsDesktopClient) {
            return Inspector.closeDesktopClient();
        }
        if (this.fFrame != null) {
            if (this.fFrame == sInspectorWin) {
                Rectangle rectangle = sInspectorWin.getBounds();
                Prefs.setRectanglePref((String)BOUNDS_PREF, (Rectangle)rectangle);
                sInspectorWin = null;
            }
            if (this == sInspector) {
                sInspector = null;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (Inspector.this.fPropView != null) {
                        Inspector.this.fPropView.cleanup_EventThread();
                    }
                    Inspector.this.fFrame.dispose();
                    PropertyView.fireAutopilotClosedEvent();
                }
            });
        }
        return 0;
    }

    private void initIcons() {
        if (sIcons == null) {
            URL uRL = ((Object)((Object)this)).getClass().getResource("/com/mathworks/mde/inspector/resources/inspectoricon.gif");
            sIcons = new ImageIcon[1];
            Inspector.sIcons[0] = new ImageIcon(uRL);
        }
    }

    static Inspector getInspector() {
        if (sIsDesktopClient) {
            Inspector.createInspectorDTClient();
        } else {
            Inspector.createInspector();
        }
        return sInspector;
    }

    private static void pushToFront_EventThread(Window window) {
        if (window != null) {
            if (!window.isVisible()) {
                window.setVisible(true);
            } else {
                window.toFront();
            }
        }
    }

    private static void pushToFront_AnyThread(final Window window) {
        if (SwingUtilities.isEventDispatchThread()) {
            Inspector.pushToFront_EventThread(window);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Inspector.pushToFront_EventThread(window);
                }
            });
        }
    }

    private static void pushToFront_EventThread(DTClientBase dTClientBase) {
        if (dTClientBase != null) {
            if (!dTClientBase.isVisible()) {
                dTClientBase.setVisible(true);
            } else {
                Inspector.pushToFrontDesktopClient();
            }
        }
    }

    private static void pushToFront_AnyThread(final DTClientBase dTClientBase) {
        if (SwingUtilities.isEventDispatchThread()) {
            Inspector.pushToFront_EventThread(dTClientBase);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Inspector.pushToFront_EventThread(dTClientBase);
                }
            });
        }
    }

    public static void activateInspector() {
        boolean bl = false;
        if (sIsDesktopClient) {
            if (sInspectorClient == null || sInspector == null) {
                Inspector.createInspectorDTClient();
                bl = true;
            }
            Inspector.pushToFront_AnyThread(sInspectorClient);
        } else {
            if (sInspectorWin == null || sInspector == null) {
                Inspector.createInspector();
                bl = true;
            }
            Inspector.pushToFront_AnyThread((Window)sInspectorWin);
        }
        if (bl) {
            Matlab.whenMatlabReady((Runnable)new Runnable(){

                @Override
                public void run() {
                    Object[] objectArray;
                    if (sInspector != null && (objectArray = sInspector.getRegistry().getSelectedObjects()) != null) {
                        Inspector.inspectObjectArray(objectArray);
                    }
                }
            });
        }
    }

    public static void inspectObject(Object object) {
        Inspector.inspectObject(object, true);
    }

    public static void inspectObject(Object object, boolean bl) {
        Object[] objectArray = new Object[]{object};
        Inspector.inspectObjectArray(objectArray, bl);
    }

    public ObjectRegistry getRegistry() {
        return this.fPropView.getRegistry();
    }

    public static void inspectObjectArray(Object[] objectArray) {
        Inspector.inspectObjectArray(objectArray, true);
    }

    private static void pushToFrontDesktopClient() {
        if (sInspectorClient != null) {
            MLDesktop.getInstance().showClient((Component)((Object)sInspectorClient), null, true);
        }
    }

    private static void inspectObjectArrayDesktopClient(Object[] objectArray, boolean bl) {
        if (sInspectorClient == null || !sInspectorClient.isVisible()) {
            Inspector.createInspectorDTClient();
            Inspector.pushToFront_AnyThread(sInspectorClient);
        }
        if (objectArray != null) {
            Inspector.setSelected(sInspector.getRegistry(), objectArray);
        }
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (sInspectorClient != null) {
                        Inspector.pushToFrontDesktopClient();
                    }
                }
            });
        }
    }

    public static void inspectObjectArray(Object[] objectArray, boolean bl) {
        if (sIsDesktopClient) {
            Inspector.inspectObjectArrayDesktopClient(objectArray, bl);
            return;
        }
        if (sInspectorWin == null || !sInspectorWin.isVisible()) {
            Inspector.createInspector();
            Inspector.pushToFront_AnyThread((Window)sInspectorWin);
        }
        if (objectArray != null) {
            Inspector.setSelected(sInspector.getRegistry(), objectArray);
        }
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (sInspectorWin != null) {
                        sInspectorWin.toFront();
                    }
                }
            });
        }
    }

    private static void setSelected(ObjectRegistry objectRegistry, Object[] objectArray) {
        objectRegistry.setSelected(objectArray, true);
    }

    public static Inspector getInstance() {
        return sInspector;
    }

    public static void inspectIfOpen(Object object) {
        ObjectRegistry objectRegistry = sInspector != null ? sInspector.getRegistry() : ObjectRegistry.getLayoutRegistry();
        Object[] objectArray = object instanceof Object[] ? (Object[])object : new Object[]{object};
        Inspector.setSelected(objectRegistry, objectArray);
    }

    public void selectProperty(String string) {
        this.fPropView.selectProperty(string);
    }

    public static void refreshIfOpen() {
        if (sInspector != null) {
            ObjectRegistry objectRegistry = sInspector.getRegistry();
            Inspector.setSelected(objectRegistry, objectRegistry.getSelectedObjects());
        }
    }

    private static boolean isInspectorClientOpen() {
        return sInspectorClient != null && sInspector != null && sInspectorClient.isVisible();
    }

    public static boolean isInspectorOpen() {
        if (sIsDesktopClient) {
            return Inspector.isInspectorClientOpen();
        }
        return sInspectorWin != null && sInspector != null && sInspectorWin.isVisible();
    }

    public void setShowReadOnly(boolean bl) {
        this.fShowReadOnly = bl;
    }

    public static String getMixedValueDisplay() {
        return InspectorUIResources.getMixedValueDisplay();
    }

    static {
        sInspector = null;
        sIsDesktopClient = false;
    }
}

