/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.licensing.borrowing.model;

import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mde.licensing.borrowing.model.BorrowManager;
import com.mathworks.mde.licensing.borrowing.model.EventDispatchThreadCallback;
import com.mathworks.mde.licensing.borrowing.model.Feature;
import com.mathworks.mde.licensing.borrowing.model.FeatureImpl;
import com.mathworks.mde.licensing.borrowing.view.FailedFeature;
import com.mathworks.mde.licensing.borrowing.view.FailedFeatureImpl;
import com.mathworks.services.lmgr.FeatureData;
import com.mathworks.services.lmgr.JNIException;
import com.mathworks.services.lmgr.LmgrBorrowService;
import com.mathworks.services.lmgr.LmgrServiceFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

public class BorrowManagerImpl
implements BorrowManager {
    private LmgrBorrowService fLmgrBorrowService;
    private Collection<Feature> fFeatureList = new ArrayList<Feature>();
    private Boolean fHasBorrowableFeatures;
    private boolean autoBorrowMode;
    private String mlRoot;
    private String arch;
    private boolean canReturnEarly = true;

    public BorrowManagerImpl(String string, String string2) {
        this.mlRoot = string;
        this.arch = string2;
        this.fLmgrBorrowService = this.getBorrowService();
    }

    LmgrBorrowService getBorrowService() {
        LmgrBorrowService lmgrBorrowService = null;
        String string = this.mlRoot + File.separator + "bin" + File.separator + this.arch;
        try {
            lmgrBorrowService = LmgrServiceFactory.createBorrowService((String)string);
        }
        catch (JNIException jNIException) {
            jNIException.printStackTrace();
        }
        return lmgrBorrowService;
    }

    @Override
    public boolean isBorrowingEnabled() {
        if (this.fHasBorrowableFeatures == null) {
            this.fHasBorrowableFeatures = this.fLmgrBorrowService.hasBorrowableFeatures();
        }
        return this.fHasBorrowableFeatures;
    }

    @Override
    public void fetchBorrowData(final EventDispatchThreadCallback eventDispatchThreadCallback) {
        MatlabWorker matlabWorker = new MatlabWorker(){

            public Object runOnMatlabThread() throws Exception {
                BorrowManagerImpl.this.refreshFeatureList();
                BorrowManagerImpl.this.refreshAutoBorrowMode();
                return null;
            }

            public void runOnAWTEventDispatchThread(Object object) {
                eventDispatchThreadCallback.runOnAWTEventDispatchThread(object);
            }
        };
        matlabWorker.start();
    }

    private void refreshAutoBorrowMode() {
        this.autoBorrowMode = this.fLmgrBorrowService.getAutoBorrowMode();
    }

    private void refreshFeatureList() {
        this.fFeatureList.clear();
        Collection collection = this.fLmgrBorrowService.getFeatureData();
        for (FeatureData featureData : collection) {
            FeatureImpl featureImpl = new FeatureImpl(featureData);
            this.fFeatureList.add(featureImpl);
        }
    }

    @Override
    public void turnAutoBorrowOn(final int n, final Collection<FailedFeature> collection, final EventDispatchThreadCallback eventDispatchThreadCallback) {
        final StringBuffer stringBuffer = new StringBuffer("");
        MatlabWorker matlabWorker = new MatlabWorker(){

            public Object runOnMatlabThread() throws Exception {
                int n2 = BorrowManagerImpl.this.fLmgrBorrowService.autoBorrowModeOn(n, stringBuffer);
                if (n2 < 0) {
                    String string = BorrowManagerImpl.this.fLmgrBorrowService.getErrorMessage(stringBuffer.toString(), n2);
                    BorrowManagerImpl.this.buildErrorMsg(n2, stringBuffer.toString(), string, collection);
                }
                BorrowManagerImpl.this.refreshAutoBorrowMode();
                return null;
            }

            public void runOnAWTEventDispatchThread(Object object) {
                eventDispatchThreadCallback.runOnAWTEventDispatchThread(object);
            }
        };
        matlabWorker.start();
    }

    @Override
    public void turnAutoBorrowOff(final EventDispatchThreadCallback eventDispatchThreadCallback) {
        MatlabWorker matlabWorker = new MatlabWorker(){

            public Object runOnMatlabThread() throws Exception {
                BorrowManagerImpl.this.fLmgrBorrowService.autoBorrowModeOff();
                BorrowManagerImpl.this.refreshFeatureList();
                BorrowManagerImpl.this.refreshAutoBorrowMode();
                BorrowManagerImpl.this.canReturnEarly = false;
                return null;
            }

            public void runOnAWTEventDispatchThread(Object object) {
                eventDispatchThreadCallback.runOnAWTEventDispatchThread(object);
            }
        };
        matlabWorker.start();
    }

    @Override
    public void borrowFeatures(final int n, final Collection<Feature> collection, final Collection<FailedFeature> collection2, final EventDispatchThreadCallback eventDispatchThreadCallback) {
        MatlabWorker matlabWorker = new MatlabWorker(){

            public Object runOnMatlabThread() throws Exception {
                BorrowManagerImpl.this.borrowFeature(collection, n, collection2);
                BorrowManagerImpl.this.refreshFeatureList();
                BorrowManagerImpl.this.canReturnEarly = false;
                return null;
            }

            public void runOnAWTEventDispatchThread(Object object) {
                eventDispatchThreadCallback.runOnAWTEventDispatchThread(object);
            }
        };
        matlabWorker.start();
    }

    @Override
    public void returnFeatures(final Collection<Feature> collection, final Collection<FailedFeature> collection2, final EventDispatchThreadCallback eventDispatchThreadCallback) {
        MatlabWorker matlabWorker = new MatlabWorker(){

            public Object runOnMatlabThread() throws Exception {
                BorrowManagerImpl.this.returnFeature(collection, collection2);
                BorrowManagerImpl.this.refreshFeatureList();
                return null;
            }

            public void runOnAWTEventDispatchThread(Object object) {
                eventDispatchThreadCallback.runOnAWTEventDispatchThread(object);
            }
        };
        matlabWorker.start();
    }

    @Override
    public boolean getAutoBorrowMode() {
        return this.autoBorrowMode;
    }

    @Override
    public Collection<Feature> getFeatureList() {
        return this.fFeatureList;
    }

    @Override
    public boolean isEarlyReturnAllowed() {
        return this.canReturnEarly;
    }

    private void borrowFeature(Collection<Feature> collection, int n, Collection<FailedFeature> collection2) {
        for (Feature feature : collection) {
            int n2 = this.fLmgrBorrowService.borrowFeature(feature.getFeatureName(), n);
            if (n2 >= 0) continue;
            String string = this.fLmgrBorrowService.getErrorMessage(feature.getFeatureName(), n2);
            this.buildErrorMsg(n2, feature.getFeatureName(), string, collection2);
        }
    }

    private void returnFeature(Collection<Feature> collection, Collection<FailedFeature> collection2) {
        for (Feature feature : collection) {
            int n = this.fLmgrBorrowService.returnFeature(feature.getFeatureName());
            if (n >= 0) continue;
            String string = this.fLmgrBorrowService.getErrorMessage(feature.getFeatureName(), n);
            this.buildErrorMsg(n, feature.getFeatureName(), string, collection2);
        }
    }

    private void buildErrorMsg(int n, String string, String string2, Collection<FailedFeature> collection) {
        FailedFeatureImpl failedFeatureImpl = new FailedFeatureImpl(string, n, string2);
        collection.add(failedFeatureImpl);
    }
}

