/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.richeditor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public final class DirtyStateSupport {
    private final AtomicBoolean fDirtyState = new AtomicBoolean(false);
    private final List<DirtyStateListener> fDirtyListeners = new ArrayList<DirtyStateListener>();

    public boolean isDirty() {
        return this.fDirtyState.get();
    }

    public void setDirty(boolean bl) {
        this.fDirtyState.set(bl);
        for (DirtyStateListener dirtyStateListener : this.fDirtyListeners) {
            dirtyStateListener.handleDirtyStateChanged(bl);
        }
    }

    public void addDirtyListener(DirtyStateListener dirtyStateListener) {
        this.fDirtyListeners.add(dirtyStateListener);
    }

    public void removeDirtyListener(DirtyStateListener dirtyStateListener) {
        this.fDirtyListeners.remove(dirtyStateListener);
    }

    public static interface DirtyStateListener {
        public void handleDirtyStateChanged(boolean var1);
    }
}

