/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.richeditor;

import com.mathworks.matlab.api.datamodel.BackingStore;
import com.mathworks.matlab.api.datamodel.StorageLocation;
import com.mathworks.mde.richeditor.RichDocumentBackingStore;
import com.mathworks.mde.richeditor.widget.rtc.RichDocument;
import com.mathworks.util.PlatformInfo;
import java.io.File;

public final class RichEditor {
    private final RichDocument fRichDocument;
    private final BackingStore<RichDocument> fBackingStore;
    private String fPendingName;
    private static int sUntitledCount;
    private static final String UNTITLED_FILENAME_ON_WINDOWS = "Untitled";
    private static final String UNTITLED_FILENAME_ON_UNIX = "Untitled";
    private static final String RICH_CODE_EXTENSION = ".mlx";

    public RichEditor(BackingStore<RichDocument> backingStore, RichDocument richDocument) {
        this.fRichDocument = richDocument;
        this.fBackingStore = backingStore;
    }

    RichDocument getRichDocument() {
        return this.fRichDocument;
    }

    public String getLongName() {
        File file = ((RichDocumentBackingStore)this.fBackingStore).getFile();
        return file == null ? this.getPendingName() : file.getPath();
    }

    public String getShortName() {
        File file = ((RichDocumentBackingStore)this.fBackingStore).getFile();
        return file == null ? this.getPendingName() : file.getName();
    }

    void save() throws Exception {
        this.fBackingStore.save((Object)this.fRichDocument);
    }

    void load() throws Exception {
        this.fBackingStore.load((Object)this.fRichDocument);
    }

    File getFile() {
        return ((RichDocumentBackingStore)this.fBackingStore).getFile();
    }

    void setFile(File file) {
        ((RichDocumentBackingStore)this.fBackingStore).setFile(file);
    }

    StorageLocation getStorageLocation() {
        return this.fBackingStore.getStorageLocation();
    }

    public void setPendingName(String string) {
        this.fPendingName = string;
    }

    private String getPendingName() {
        if (this.fPendingName == null) {
            this.fPendingName = RichEditor.getNextUntitledFilename();
        }
        return this.fPendingName;
    }

    BackingStore<RichDocument> getBackingStore() {
        return this.fBackingStore;
    }

    private static String getNextUntitledFilename() {
        String string;
        String string2 = string = PlatformInfo.isWindows() ? "Untitled" : "Untitled";
        if (++sUntitledCount > 1) {
            string = string + sUntitledCount;
        }
        return string + RICH_CODE_EXTENSION;
    }

    public static int getUntitledCount() {
        return sUntitledCount;
    }
}

