/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.richeditor;

import com.mathworks.common.icons.ProvisionalIcon;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mde.desk.MLToolstripFactory;
import com.mathworks.mde.richeditor.ActionID;
import com.mathworks.mde.richeditor.ActionManager;
import com.mathworks.mde.richeditor.DirtyStateSupport;
import com.mathworks.mde.richeditor.RichEditorGroup;
import com.mathworks.mde.richeditor.widget.FeedbackDialog;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mwswing.ChildAction;
import com.mathworks.mwswing.IconSet;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.components.popups.ListStyle;
import com.mathworks.toolstrip.components.popups.PopupList;
import com.mathworks.toolstrip.factory.ContextTargetingManager;
import com.mathworks.toolstrip.factory.TSFactory;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.toolstrip.factory.TSToolSetContents;
import com.mathworks.util.Disposable;
import com.mathworks.widgets.desk.RecentFiles;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

final class RichEditorToolSetFactory {
    private final ActionManager fActionManager;
    private TSToolSet fToolSet;
    private Disposable fSaveActionDisposable;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.mathworks.mde.richeditor.resources.RES_RichEditor_Toolstrip");

    RichEditorToolSetFactory(ActionManager actionManager, DirtyStateSupport dirtyStateSupport) {
        this.fActionManager = actionManager;
        this.fToolSet = new TSToolSet(TSToolSetContents.readToolSetContents(RichEditorToolSetFactory.class, (String)"resources/RichEditorToolset.xml"));
        this.populateFileSection(dirtyStateSupport);
        this.populateNavigateSection();
        this.populateFormatSection();
        this.populateRegionSection();
        this.populateRunSection();
        this.populateUndoRedo();
        this.populateBetaSection();
    }

    TSToolSet getToolSet() {
        return this.fToolSet;
    }

    void dispose() {
        this.fSaveActionDisposable.dispose();
    }

    private void populateFileSection(DirtyStateSupport dirtyStateSupport) {
        this.populateToolSetWithAction(ActionID.NEW);
        this.populateToolSetWithAction(ActionID.NEW_RICH_SCRIPT);
        MLToolstripFactory.populateNewEditorFileActions(this.fToolSet, (MLDesktop)MatlabDesktopServices.getDesktop(), "new");
        this.populateToolSetWithAction(ActionID.FIND_FILES);
        this.populateOpenAction();
        this.fSaveActionDisposable = this.populateSaveAction(dirtyStateSupport);
    }

    private void populateOpenAction() {
        this.populateToolSetWithAction(ActionID.OPEN);
        this.fToolSet.configureAndAdd("default_open", (Action)new ChildAction((Action)this.fActionManager.getAction(ActionID.OPEN)));
        this.fToolSet.addListDecorator(ActionID.OPEN.getId(), new TSToolSet.ListDecorator(){

            public void decorateList(PopupList popupList) {
                RecentFiles recentFiles = MatlabDesktopServices.getDesktop().getRecentFiles();
                List list = recentFiles.getReopenActions(RichEditorGroup.getGroupName());
                if (!list.isEmpty()) {
                    DefaultListModel defaultListModel = (DefaultListModel)popupList.getModel();
                    defaultListModel.addElement(ListItem.newHeader((String)BUNDLE.getString("Tool.recent_group.Label")));
                    TSFactory.addToPopupList((PopupList)popupList, (List)list, (ListStyle)ListStyle.SINGLE_LINE_DESCRIPTION);
                }
            }
        });
        this.fToolSet.configureAndAdd("open_as_rich_code", (Action)new ChildAction((Action)this.fActionManager.getAction(ActionID.OPEN_AS_RICH_CODE)));
    }

    private void populateUndoRedo() {
        this.populateToolSetWithAction(ActionID.UNDO);
        this.populateToolSetWithAction(ActionID.REDO);
    }

    private void populateRegionSection() {
        this.populateToolSetWithAction(ActionID.CODE);
        this.populateToolSetWithAction(ActionID.TEXT);
        this.populateToolSetWithAction(ActionID.HEADING);
        this.populateToolSetWithAction(ActionID.TITLE);
        this.populateToolSetWithAction(ActionID.BULLETED_LIST);
        this.populateToolSetWithAction(ActionID.NUMBERED_LIST);
    }

    private void populateRunSection() {
        ChildAction childAction = new ChildAction((Action)this.fActionManager.getAction(ActionID.RUN_REFRESH_NOW));
        ChildAction childAction2 = new ChildAction((Action)this.fActionManager.getAction(ActionID.RUN), (Action)childAction){
            final /* synthetic */ Action val$runRefreshNowAction;
            {
                this.val$runRefreshNowAction = action2;
                super(action);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                super.actionPerformed(actionEvent);
                this.val$runRefreshNowAction.putValue("buttonIcon", RichEditorToolSetFactory.getRunIcon(false));
            }
        };
        this.fToolSet.configureAndAdd(ActionID.RUN.getId(), (Action)childAction2);
        ChildAction childAction3 = new ChildAction((Action)this.fActionManager.getAction(ActionID.LIVE), (Action)childAction){
            final /* synthetic */ Action val$runRefreshNowAction;
            {
                this.val$runRefreshNowAction = action2;
                super(action);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                super.actionPerformed(actionEvent);
                this.val$runRefreshNowAction.putValue("buttonIcon", RichEditorToolSetFactory.getRunIcon(true));
            }
        };
        this.fToolSet.configureAndAdd(ActionID.LIVE.getId(), (Action)childAction3);
        this.fToolSet.configureAndAdd(ActionID.RUN_REFRESH_NOW.getId(), (Action)childAction);
        childAction.putValue("buttonIcon", RichEditorToolSetFactory.getRunIcon(true));
        ContextTargetingManager.setPropertiesToInject((Action)childAction, (String[])new String[]{"buttonIcon"});
    }

    private void populateNavigateSection() {
        this.populateToolSetWithAction(ActionID.FIND);
        this.populateToolSetWithAction(ActionID.FIND_NEXT);
        this.populateToolSetWithAction(ActionID.FIND_PREVIOUS);
        this.populateToolSetWithAction(ActionID.FIND_SELECTION);
        this.fToolSet.configureAndAdd("default_find", (Action)new ChildAction((Action)this.fActionManager.getAction(ActionID.FIND)));
    }

    private void populateFormatSection() {
        this.populateToolSetWithAction(ActionID.BOLD);
        this.populateToolSetWithAction(ActionID.ITALIC);
        this.populateToolSetWithAction(ActionID.UNDERLINE);
        this.populateToolSetWithAction(ActionID.MONOSPACE);
        this.populateToolSetWithAction(ActionID.HYPERLINK);
        this.populateToolSetWithAction(ActionID.COMMENT);
        this.populateToolSetWithAction(ActionID.UNCOMMENT);
        this.populateToolSetWithAction(ActionID.INDENT);
        this.populateToolSetWithAction(ActionID.UNINDENT);
        this.populateToolSetWithAction(ActionID.SMART_INDENT);
        this.populateToolSetWithAction(ActionID.FIND);
        this.populateToolSetWithAction(ActionID.FIND);
    }

    private void populateBetaSection() {
        this.fToolSet.configureAndAdd("send_feedback", (Action)new ChildAction((Action)new MJAbstractAction(){
            JDialog iCacheFeebackDialog = null;

            public void actionPerformed(ActionEvent actionEvent) {
                if (this.iCacheFeebackDialog == null) {
                    String string = "Feedback for Rich Script Internal Beta";
                    String string2 = "matlab_editor2.0_beta@sharepoint.mathworks.com";
                    String string3 = "Enter feedback about Rich Script usage:";
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add("Rich Formatting");
                    arrayList.add("Output on the Right");
                    arrayList.add("Live Evaluation");
                    arrayList.add("MLX File");
                    arrayList.add("Figure Behavior");
                    arrayList.add("Other");
                    this.iCacheFeebackDialog = new FeedbackDialog(string, string2, string3, arrayList);
                    this.iCacheFeebackDialog.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosed(WindowEvent windowEvent) {
                            iCacheFeebackDialog = null;
                        }
                    });
                }
                this.iCacheFeebackDialog.setVisible(true);
            }
        }));
    }

    private Disposable populateSaveAction(final DirtyStateSupport dirtyStateSupport) {
        ChildAction childAction = new ChildAction((Action)this.fActionManager.getAction(ActionID.SAVE));
        this.fToolSet.configureAndAdd("default_save", (Action)childAction);
        boolean bl = dirtyStateSupport.isDirty();
        RichEditorToolSetFactory.updateSaveIcon((Action)childAction, bl);
        ContextTargetingManager.setPropertiesToInject((Action)childAction, (String[])new String[]{"buttonIcon"});
        this.fToolSet.configureAndAdd(ActionID.SAVE.getId(), (Action)childAction);
        this.populateToolSetWithAction(ActionID.SAVE_AS);
        final DirtyStateSupport.DirtyStateListener dirtyStateListener = new DirtyStateSupport.DirtyStateListener((Action)childAction){
            final /* synthetic */ Action val$saveAction;
            {
                this.val$saveAction = action;
            }

            @Override
            public void handleDirtyStateChanged(final boolean bl) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RichEditorToolSetFactory.updateSaveIcon(val$saveAction, bl);
                    }
                });
            }
        };
        dirtyStateSupport.addDirtyListener(dirtyStateListener);
        return new Disposable(){

            public void dispose() {
                dirtyStateSupport.removeDirtyListener(dirtyStateListener);
            }
        };
    }

    void populateToolSetWithAction(ActionID actionID) {
        this.fToolSet.configureAndAdd(actionID.getId(), (Action)new ChildAction((Action)this.fActionManager.getAction(actionID)));
    }

    private static void updateSaveIcon(Action action, boolean bl) {
        action.putValue("buttonIcon", RichEditorToolSetFactory.getSaveIcon(bl));
    }

    private static Icon getSaveIcon(boolean bl) {
        IconSet iconSet = new IconSet(Arrays.asList(ProvisionalIcon.SAVE_DIRTY_16.getIcon(), ProvisionalIcon.SAVE_DIRTY_24.getIcon()));
        IconSet iconSet2 = new IconSet(Arrays.asList(ProvisionalIcon.SAVE_16.getIcon(), ProvisionalIcon.SAVE_24.getIcon()));
        return bl ? iconSet : iconSet2;
    }

    private static Icon getRunIcon(boolean bl) {
        IconSet iconSet = new IconSet(Arrays.asList(new ImageIcon(RichEditorToolSetFactory.class.getResource("resources/icons/run_ts_16_bw.png")), new ImageIcon(RichEditorToolSetFactory.class.getResource("resources/icons/run_ts_24_bw.png"))));
        IconSet iconSet2 = new IconSet(Arrays.asList(ProvisionalIcon.RUN_16.getIcon(), ProvisionalIcon.RUN_24.getIcon()));
        return bl ? iconSet : iconSet2;
    }
}

