/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.richeditor.widget.rtc;

import com.mathworks.html.BrowserRequest;
import com.mathworks.html.CustomProtocolUrl;
import com.mathworks.html.FileUrl;
import com.mathworks.html.HtmlActionGroup;
import com.mathworks.html.HtmlCallbackProvider;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.RequestHandler;
import com.mathworks.html.StandardHtmlActionId;
import com.mathworks.html.UrlTransformer;
import com.mathworks.html.WebUrl;
import com.mathworks.mde.richeditor.widget.rtc.ConnectorFactory;
import com.mathworks.mde.richeditor.widget.rtc.DocumentEvent;
import com.mathworks.mde.richeditor.widget.rtc.DocumentListener;
import com.mathworks.mde.richeditor.widget.rtc.RichDocument;
import com.mathworks.mlwidgets.html.HTMLRenderer;
import com.mathworks.mlwidgets.html.HtmlComponentFactory;
import com.mathworks.mlwidgets.html.HtmlConversionUtils;
import com.mathworks.mlwidgets.html.MJHtmlPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.net.URL;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public final class RichTextComponent
extends JComponent {
    private final RichDocument fDocument;
    private DocumentListener fDocumentListener;
    private final HtmlComponent fHtmlComponent;
    private final JLabel fLoadingLabel;
    private String fURL;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.mathworks.mde.richeditor.widget.rtc.resources.RES_rtc");

    public RichTextComponent() {
        String string = String.valueOf(this.hashCode());
        this.fHtmlComponent = HtmlComponentFactory.buildHtmlComponent((HtmlComponentFactory.HtmlComponentType[])new HtmlComponentFactory.HtmlComponentType[]{HtmlComponentFactory.HtmlComponentType.CHROMIUM});
        HtmlConversionUtils.visitBrowser((HtmlComponent)this.fHtmlComponent, (HtmlConversionUtils.BrowserVisitor)new HtmlConversionUtils.BrowserVisitor(){

            public void visitMJHtmlPanel(MJHtmlPanel mJHtmlPanel) {
                mJHtmlPanel.setHtmlContextMenuBuilder(null);
                ((Action)mJHtmlPanel.getActions().getBasicActions().get(StandardHtmlActionId.FIND)).setEnabled(false);
                HtmlActionGroup htmlActionGroup = mJHtmlPanel.getActions().getCustomActionGroups().getCustomActionGroup("MatlabActions");
                for (String string : htmlActionGroup.getActionKeys()) {
                    htmlActionGroup.getCustomAction(string).setEnabled(false);
                    htmlActionGroup.getCustomAction(string).putValue("AcceleratorKey", null);
                }
                mJHtmlPanel.addRequestHandler(new RequestHandler(){

                    public boolean handleRequest(BrowserRequest browserRequest) {
                        UrlTransformer<Boolean> urlTransformer = new UrlTransformer<Boolean>(){

                            protected Boolean transformWebUrl(WebUrl webUrl) {
                                URL uRL = webUrl.toURL();
                                URL uRL2 = ConnectorFactory.getConnectorURL();
                                boolean bl = uRL.getAuthority().equals(uRL2.getAuthority()) && uRL.getProtocol().equals(uRL2.getProtocol());
                                return !bl;
                            }

                            protected Boolean transformFileUrl(FileUrl fileUrl) {
                                return false;
                            }

                            protected Boolean transformCustomProtocolUrl(CustomProtocolUrl customProtocolUrl) {
                                return false;
                            }
                        };
                        return (Boolean)urlTransformer.transformUrl(browserRequest.getUrl());
                    }
                });
            }

            public void visitHTMLRenderer(HTMLRenderer hTMLRenderer) {
                assert (false) : "We don't expect the HtmlComponent to be a HTMLRenderer";
            }
        });
        this.fHtmlComponent.disableNavigation();
        this.loadUrlWhenReady(string);
        this.fDocument = new RichDocument((HtmlCallbackProvider)this.fHtmlComponent, string);
        this.installListeners();
        this.setLayout(new GridBagLayout());
        this.fLoadingLabel = new JLabel(BUNDLE.getString("Loading.Label"));
        this.fLoadingLabel.setIcon(new ImageIcon(RichTextComponent.class.getResource("resources/icons/loading.gif")));
        this.add(this.fLoadingLabel);
    }

    private void installListeners() {
        this.fDocumentListener = new DocumentListener(){

            @Override
            public void eventFired(DocumentEvent documentEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RichTextComponent.this.remove(RichTextComponent.this.fLoadingLabel);
                        RichTextComponent.this.setLayout(new BorderLayout());
                        RichTextComponent.this.fHtmlComponent.getComponent().setSize(RichTextComponent.this.getSize());
                        RichTextComponent.this.add(RichTextComponent.this.fHtmlComponent.getComponent(), "Center");
                        RichTextComponent.this.revalidate();
                        if (RichTextComponent.this.getParent() != null && RichTextComponent.this.getParent().isFocusOwner()) {
                            RichTextComponent.this.requestFocus();
                        }
                    }
                });
            }
        };
        this.fDocument.addDocumentListener(DocumentEvent.EventType.INITIALIZED, this.fDocumentListener);
    }

    private void loadUrlWhenReady(final String string) {
        ConnectorFactory.runWhenReady(new Runnable(){

            @Override
            public void run() {
                RichTextComponent.this.fURL = ConnectorFactory.getConnectorURL() + "toolbox/matlab/codetools/richeditor/index.html?id=" + string;
                RichTextComponent.this.fHtmlComponent.setCurrentLocation(RichTextComponent.this.fURL);
            }
        });
    }

    public String getURL() {
        return this.fURL.replace("index.html", "index-debug.html");
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.requestFocusOnHtmlComponent();
    }

    private void requestFocusOnHtmlComponent() {
        Component[] componentArray;
        this.fHtmlComponent.getComponent().requestFocus();
        if (this.fHtmlComponent.getComponent() instanceof JComponent && (componentArray = ((JComponent)this.fHtmlComponent.getComponent()).getComponents()) != null && componentArray.length > 0) {
            componentArray[0].requestFocus();
        }
    }

    public RichDocument getDocument() {
        return this.fDocument;
    }

    public Map<String, Object> getContent() {
        return this.fDocument.getContent();
    }

    public void setContent(Map<String, Object> map) {
        this.fDocument.setContent(map);
    }

    public void dispose() {
        this.fHtmlComponent.dispose();
        this.fDocument.removeDocumentListener(this.fDocumentListener);
        this.fDocument.dispose();
    }
}

