/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.parallel.hadoop;

import com.mathworks.toolbox.parallel.hadoop.MatlabStartupFailureException;
import com.mathworks.toolbox.parallel.mapreduce.HadoopTaskAttemptID;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

class TaskUtils {
    private static final String ERROR_FOLDER_NAME = ".matlaberror";
    private static final String MDCE_DEBUG_ENVIRONMENT_VARIABLE = "MDCE_DEBUG";
    private static final String MDCE_DEBUG_TRUE_VALUE = "true";

    public static HadoopTaskAttemptID convertTaskAttemptID(TaskAttemptID taskAttemptID) {
        return new HadoopTaskAttemptID(taskAttemptID.getJobID().getId(), taskAttemptID.isMap() ? HadoopTaskAttemptID.TaskType.MAP : HadoopTaskAttemptID.TaskType.REDUCE, taskAttemptID.getTaskID().getId(), taskAttemptID.getId());
    }

    static void handleMatlabStartupException(Exception inE, HadoopTaskAttemptID attemptID, String finalOutputFolder, Configuration conf) throws MatlabStartupFailureException {
        MatlabStartupFailureException e = inE instanceof MatlabStartupFailureException ? (MatlabStartupFailureException)inE : new MatlabStartupFailureException("parallel:mapreduce:HadoopTaskOtherFailure", (Throwable)inE, Integer.toString(attemptID.getJobID()));
        List<String> messageInputs = e.getMessageInputs(Integer.toString(attemptID.getTaskAttemptID() + 1), attemptID.getTaskType().toString(), Integer.toString(attemptID.getTaskID()));
        TaskUtils.writeErrorFile(messageInputs, attemptID, finalOutputFolder, conf);
        throw e;
    }

    private static void writeErrorFile(List<String> errorInputs, HadoopTaskAttemptID attemptID, String finalOutputFolder, Configuration conf) {
        try {
            Path errorFolderPath = new Path(new Path(finalOutputFolder), ERROR_FOLDER_NAME);
            Path errorFilePath = new Path(errorFolderPath, attemptID + ".err");
            FileSystem fileSystem = FileSystem.get((URI)errorFolderPath.toUri(), (Configuration)conf);
            fileSystem.mkdirs(errorFolderPath);
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileSystem.create(errorFilePath));){
                for (String errorInput : errorInputs) {
                    writer.write(errorInput + "\n");
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    static boolean isMdceDebug() {
        String mdceDebugFlag = System.getenv(MDCE_DEBUG_ENVIRONMENT_VARIABLE);
        return mdceDebugFlag != null ? mdceDebugFlag.equals(MDCE_DEBUG_TRUE_VALUE) : false;
    }

    static boolean isWindowsPlatform() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    static void throwIfOutputFolderDoesNotExist(TaskAttemptContext context) throws IOException {
        Path outputPath = FileOutputFormat.getOutputPath((JobContext)context);
        FileSystem outputFS = outputPath.getFileSystem(context.getConfiguration());
        if (!outputFS.exists(outputPath) || !outputFS.isDirectory(outputPath)) {
            throw new MatlabStartupFailureException("parallel:mapreduce:InvalidHadoopOutputFolder", new String[0]);
        }
    }

    private TaskUtils() {
    }
}

