/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.fileservices.decorator;

import com.mathworks.matlabserver.fileservices.decorator.FileServiceAbstractDecorator;
import com.mathworks.matlabserver.internalservices.faults.MLSException;
import com.mathworks.matlabserver.internalservices.file.FileDO;
import com.mathworks.matlabserver.internalservices.file.FileInfoDO;
import com.mathworks.matlabserver.internalservices.file.FileService;
import com.mathworks.matlabserver.internalservices.security.UserTokenDO;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class FileServiceLoggingDecorator
extends FileServiceAbstractDecorator {
    private static final Logger logger = Logger.getLogger(FileServiceLoggingDecorator.class.getName());
    private String decoratedClassName;

    public FileServiceLoggingDecorator() {
    }

    public FileServiceLoggingDecorator(FileService fileService) {
        this.setDecoratedFileService(fileService);
        this.configureLogging();
    }

    private void configureLogging() {
        Handler[] handlers;
        logger.info("Reconfiguring logging");
        for (Handler handler : handlers = Logger.getLogger("").getHandlers()) {
            handler.setLevel(Level.FINEST);
            handler.setFormatter(new CustomFormatter());
        }
        logger.setLevel(Level.FINEST);
    }

    @Override
    public void setDecoratedFileService(FileService decoratedFileService) {
        super.setDecoratedFileService(decoratedFileService);
        this.decoratedClassName = decoratedFileService.getClass().getName();
    }

    @Override
    public InputStream readContent(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        logger.entering(this.decoratedClassName, "readContent:" + userToken.getName() + "," + this.getString(fileInfo));
        InputStream retVal = super.readContent(userToken, fileInfo);
        logger.exiting(this.decoratedClassName, "readContent:" + userToken.getName() + "," + this.getString(fileInfo));
        return retVal;
    }

    @Override
    public void readIncremental(UserTokenDO userToken, FileInfoDO fileInfo, ByteBuffer data, int size, int offset) throws MLSException {
        logger.entering(this.decoratedClassName, "readIncremental:" + userToken.getName() + "," + this.getString(fileInfo) + ",(" + size + "," + offset + ")");
        super.readIncremental(userToken, fileInfo, data, size, offset);
        logger.exiting(this.decoratedClassName, "readIncremental:" + userToken.getName() + "," + this.getString(fileInfo) + ",(" + size + "," + offset + ")");
    }

    @Override
    public FileInfoDO readInfo(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        logger.entering(this.decoratedClassName, "readInfo:" + userToken.getName() + "," + this.getString(fileInfo));
        FileInfoDO retVal = super.readInfo(userToken, fileInfo);
        logger.exiting(this.decoratedClassName, "readInfo:" + userToken.getName() + "," + this.getString(fileInfo));
        return retVal;
    }

    @Override
    public FileInfoDO updateInfo(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        logger.entering(this.decoratedClassName, "updateInfo:" + userToken.getName() + "," + this.getString(fileInfo));
        FileInfoDO retVal = super.updateInfo(userToken, fileInfo);
        logger.exiting(this.decoratedClassName, "updateInfo:" + userToken.getName() + "," + this.getString(fileInfo));
        return retVal;
    }

    @Override
    public FileInfoDO updateContent(UserTokenDO userToken, FileInfoDO fileInfo, InputStream contents) throws MLSException {
        logger.entering(this.decoratedClassName, "updateContent:" + userToken.getName() + "," + this.getString(fileInfo));
        FileInfoDO retVal = super.updateContent(userToken, fileInfo, contents);
        logger.exiting(this.decoratedClassName, "updateContent:" + userToken.getName() + "," + this.getString(fileInfo));
        return retVal;
    }

    @Override
    public void updateIncremental(UserTokenDO userToken, FileInfoDO fileInfo, ByteBuffer data, int size, int offset) throws MLSException {
        logger.entering(this.decoratedClassName, "updateIncremental:" + userToken.getName() + "," + this.getString(fileInfo) + ",(" + size + "," + offset + ")");
        super.updateIncremental(userToken, fileInfo, data, size, offset);
        logger.exiting(this.decoratedClassName, "updateIncremental:" + userToken.getName() + "," + this.getString(fileInfo) + ",(" + size + "," + offset + ")");
    }

    @Override
    public boolean exists(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        logger.entering(this.decoratedClassName, "exists:" + userToken.getName() + "," + this.getString(fileInfo));
        boolean retVal = super.exists(userToken, fileInfo);
        logger.exiting(this.decoratedClassName, "exists:" + userToken.getName() + "," + this.getString(fileInfo));
        return retVal;
    }

    @Override
    public FileDO open(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        logger.entering(this.decoratedClassName, "open:" + userToken.getName() + "," + this.getString(fileInfo));
        FileDO retVal = super.open(userToken, fileInfo);
        logger.exiting(this.decoratedClassName, "open:" + userToken.getName() + "," + this.getString(fileInfo));
        return retVal;
    }

    @Override
    public FileInfoDO close(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        logger.entering(this.decoratedClassName, "close:" + userToken.getName() + "," + this.getString(fileInfo));
        FileInfoDO retVal = super.close(userToken, fileInfo);
        logger.exiting(this.decoratedClassName, "close:" + userToken.getName() + "," + this.getString(fileInfo));
        return retVal;
    }

    @Override
    public FileInfoDO create(UserTokenDO userToken, FileDO file) throws MLSException {
        logger.entering(this.decoratedClassName, "create:" + userToken.getName() + "," + this.getString(file));
        FileInfoDO retVal = super.create(userToken, file);
        logger.exiting(this.decoratedClassName, "create:" + userToken.getName() + "," + this.getString(file));
        return retVal;
    }

    @Override
    public FileDO read(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        logger.entering(this.decoratedClassName, "read:" + userToken.getName() + "," + this.getString(fileInfo));
        FileDO retVal = super.read(userToken, fileInfo);
        logger.exiting(this.decoratedClassName, "read:" + userToken.getName() + "," + this.getString(fileInfo));
        return retVal;
    }

    @Override
    public FileInfoDO update(UserTokenDO userToken, FileDO file) throws MLSException {
        logger.entering(this.decoratedClassName, "update:" + userToken.getName() + "," + this.getString(file));
        FileInfoDO retVal = super.update(userToken, file);
        logger.exiting(this.decoratedClassName, "update:" + userToken.getName() + "," + this.getString(file));
        return retVal;
    }

    @Override
    public FileInfoDO delete(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        logger.entering(this.decoratedClassName, "delete:" + userToken.getName() + "," + this.getString(fileInfo));
        FileInfoDO retVal = super.delete(userToken, fileInfo);
        logger.exiting(this.decoratedClassName, "delete:" + userToken.getName() + "," + this.getString(fileInfo));
        return retVal;
    }

    @Override
    public FileInfoDO[] delete(UserTokenDO userToken, FileInfoDO[] fileInfoArray) throws MLSException {
        logger.entering(this.decoratedClassName, "delete[]:" + userToken.getName() + "," + this.getString(fileInfoArray));
        FileInfoDO[] retVal = super.delete(userToken, fileInfoArray);
        logger.exiting(this.decoratedClassName, "delete[]:" + userToken.getName() + "," + this.getString(fileInfoArray));
        return retVal;
    }

    @Override
    public FileInfoDO[] list(UserTokenDO userToken, FileInfoDO directory) throws MLSException {
        logger.entering(this.decoratedClassName, "list:" + userToken.getName() + "," + this.getString(directory));
        FileInfoDO[] retVal = super.list(userToken, directory);
        logger.exiting(this.decoratedClassName, "list:" + userToken.getName() + "," + this.getString(directory));
        return retVal;
    }

    @Override
    public FileInfoDO rename(UserTokenDO userToken, FileInfoDO originalFileInfo, FileInfoDO newFileInfo) throws MLSException {
        logger.entering(this.decoratedClassName, "rename:" + userToken.getName() + "," + this.getString(originalFileInfo) + "->" + this.getString(newFileInfo));
        FileInfoDO retVal = super.rename(userToken, originalFileInfo, newFileInfo);
        logger.exiting(this.decoratedClassName, "rename:" + userToken.getName() + "," + this.getString(originalFileInfo) + "->" + this.getString(newFileInfo));
        return retVal;
    }

    @Override
    public FileInfoDO[] move(UserTokenDO userToken, FileInfoDO[] sourceFileInfoArray, FileInfoDO destinationFileInfo) throws MLSException {
        logger.entering(this.decoratedClassName, "move[]:" + userToken.getName() + "," + this.getString(sourceFileInfoArray));
        FileInfoDO[] retVal = super.move(userToken, sourceFileInfoArray, destinationFileInfo);
        logger.exiting(this.decoratedClassName, "move[]:" + userToken.getName() + "," + this.getString(sourceFileInfoArray));
        return retVal;
    }

    private String getString(FileDO file) {
        return this.getString(file.getFileInfo());
    }

    private String getString(FileInfoDO[] fileInfoArray) {
        StringBuilder sb = new StringBuilder();
        if (fileInfoArray.length > 0) {
            sb.append(this.getString(fileInfoArray[0]));
            for (int i2 = 1; i2 < fileInfoArray.length; ++i2) {
                sb.append(",");
                sb.append(this.getString(fileInfoArray[i2]));
            }
        }
        return sb.toString();
    }

    private String getString(FileInfoDO fileInfo) {
        return fileInfo.getLocation() + fileInfo.getName();
    }

    private class CustomFormatter
    extends Formatter {
        private CustomFormatter() {
        }

        @Override
        public String format(LogRecord logRecord) {
            return String.format("[%1$tH:%1$tM:%1$tS:%1$tL]%2$s|T%3$d|%4$s:%5$s|%6$s\n", new Date(logRecord.getMillis()), logRecord.getLevel().getName(), logRecord.getThreadID(), logRecord.getSourceMethodName(), logRecord.getSourceClassName(), this.formatMessage(logRecord));
        }
    }
}

