/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.internalservices.workerprovider;

import com.mathworks.matlabserver.internalservices.common.VersionedModel;
import com.mathworks.matlabserver.internalservices.converter.BeanConverterManager;
import com.mathworks.matlabserver.internalservices.mrm.MetadataOwner;
import com.mathworks.matlabserver.internalservices.mrm.Resource;
import com.mathworks.matlabserver.internalservices.mrm.ResourceType;
import com.mathworks.matlabserver.internalservices.security.UserTokenDO;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class WorkerInfoDO
implements Resource,
Serializable,
VersionedModel,
MetadataOwner {
    private static final long serialVersionUID = 1L;
    private String description;
    private WorkerState state = WorkerState.UNDEFINED;
    private String ipaddress;
    private String workerId;
    private String machineId;
    private Date lastHeartbeatTimestamp;
    private boolean isDynamic;
    private final AtomicLong version = new AtomicLong();
    private final Map<String, String> metadata = new HashMap<String, String>();
    private UserTokenDO userToken;
    private String statusAsString;

    public WorkerInfoDO() {
    }

    public WorkerInfoDO(WorkerInfoDO src) {
        BeanConverterManager.getBeanConverter().copyProperties(this, src);
    }

    public String getMachineId() {
        return this.machineId;
    }

    public void setMachineId(String machineId) {
        this.machineId = machineId;
    }

    public boolean isInUse() {
        return this.state == WorkerState.IN_USE;
    }

    public boolean isAvailable() {
        return this.state == WorkerState.AVAILABLE;
    }

    public boolean isSick() {
        return this.state == WorkerState.SICK;
    }

    public boolean isParked() {
        return this.state == WorkerState.PARKED;
    }

    public boolean isRecycling() {
        return this.state == WorkerState.RECYCLING;
    }

    public String getUserName() {
        String userName = null;
        if (this.userToken != null) {
            userName = this.userToken.getName();
        }
        return userName;
    }

    public UserTokenDO getUserToken() {
        return this.userToken;
    }

    public String getStatusAsString() {
        return this.statusAsString;
    }

    public void setStatusAsString(String statusAsString) {
        this.statusAsString = statusAsString;
    }

    public void setUserToken(UserTokenDO userToken) {
        this.userToken = userToken;
    }

    public String getIpaddress() {
        return this.ipaddress;
    }

    public void setIpaddress(String ipaddress) {
        this.ipaddress = ipaddress;
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public WorkerState getState() {
        return this.state;
    }

    public void setState(WorkerState state) {
        this.state = state;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public void setDynamic(boolean isDynamic) {
        this.isDynamic = isDynamic;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        WorkerInfoDO that = (WorkerInfoDO)o2;
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.ipaddress != null ? !this.ipaddress.equals(that.ipaddress) : that.ipaddress != null) {
            return false;
        }
        if (this.state != that.state) {
            return false;
        }
        if (this.userToken != null ? !this.userToken.equals(that.userToken) : that.userToken != null) {
            return false;
        }
        if (this.workerId != null ? !this.workerId.equals(that.workerId) : that.workerId != null) {
            return false;
        }
        return this.isDynamic == that.isDynamic;
    }

    public int hashCode() {
        int result = this.description != null ? this.description.hashCode() : 0;
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.ipaddress != null ? this.ipaddress.hashCode() : 0);
        result = 31 * result + (this.workerId != null ? this.workerId.hashCode() : 0);
        result = 31 * result + (this.userToken != null ? this.userToken.hashCode() : 0);
        result = 31 * result + (this.isDynamic ? 1 : 0);
        return result;
    }

    public String toString() {
        return "WorkerInfoDO{description='" + this.description + '\'' + ", state=" + (Object)((Object)this.state) + ", ipaddress='" + this.ipaddress + '\'' + ", workerId='" + this.workerId + '\'' + ", userToken=" + this.userToken + ", isDynamic=" + this.isDynamic + '}';
    }

    @Override
    public long getVersion() {
        return this.version.get();
    }

    @Override
    public void setVersion(long version) {
        this.version.set(version);
    }

    @Override
    public String getMetadataAttribute(String attributeName) {
        return this.metadata.get(attributeName);
    }

    @Override
    public void setMetadataAttribute(String attributeName, String attributeValue) {
        this.metadata.put(attributeName, attributeValue);
    }

    @Override
    public Map<String, String> getMetadataAttributesAsMap() {
        return this.metadata != null ? Collections.unmodifiableMap(this.metadata) : Collections.emptyMap();
    }

    @Override
    public void setMetadataAttributesAsMap(Map<String, String> metadataAttributes) {
        this.metadata.putAll(metadataAttributes);
    }

    @Override
    public String getResourceId() {
        return this.workerId;
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MATLAB_WORKER;
    }

    public Date getLastHeartbeatTimestamp() {
        return this.lastHeartbeatTimestamp;
    }

    public void setLastHeartbeatTimestamp(Date lastHeartbeatTimestamp) {
        this.lastHeartbeatTimestamp = lastHeartbeatTimestamp;
    }

    public static enum WorkerState {
        UNDEFINED,
        IN_USE,
        AVAILABLE,
        SICK,
        PARKED,
        RECYCLING;

    }
}

