/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jsonconverter.impl.file;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mathworks.matlabserver.internalservices.file.FileInfoDO;
import com.mathworks.matlabserver.internalservices.file.ListFileRequestMessageDO;
import com.mathworks.matlabserver.jsonconverter.impl.util.JsonConverterUtil;
import java.lang.reflect.Type;

public class ListFileRequestConverter
implements JsonDeserializer<ListFileRequestMessageDO>,
JsonSerializer<ListFileRequestMessageDO> {
    @Override
    public JsonElement serialize(ListFileRequestMessageDO request, Type type, JsonSerializationContext jsonSerializationContext) {
        FileInfoDO fileInfo = request.getFileInfo();
        JsonElement jsonElement = fileInfo != null ? JsonConverterUtil.populateFromFileInfo(fileInfo, new JsonObject(), jsonSerializationContext, request) : new JsonObject();
        return jsonElement;
    }

    @Override
    public ListFileRequestMessageDO deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        ListFileRequestMessageDO request = new ListFileRequestMessageDO();
        request.setFileInfo(this.getFileInfo(jsonObject));
        request.setUuid(this.getUuid(jsonObject));
        return request;
    }

    private String getUuid(JsonObject jsonObject) {
        String retval = null;
        JsonElement element = jsonObject.get("uuid");
        if (element != null) {
            retval = element.getAsString();
        }
        return retval;
    }

    private FileInfoDO getFileInfo(JsonObject jsonObject) {
        String path;
        FileInfoDO fileInfo = null;
        JsonElement element = jsonObject.get("path");
        if (element != null && (path = element.getAsString()) != null) {
            fileInfo = new FileInfoDO(path);
        }
        return fileInfo;
    }
}

