/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jsonconverter.impl.file;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mathworks.matlabserver.internalservices.file.FileInfoDO;
import com.mathworks.matlabserver.internalservices.file.MoveMultipleFilesResponseMessageDO;
import java.lang.reflect.Type;
import java.util.logging.Logger;

public class MoveMultipleFilesResponseConverter
implements JsonDeserializer<MoveMultipleFilesResponseMessageDO>,
JsonSerializer<MoveMultipleFilesResponseMessageDO> {
    private static final Logger logger = Logger.getLogger(MoveMultipleFilesResponseConverter.class.getName());

    @Override
    public JsonElement serialize(MoveMultipleFilesResponseMessageDO o2, Type type, JsonSerializationContext jsonSerializationContext) {
        FileInfoDO[] srcFileInfoArray;
        JsonObject jsonObject = new JsonObject();
        MoveMultipleFilesResponseMessageDO response = o2;
        FileInfoDO[] fileInfoArray = response.getFileInfoArray();
        if (fileInfoArray != null && fileInfoArray.length > 0) {
            JsonElement element = jsonSerializationContext.serialize(fileInfoArray[0], (Type)((Object)FileInfoDO.class));
            jsonObject.add("fileInfo", element);
        }
        if ((srcFileInfoArray = response.getSrcFileInfoArray()) != null && srcFileInfoArray.length > 0) {
            JsonElement element = jsonSerializationContext.serialize(srcFileInfoArray[0], (Type)((Object)FileInfoDO.class));
            jsonObject.add("srcPath", element);
        }
        if (response.getFault() != null) {
            jsonObject.add("fault", jsonSerializationContext.serialize(response.getFault()));
        }
        if (response.getUuid() != null) {
            jsonObject.add("uuid", new JsonPrimitive(response.getUuid()));
        }
        JsonElement elementFaults = jsonSerializationContext.serialize(response.getMessageFaults(), response.getMessageFaults().getClass());
        jsonObject.add("messageFaults", elementFaults);
        return jsonObject;
    }

    @Override
    public MoveMultipleFilesResponseMessageDO deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        MoveMultipleFilesResponseMessageDO response = new MoveMultipleFilesResponseMessageDO();
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (type == MoveMultipleFilesResponseMessageDO.class) {
            JsonElement srcElement;
            JsonElement destElement = jsonObject.get("fileInfo");
            if (destElement != null) {
                FileInfoDO[] fileInfoArr = new FileInfoDO[1];
                FileInfoDO fileInfo = (FileInfoDO)jsonDeserializationContext.deserialize(destElement, (Type)((Object)FileInfoDO.class));
                this.splitNameFromPath(fileInfo);
                fileInfoArr[0] = fileInfo;
                response.setFileInfoArray(fileInfoArr);
            }
            if ((srcElement = jsonObject.get("srcPath")) != null) {
                FileInfoDO[] srcFileArr = new FileInfoDO[1];
                FileInfoDO srcFile = (FileInfoDO)jsonDeserializationContext.deserialize(srcElement, (Type)((Object)FileInfoDO.class));
                this.splitNameFromPath(srcFile);
                srcFileArr[0] = srcFile;
                response.setSrcFileInfoArray(srcFileArr);
            }
            response.setUuid(this.getUuid(jsonObject));
        }
        return response;
    }

    private String getUuid(JsonObject jsonObject) {
        String retval = null;
        JsonPrimitive element = jsonObject.getAsJsonPrimitive("uuid");
        if (element != null) {
            retval = ((JsonElement)element).getAsString();
        }
        return retval;
    }

    private void splitNameFromPath(FileInfoDO fileInfo) {
        if (fileInfo.getName() == null || fileInfo.getName().isEmpty()) {
            FileInfoDO standardFileInfo = new FileInfoDO(fileInfo.getLocation());
            fileInfo.setName(standardFileInfo.getName());
            fileInfo.setLocation(standardFileInfo.getLocation());
        }
    }
}

