/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.worker.service.eval.impl13b;

import com.mathworks.mvm.eventmgr.MvmListener;
import com.mathworks.mvm.eventmgr.SinkTextEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

public class MvmSinkTextListener
implements MvmListener<SinkTextEvent> {
    private static final Logger logger = Logger.getLogger(MvmSinkTextListener.class.getName());
    private final StringBuilder textBuffer = new StringBuilder();
    private final int maxBufferSize;
    private final int truncationSize;
    private final AtomicBoolean truncated = new AtomicBoolean(false);

    public MvmSinkTextListener(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
        this.truncationSize = maxBufferSize / 2;
    }

    public MvmSinkTextListener() {
        this(44100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBuffer() {
        try {
            this.truncated.set(false);
            StringBuilder stringBuilder = this.textBuffer;
            synchronized (stringBuilder) {
                this.textBuffer.delete(0, this.textBuffer.length());
            }
        }
        catch (Exception e2) {
            logger.warning(e2.getMessage());
        }
    }

    public String getBuffer() {
        return this.textBuffer.toString();
    }

    public boolean isTruncated() {
        return this.truncated.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mvmChanged(SinkTextEvent sinkTextEvent) {
        if (sinkTextEvent != null) {
            String text = sinkTextEvent.getText();
            SinkTextEvent.StreamTypeEnum type = sinkTextEvent.getStreamType();
            if (type != SinkTextEvent.StreamTypeEnum.ERROR_STREAM && text != null && text.length() > 0) {
                StringBuilder stringBuilder = this.textBuffer;
                synchronized (stringBuilder) {
                    this.textBuffer.append(text);
                    if (this.textBuffer.length() > this.maxBufferSize) {
                        this.truncated.set(true);
                        this.textBuffer.delete(0, this.textBuffer.length() - this.truncationSize);
                    }
                }
            }
        }
    }
}

