/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.messageservice.json;

import com.google.gson.BufferedImageConverter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mathworks.messageservice.json.JSONCustomConverters;
import com.mathworks.messageservice.json.converters.JSONTypeConverter;
import java.awt.image.BufferedImage;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JSONConverterImpl
implements JSONCustomConverters {
    private static final String TYPE_IMAGE = "image";
    private final Map<String, JSONTypeConverter> typeConverterRegistry;
    private Gson gson;
    Object jsonConverter = new MessageJSONCustomConverter();
    GsonBuilder gsonBuilder;
    private Map<String, JSONTypeConverter> customConverters = new HashMap<String, JSONTypeConverter>();

    public JSONConverterImpl() {
        this.gsonBuilder = new GsonBuilder();
        this.registerCustomConverters(this.gsonBuilder);
        this.typeConverterRegistry = new HashMap<String, JSONTypeConverter>();
        this.typeConverterRegistry.put(TYPE_IMAGE, new BufferedImageConverter());
        this.gson = this.gsonBuilder.create();
    }

    private void registerCustomConverters(GsonBuilder gsonBuilder) {
        gsonBuilder.registerTypeAdapter((Type)((Object)BufferedImage.class), this.jsonConverter);
        this.customConverters.put(TYPE_IMAGE, new BufferedImageConverter());
    }

    <T> T convertFromJson(String str, Class<T> theClass) {
        return this.gson.fromJson(str, theClass);
    }

    public Object convertFromJson(String str) {
        Object object = this.gson.fromJson(str, Object.class);
        if (object instanceof Map) {
            object = this.convertTreeMap((Map)object);
        }
        return this.convertObject(object);
    }

    private Object convertObject(Object object) {
        if (object instanceof List) {
            return this.convertList((List)object);
        }
        if (object instanceof Map) {
            return this.convertTreeMap((Map)object);
        }
        return object;
    }

    private Object convertList(List object) {
        Object[] array = object.toArray();
        for (int i2 = 0; i2 < array.length; ++i2) {
            array[i2] = this.convertObject(array[i2]);
        }
        if (this.isHomogeneous(array)) {
            Class<?> type = this.getArrayType(array);
            Object copy = Array.newInstance(type, Array.getLength(array));
            System.arraycopy(array, 0, copy, 0, Array.getLength(array));
            return copy;
        }
        return array;
    }

    private Object convertTreeMap(Map treeMap) {
        if (treeMap.keySet().size() == 2 && treeMap.containsKey("__type__") && treeMap.containsKey("__value__")) {
            String type = (String)treeMap.get("__type__");
            JSONTypeConverter converter = this.typeConverterRegistry.get(type);
            Object retval = converter != null ? converter.deserialize(treeMap) : null;
            return retval;
        }
        HashMap retval = new HashMap();
        Set entries = treeMap.entrySet();
        for (Map.Entry entry : entries) {
            ((Map)retval).put(entry.getKey(), this.convertObject(entry.getValue()));
        }
        return retval;
    }

    public String convertToJson(Object obj) {
        JsonElement jsonTree = obj instanceof Map ? this.gson.toJsonTree(obj, (Type)((Object)Map.class)) : this.gson.toJsonTree(obj, (Type)((Object)Object.class));
        return jsonTree.toString();
    }

    private boolean isHomogeneous(Object[] array) {
        if (array.length <= 1) {
            return true;
        }
        Class<?> firstElementType = array[0].getClass();
        for (Object o2 : array) {
            if (o2.getClass() == firstElementType) continue;
            return false;
        }
        return true;
    }

    private Class<?> getArrayType(Object[] object) {
        if (object.length > 0) {
            return object[0].getClass();
        }
        return Object.class;
    }

    @Override
    public void registerConverter(Class clazz, String property, JSONTypeConverter converter) {
        this.gsonBuilder.registerTypeHierarchyAdapter(clazz, this.jsonConverter);
        this.typeConverterRegistry.put(property, converter);
        this.customConverters.put(property, converter);
        this.gson = this.gsonBuilder.create();
    }

    public class MessageJSONCustomConverter
    implements JsonSerializer<Object> {
        @Override
        public JsonElement serialize(Object src, Type typeOfSrc, JsonSerializationContext context) {
            for (Map.Entry converterEntry : JSONConverterImpl.this.customConverters.entrySet()) {
                Class converterType = (Class)((ParameterizedType)((JSONTypeConverter)converterEntry.getValue()).getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0];
                if (!converterType.isAssignableFrom(src.getClass())) continue;
                JsonObject typeObj = new JsonObject();
                typeObj.addProperty("__type__", (String)converterEntry.getKey());
                typeObj.add("__value__", ((JSONTypeConverter)converterEntry.getValue()).serialize(src, context));
                return typeObj;
            }
            return context.serialize(src, src.getClass());
        }
    }
}

