/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SocketFetcher {
    private SocketFetcher() {
    }

    public static Socket getSocket(String host, int port, Properties props, String prefix, boolean useSSL) throws IOException {
        int localport;
        InetAddress localaddr;
        String timeout;
        Socket socket;
        int cto;
        block28: {
            if (prefix == null) {
                prefix = "socket";
            }
            if (props == null) {
                props = new Properties();
            }
            String s = props.getProperty(prefix + ".connectiontimeout", null);
            cto = -1;
            if (s != null) {
                try {
                    cto = Integer.parseInt(s);
                }
                catch (NumberFormatException nfex) {
                    // empty catch block
                }
            }
            socket = null;
            String sfClass = props.getProperty(prefix + ".socketFactory.class", null);
            timeout = props.getProperty(prefix + ".timeout", null);
            String localaddrstr = props.getProperty(prefix + ".localaddress", null);
            localaddr = null;
            if (localaddrstr != null) {
                localaddr = InetAddress.getByName(localaddrstr);
            }
            String localportstr = props.getProperty(prefix + ".localport", null);
            localport = 0;
            if (localportstr != null) {
                try {
                    localport = Integer.parseInt(localportstr);
                }
                catch (NumberFormatException nfex) {
                    // empty catch block
                }
            }
            if (sfClass != null && sfClass.length() > 0) {
                int sfPort = -1;
                boolean fb = false;
                String fallback = props.getProperty(prefix + ".socketFactory.fallback", null);
                fb = fallback == null || !fallback.equalsIgnoreCase("false");
                String sfPortStr = props.getProperty(prefix + ".socketFactory.port", null);
                if (sfPortStr != null) {
                    try {
                        sfPort = Integer.parseInt(sfPortStr);
                    }
                    catch (NumberFormatException nfex) {
                        // empty catch block
                    }
                }
                try {
                    ClassLoader cl = SocketFetcher.getContextClassLoader();
                    Class<?> clsSockFact = null;
                    if (cl != null) {
                        try {
                            clsSockFact = cl.loadClass(sfClass);
                        }
                        catch (ClassNotFoundException cex) {
                            // empty catch block
                        }
                    }
                    if (clsSockFact == null) {
                        clsSockFact = Class.forName(sfClass);
                    }
                    Method mthGetDefault = clsSockFact.getMethod("getDefault", new Class[0]);
                    SocketFactory sf = (SocketFactory)mthGetDefault.invoke(new Object(), new Object[0]);
                    if (sfPort == -1) {
                        sfPort = port;
                    }
                    socket = SocketFetcher.createSocket(localaddr, localport, host, sfPort, cto, sf, useSSL);
                }
                catch (SocketTimeoutException sex) {
                    throw sex;
                }
                catch (Exception ex) {
                    Throwable t;
                    if (fb) break block28;
                    if (ex instanceof InvocationTargetException && (t = ((InvocationTargetException)ex).getTargetException()) instanceof Exception) {
                        ex = (Exception)t;
                    }
                    if (ex instanceof IOException) {
                        throw (IOException)ex;
                    }
                    IOException ioex = new IOException("Couldn't connect using \"" + sfClass + "\" socket factory to host, port: " + host + ", " + sfPort + "; Exception: " + ex);
                    ioex.initCause(ex);
                    throw ioex;
                }
            }
        }
        if (socket == null) {
            socket = SocketFetcher.createSocket(localaddr, localport, host, port, cto, null, useSSL);
        }
        int to = -1;
        if (timeout != null) {
            try {
                to = Integer.parseInt(timeout);
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if (to >= 0) {
            socket.setSoTimeout(to);
        }
        return socket;
    }

    public static Socket getSocket(String host, int port, Properties props, String prefix) throws IOException {
        return SocketFetcher.getSocket(host, port, props, prefix, false);
    }

    private static Socket createSocket(InetAddress localaddr, int localport, String host, int port, int cto, SocketFactory sf, boolean useSSL) throws IOException {
        Socket socket = sf != null ? sf.createSocket() : (useSSL ? SSLSocketFactory.getDefault().createSocket() : new Socket());
        if (localaddr != null) {
            socket.bind(new InetSocketAddress(localaddr, localport));
        }
        if (cto >= 0) {
            socket.connect(new InetSocketAddress(host, port), cto);
        } else {
            socket.connect(new InetSocketAddress(host, port));
        }
        return socket;
    }

    public static Socket startTLS(Socket socket) throws IOException {
        InetAddress a2 = socket.getInetAddress();
        String host = a2.getHostName();
        int port = socket.getPort();
        try {
            SSLSocketFactory ssf = (SSLSocketFactory)SSLSocketFactory.getDefault();
            socket = ssf.createSocket(socket, host, port, true);
            ((SSLSocket)socket).setEnabledProtocols(new String[]{"TLSv1"});
        }
        catch (Exception ex) {
            Throwable t;
            if (ex instanceof InvocationTargetException && (t = ((InvocationTargetException)ex).getTargetException()) instanceof Exception) {
                ex = (Exception)t;
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            IOException ioex = new IOException("Exception in startTLS: host " + host + ", port " + port + "; Exception: " + ex);
            ioex.initCause(ex);
            throw ioex;
        }
        return socket;
    }

    private static ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader cl = null;
                try {
                    cl = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return cl;
            }
        });
    }
}

