/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeUtility;

public class InternetAddress
extends Address
implements Cloneable {
    protected String address;
    protected String personal;
    protected String encodedPersonal;
    private static final long serialVersionUID = -7507595530758302903L;
    private static final String rfc822phrase = "()<>@,;:\\\"\t .[]".replace(' ', '\u0000').replace('\t', '\u0000');
    private static final String specialsNoDotNoAt = "()<>,;:\\\"[]";
    private static final String specialsNoDot = "()<>,;:\\\"[]@";

    public InternetAddress() {
    }

    public InternetAddress(String address) throws AddressException {
        InternetAddress[] a2 = InternetAddress.parse(address, true);
        if (a2.length != 1) {
            throw new AddressException("Illegal address", address);
        }
        this.address = a2[0].address;
        this.personal = a2[0].personal;
        this.encodedPersonal = a2[0].encodedPersonal;
    }

    public InternetAddress(String address, boolean strict) throws AddressException {
        this(address);
        if (strict) {
            InternetAddress.checkAddress(this.address, true, true);
        }
    }

    public InternetAddress(String address, String personal) throws UnsupportedEncodingException {
        this(address, personal, null);
    }

    public InternetAddress(String address, String personal, String charset) throws UnsupportedEncodingException {
        this.address = address;
        this.setPersonal(personal, charset);
    }

    public Object clone() {
        InternetAddress a2 = null;
        try {
            a2 = (InternetAddress)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return a2;
    }

    public String getType() {
        return "rfc822";
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setPersonal(String name, String charset) throws UnsupportedEncodingException {
        this.personal = name;
        this.encodedPersonal = name != null ? MimeUtility.encodeWord(name, charset, null) : null;
    }

    public void setPersonal(String name) throws UnsupportedEncodingException {
        this.personal = name;
        this.encodedPersonal = name != null ? MimeUtility.encodeWord(name) : null;
    }

    public String getAddress() {
        return this.address;
    }

    public String getPersonal() {
        if (this.personal != null) {
            return this.personal;
        }
        if (this.encodedPersonal != null) {
            try {
                this.personal = MimeUtility.decodeText(this.encodedPersonal);
                return this.personal;
            }
            catch (Exception ex) {
                return this.encodedPersonal;
            }
        }
        return null;
    }

    public String toString() {
        if (this.encodedPersonal == null && this.personal != null) {
            try {
                this.encodedPersonal = MimeUtility.encodeWord(this.personal);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (this.encodedPersonal != null) {
            return InternetAddress.quotePhrase(this.encodedPersonal) + " <" + this.address + ">";
        }
        if (this.isGroup() || this.isSimple()) {
            return this.address;
        }
        return "<" + this.address + ">";
    }

    public String toUnicodeString() {
        String p2 = this.getPersonal();
        if (p2 != null) {
            return InternetAddress.quotePhrase(p2) + " <" + this.address + ">";
        }
        if (this.isGroup() || this.isSimple()) {
            return this.address;
        }
        return "<" + this.address + ">";
    }

    private static String quotePhrase(String phrase) {
        int len = phrase.length();
        boolean needQuoting = false;
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = phrase.charAt(i2);
            if (c2 == '\"' || c2 == '\\') {
                StringBuffer sb = new StringBuffer(len + 3);
                sb.append('\"');
                for (int j2 = 0; j2 < len; ++j2) {
                    char cc = phrase.charAt(j2);
                    if (cc == '\"' || cc == '\\') {
                        sb.append('\\');
                    }
                    sb.append(cc);
                }
                sb.append('\"');
                return sb.toString();
            }
            if ((c2 >= ' ' || c2 == '\r' || c2 == '\n' || c2 == '\t') && c2 < '\u007f' && rfc822phrase.indexOf(c2) < 0) continue;
            needQuoting = true;
        }
        if (needQuoting) {
            StringBuffer sb = new StringBuffer(len + 2);
            sb.append('\"').append(phrase).append('\"');
            return sb.toString();
        }
        return phrase;
    }

    private static String unquote(String s) {
        if (s.startsWith("\"") && s.endsWith("\"") && (s = s.substring(1, s.length() - 1)).indexOf(92) >= 0) {
            StringBuffer sb = new StringBuffer(s.length());
            for (int i2 = 0; i2 < s.length(); ++i2) {
                char c2 = s.charAt(i2);
                if (c2 == '\\' && i2 < s.length() - 1) {
                    c2 = s.charAt(++i2);
                }
                sb.append(c2);
            }
            s = sb.toString();
        }
        return s;
    }

    public boolean equals(Object a2) {
        if (!(a2 instanceof InternetAddress)) {
            return false;
        }
        String s = ((InternetAddress)a2).getAddress();
        if (s == this.address) {
            return true;
        }
        return this.address != null && this.address.equalsIgnoreCase(s);
    }

    public int hashCode() {
        if (this.address == null) {
            return 0;
        }
        return this.address.toLowerCase().hashCode();
    }

    public static String toString(Address[] addresses) {
        return InternetAddress.toString(addresses, 0);
    }

    public static String toString(Address[] addresses, int used) {
        if (addresses == null || addresses.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < addresses.length; ++i2) {
            String s;
            int len;
            if (i2 != 0) {
                sb.append(", ");
                used += 2;
            }
            if (used + (len = InternetAddress.lengthOfFirstSegment(s = addresses[i2].toString())) > 76) {
                sb.append("\r\n\t");
                used = 8;
            }
            sb.append(s);
            used = InternetAddress.lengthOfLastSegment(s, used);
        }
        return sb.toString();
    }

    private static int lengthOfFirstSegment(String s) {
        int pos = s.indexOf("\r\n");
        if (pos != -1) {
            return pos;
        }
        return s.length();
    }

    private static int lengthOfLastSegment(String s, int used) {
        int pos = s.lastIndexOf("\r\n");
        if (pos != -1) {
            return s.length() - pos - 2;
        }
        return s.length() + used;
    }

    public static InternetAddress getLocalAddress(Session session) {
        String user = null;
        String host = null;
        String address = null;
        try {
            if (session == null) {
                user = System.getProperty("user.name");
                host = InetAddress.getLocalHost().getHostName();
            } else {
                address = session.getProperty("mail.from");
                if (address == null) {
                    InetAddress me;
                    user = session.getProperty("mail.user");
                    if (user == null || user.length() == 0) {
                        user = session.getProperty("user.name");
                    }
                    if (user == null || user.length() == 0) {
                        user = System.getProperty("user.name");
                    }
                    if (((host = session.getProperty("mail.host")) == null || host.length() == 0) && (me = InetAddress.getLocalHost()) != null) {
                        host = me.getHostName();
                    }
                }
            }
            if (address == null && user != null && user.length() != 0 && host != null && host.length() != 0) {
                address = user + "@" + host;
            }
            if (address != null) {
                return new InternetAddress(address);
            }
        }
        catch (SecurityException sex) {
        }
        catch (AddressException ex) {
        }
        catch (UnknownHostException ex) {
            // empty catch block
        }
        return null;
    }

    public static InternetAddress[] parse(String addresslist) throws AddressException {
        return InternetAddress.parse(addresslist, true);
    }

    public static InternetAddress[] parse(String addresslist, boolean strict) throws AddressException {
        return InternetAddress.parse(addresslist, strict, false);
    }

    public static InternetAddress[] parseHeader(String addresslist, boolean strict) throws AddressException {
        return InternetAddress.parse(addresslist, strict, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static InternetAddress[] parse(String s, boolean strict, boolean parseHdr) throws AddressException {
        InternetAddress ma;
        int index;
        int start_personal = -1;
        int end_personal = -1;
        int length = s.length();
        boolean in_group = false;
        boolean route_addr = false;
        boolean rfc822 = false;
        Vector<InternetAddress> v = new Vector<InternetAddress>();
        int end = -1;
        int start = -1;
        block30: for (index = 0; index < length; ++index) {
            char c2 = s.charAt(index);
            switch (c2) {
                case '(': {
                    rfc822 = true;
                    if (start >= 0 && end == -1) {
                        end = index;
                    }
                    if (start_personal == -1) {
                        start_personal = index + 1;
                    }
                    ++index;
                    int nesting = 1;
                    while (index < length && nesting > 0) {
                        c2 = s.charAt(index);
                        switch (c2) {
                            case '\\': {
                                ++index;
                                break;
                            }
                            case '(': {
                                ++nesting;
                                break;
                            }
                            case ')': {
                                --nesting;
                                break;
                            }
                        }
                        ++index;
                    }
                    if (nesting > 0) {
                        throw new AddressException("Missing ')'", s, index);
                    }
                    --index;
                    if (end_personal != -1) continue block30;
                    end_personal = index;
                    continue block30;
                }
                case ')': {
                    throw new AddressException("Missing '('", s, index);
                }
                case '<': {
                    rfc822 = true;
                    if (route_addr) {
                        throw new AddressException("Extra route-addr", s, index);
                    }
                    if (!in_group) {
                        start_personal = start;
                        if (start_personal >= 0) {
                            end_personal = index;
                        }
                        start = index + 1;
                    }
                    boolean inquote = false;
                    ++index;
                    block32: while (index < length) {
                        c2 = s.charAt(index);
                        switch (c2) {
                            case '\\': {
                                ++index;
                                break;
                            }
                            case '\"': {
                                inquote = !inquote;
                                break;
                            }
                            case '>': {
                                if (!inquote) break block32;
                            }
                        }
                        ++index;
                    }
                    if (index >= length) {
                        if (inquote) {
                            throw new AddressException("Missing '\"'", s, index);
                        }
                        throw new AddressException("Missing '>'", s, index);
                    }
                    route_addr = true;
                    end = index;
                    continue block30;
                }
                case '>': {
                    throw new AddressException("Missing '<'", s, index);
                }
                case '\"': {
                    rfc822 = true;
                    if (start == -1) {
                        start = index;
                    }
                    ++index;
                    block33: while (index < length) {
                        c2 = s.charAt(index);
                        switch (c2) {
                            case '\\': {
                                ++index;
                                break;
                            }
                            case '\"': {
                                break block33;
                            }
                        }
                        ++index;
                    }
                    if (index < length) continue block30;
                    throw new AddressException("Missing '\"'", s, index);
                }
                case '[': {
                    rfc822 = true;
                    ++index;
                    block34: while (index < length) {
                        c2 = s.charAt(index);
                        switch (c2) {
                            case '\\': {
                                ++index;
                                break;
                            }
                            case ']': {
                                break block34;
                            }
                        }
                        ++index;
                    }
                    if (index < length) continue block30;
                    throw new AddressException("Missing ']'", s, index);
                }
                case ',': {
                    if (start == -1) {
                        route_addr = false;
                        rfc822 = false;
                        end = -1;
                        start = -1;
                        continue block30;
                    }
                    if (in_group) {
                        route_addr = false;
                        continue block30;
                    }
                    if (end == -1) {
                        end = index;
                    }
                    String addr = s.substring(start, end).trim();
                    if (rfc822 || strict || parseHdr) {
                        if (strict || !parseHdr) {
                            InternetAddress.checkAddress(addr, route_addr, false);
                        }
                        ma = new InternetAddress();
                        ma.setAddress(addr);
                        if (start_personal >= 0) {
                            ma.encodedPersonal = InternetAddress.unquote(s.substring(start_personal, end_personal).trim());
                            end_personal = -1;
                            start_personal = -1;
                        }
                        v.addElement(ma);
                    } else {
                        StringTokenizer st = new StringTokenizer(addr);
                        while (st.hasMoreTokens()) {
                            String a2 = st.nextToken();
                            InternetAddress.checkAddress(a2, false, false);
                            ma = new InternetAddress();
                            ma.setAddress(a2);
                            v.addElement(ma);
                        }
                    }
                    route_addr = false;
                    rfc822 = false;
                    end = -1;
                    start = -1;
                    continue block30;
                }
                case ':': {
                    rfc822 = true;
                    if (in_group) {
                        throw new AddressException("Nested group", s, index);
                    }
                    in_group = true;
                    if (start != -1) continue block30;
                    start = index;
                    continue block30;
                }
                case ';': {
                    if (start == -1) {
                        start = index;
                    }
                    if (!in_group) {
                        throw new AddressException("Illegal semicolon, not in group", s, index);
                    }
                    in_group = false;
                    if (start == -1) {
                        start = index;
                    }
                    ma = new InternetAddress();
                    end = index + 1;
                    ma.setAddress(s.substring(start, end).trim());
                    v.addElement(ma);
                    route_addr = false;
                    end = -1;
                    start = -1;
                    continue block30;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block30;
                }
                default: {
                    if (start != -1) continue block30;
                    start = index;
                }
            }
        }
        if (start >= 0) {
            if (end == -1) {
                end = index;
            }
            String addr = s.substring(start, end).trim();
            if (rfc822 || strict || parseHdr) {
                if (strict || !parseHdr) {
                    InternetAddress.checkAddress(addr, route_addr, false);
                }
                ma = new InternetAddress();
                ma.setAddress(addr);
                if (start_personal >= 0) {
                    ma.encodedPersonal = InternetAddress.unquote(s.substring(start_personal, end_personal).trim());
                }
                v.addElement(ma);
            } else {
                StringTokenizer st = new StringTokenizer(addr);
                while (st.hasMoreTokens()) {
                    String a3 = st.nextToken();
                    InternetAddress.checkAddress(a3, false, false);
                    ma = new InternetAddress();
                    ma.setAddress(a3);
                    v.addElement(ma);
                }
            }
        }
        Object[] a4 = new InternetAddress[v.size()];
        v.copyInto(a4);
        return a4;
    }

    public void validate() throws AddressException {
        InternetAddress.checkAddress(this.getAddress(), true, true);
    }

    private static void checkAddress(String addr, boolean routeAddr, boolean validate) throws AddressException {
        String domain;
        String local;
        int i2;
        int start = 0;
        if (addr.indexOf(34) >= 0) {
            return;
        }
        if (routeAddr) {
            start = 0;
            while ((i2 = InternetAddress.indexOfAny(addr, ",:", start)) >= 0) {
                if (addr.charAt(start) != '@') {
                    throw new AddressException("Illegal route-addr", addr);
                }
                if (addr.charAt(i2) == ':') {
                    start = i2 + 1;
                    break;
                }
                start = i2 + 1;
            }
        }
        if ((i2 = addr.indexOf(64, start)) >= 0) {
            if (i2 == start) {
                throw new AddressException("Missing local name", addr);
            }
            if (i2 == addr.length() - 1) {
                throw new AddressException("Missing domain", addr);
            }
            local = addr.substring(start, i2);
            domain = addr.substring(i2 + 1);
        } else {
            if (validate) {
                throw new AddressException("Missing final '@domain'", addr);
            }
            local = addr;
            domain = null;
        }
        if (InternetAddress.indexOfAny(addr, " \t\n\r") >= 0) {
            throw new AddressException("Illegal whitespace in address", addr);
        }
        if (InternetAddress.indexOfAny(local, specialsNoDot) >= 0) {
            throw new AddressException("Illegal character in local name", addr);
        }
        if (domain != null && domain.indexOf(91) < 0 && InternetAddress.indexOfAny(domain, specialsNoDot) >= 0) {
            throw new AddressException("Illegal character in domain", addr);
        }
    }

    private boolean isSimple() {
        return this.address == null || InternetAddress.indexOfAny(this.address, specialsNoDotNoAt) < 0;
    }

    public boolean isGroup() {
        return this.address != null && this.address.endsWith(";") && this.address.indexOf(58) > 0;
    }

    public InternetAddress[] getGroup(boolean strict) throws AddressException {
        Object groups = null;
        String addr = this.getAddress();
        if (!addr.endsWith(";")) {
            return null;
        }
        int ix = addr.indexOf(58);
        if (ix < 0) {
            return null;
        }
        String list = addr.substring(ix + 1, addr.length() - 1);
        return InternetAddress.parseHeader(list, strict);
    }

    private static int indexOfAny(String s, String any) {
        return InternetAddress.indexOfAny(s, any, 0);
    }

    private static int indexOfAny(String s, String any, int start) {
        try {
            int len = s.length();
            for (int i2 = start; i2 < len; ++i2) {
                if (any.indexOf(s.charAt(i2)) < 0) continue;
                return i2;
            }
            return -1;
        }
        catch (StringIndexOutOfBoundsException e2) {
            return -1;
        }
    }
}

