/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public abstract class ServletOutputStream
extends OutputStream {
    private static final String LSTRING_FILE = "javax.servlet.LocalStrings";
    private static ResourceBundle lStrings = ResourceBundle.getBundle("javax.servlet.LocalStrings");

    protected ServletOutputStream() {
    }

    public void print(String s) throws IOException {
        if (s == null) {
            s = "null";
        }
        int len = s.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = s.charAt(i2);
            if ((c2 & 0xFF00) != 0) {
                String errMsg = lStrings.getString("err.not_iso8859_1");
                Object[] errArgs = new Object[]{new Character(c2)};
                errMsg = MessageFormat.format(errMsg, errArgs);
                throw new CharConversionException(errMsg);
            }
            this.write(c2);
        }
    }

    public void print(boolean b2) throws IOException {
        String msg = b2 ? lStrings.getString("value.true") : lStrings.getString("value.false");
        this.print(msg);
    }

    public void print(char c2) throws IOException {
        this.print(String.valueOf(c2));
    }

    public void print(int i2) throws IOException {
        this.print(String.valueOf(i2));
    }

    public void print(long l2) throws IOException {
        this.print(String.valueOf(l2));
    }

    public void print(float f2) throws IOException {
        this.print(String.valueOf(f2));
    }

    public void print(double d2) throws IOException {
        this.print(String.valueOf(d2));
    }

    public void println() throws IOException {
        this.print("\r\n");
    }

    public void println(String s) throws IOException {
        this.print(s);
        this.println();
    }

    public void println(boolean b2) throws IOException {
        this.print(b2);
        this.println();
    }

    public void println(char c2) throws IOException {
        this.print(c2);
        this.println();
    }

    public void println(int i2) throws IOException {
        this.print(i2);
        this.println();
    }

    public void println(long l2) throws IOException {
        this.print(l2);
        this.println();
    }

    public void println(float f2) throws IOException {
        this.print(f2);
        this.println();
    }

    public void println(double d2) throws IOException {
        this.print(d2);
        this.println();
    }
}

