/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import java.util.Vector;
import org.apache.axiom.om.impl.dom.DOMMessageFormatter;
import org.apache.axiom.om.impl.dom.DocumentImpl;
import org.apache.axiom.om.impl.dom.NodeImpl;
import org.apache.axiom.om.impl.dom.ParentNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamedNodeMapImpl
implements NamedNodeMap {
    Vector nodes;
    ParentNode ownerNode;
    protected short flags;
    protected static final short READONLY = 1;
    protected static final short CHANGED = 2;
    protected static final short HASDEFAULTS = 4;

    protected NamedNodeMapImpl(ParentNode ownerNode) {
        this.ownerNode = ownerNode;
    }

    public Node getNamedItem(String name) {
        int i2 = this.findNamePoint(name, 0);
        return i2 < 0 ? null : (Node)this.nodes.elementAt(i2);
    }

    public Node item(int index) {
        return this.nodes != null && index < this.nodes.size() ? (Node)this.nodes.elementAt(index) : null;
    }

    public int getLength() {
        return this.nodes != null ? this.nodes.size() : 0;
    }

    public Node removeNamedItem(String name) throws DOMException {
        if (this.isReadOnly()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, msg);
        }
        int i2 = this.findNamePoint(name, 0);
        if (i2 < 0) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
            throw new DOMException(8, msg);
        }
        NodeImpl n2 = (NodeImpl)this.nodes.elementAt(i2);
        this.nodes.removeElementAt(i2);
        return n2;
    }

    public Node getNamedItemNS(String namespaceURI, String localName) {
        int i2 = this.findNamePoint(namespaceURI, localName);
        return i2 < 0 ? null : (Node)this.nodes.elementAt(i2);
    }

    public Node setNamedItemNS(Node arg) throws DOMException {
        DocumentImpl ownerDocument = (DocumentImpl)this.ownerNode.getOwnerDocument();
        if (this.isReadOnly()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, msg);
        }
        if (arg.getOwnerDocument() != ownerDocument) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null);
            throw new DOMException(4, msg);
        }
        int i2 = this.findNamePoint(arg.getNamespaceURI(), arg.getLocalName());
        NodeImpl previous = null;
        if (i2 >= 0) {
            previous = (NodeImpl)this.nodes.elementAt(i2);
            this.nodes.setElementAt(arg, i2);
        } else {
            i2 = this.findNamePoint(arg.getNodeName(), 0);
            if (i2 >= 0) {
                previous = (NodeImpl)this.nodes.elementAt(i2);
                this.nodes.insertElementAt(arg, i2);
            } else {
                i2 = -1 - i2;
                if (null == this.nodes) {
                    this.nodes = new Vector(5, 10);
                }
                this.nodes.insertElementAt(arg, i2);
            }
        }
        return previous;
    }

    public Node removeNamedItemNS(String namespaceURI, String name) throws DOMException {
        if (this.isReadOnly()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, msg);
        }
        int i2 = this.findNamePoint(namespaceURI, name);
        if (i2 < 0) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
            throw new DOMException(8, msg);
        }
        NodeImpl n2 = (NodeImpl)this.nodes.elementAt(i2);
        this.nodes.removeElementAt(i2);
        return n2;
    }

    public Node setNamedItem(Node arg) throws DOMException {
        DocumentImpl ownerDocument = (DocumentImpl)this.ownerNode.getOwnerDocument();
        if (this.isReadOnly()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, msg);
        }
        if (arg.getOwnerDocument() != ownerDocument) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null);
            throw new DOMException(4, msg);
        }
        int i2 = this.findNamePoint(arg.getNodeName(), 0);
        NodeImpl previous = null;
        if (i2 >= 0) {
            previous = (NodeImpl)this.nodes.elementAt(i2);
            this.nodes.setElementAt(arg, i2);
        } else {
            i2 = -1 - i2;
            if (null == this.nodes) {
                this.nodes = new Vector(5, 10);
            }
            this.nodes.insertElementAt(arg, i2);
        }
        return previous;
    }

    final boolean isReadOnly() {
        return (this.flags & 1) != 0;
    }

    final void isReadOnly(boolean value) {
        this.flags = (short)(value ? this.flags | 1 : this.flags & 0xFFFFFFFE);
    }

    final boolean changed() {
        return (this.flags & 2) != 0;
    }

    final void changed(boolean value) {
        this.flags = (short)(value ? this.flags | 2 : this.flags & 0xFFFFFFFD);
    }

    final boolean hasDefaults() {
        return (this.flags & 4) != 0;
    }

    final void hasDefaults(boolean value) {
        this.flags = (short)(value ? this.flags | 4 : this.flags & 0xFFFFFFFB);
    }

    protected int findNamePoint(String name, int start) {
        int i2 = 0;
        if (this.nodes != null) {
            int first = start;
            int last = this.nodes.size() - 1;
            while (first <= last) {
                i2 = (first + last) / 2;
                int test = name.compareTo(((Node)this.nodes.elementAt(i2)).getNodeName());
                if (test == 0) {
                    return i2;
                }
                if (test < 0) {
                    last = i2 - 1;
                    continue;
                }
                first = i2 + 1;
            }
            if (first > i2) {
                i2 = first;
            }
        }
        return -1 - i2;
    }

    protected int findNamePoint(String namespaceURI, String name) {
        if (this.nodes == null) {
            return -1;
        }
        if (name == null) {
            return -1;
        }
        for (int i2 = 0; i2 < this.nodes.size(); ++i2) {
            NodeImpl a2 = (NodeImpl)this.nodes.elementAt(i2);
            String aNamespaceURI = a2.getNamespaceURI();
            String aLocalName = a2.getLocalName();
            if (!(namespaceURI == null ? aNamespaceURI == null && (name.equals(aLocalName) || aLocalName == null && name.equals(a2.getNodeName())) : namespaceURI.equals(aNamespaceURI) && name.equals(aLocalName))) continue;
            return i2;
        }
        return -1;
    }

    protected boolean precedes(Node a2, Node b2) {
        if (this.nodes != null) {
            for (int i2 = 0; i2 < this.nodes.size(); ++i2) {
                Node n2 = (Node)this.nodes.elementAt(i2);
                if (n2 == a2) {
                    return true;
                }
                if (n2 != b2) continue;
                return false;
            }
        }
        return false;
    }

    protected void removeItem(int index) {
        if (this.nodes != null && index < this.nodes.size()) {
            this.nodes.removeElementAt(index);
        }
    }

    protected Object getItem(int index) {
        if (this.nodes != null) {
            return this.nodes.elementAt(index);
        }
        return null;
    }

    protected int addItem(Node arg) {
        int i2 = this.findNamePoint(arg.getNamespaceURI(), arg.getLocalName());
        if (i2 >= 0) {
            this.nodes.setElementAt(arg, i2);
        } else {
            i2 = this.findNamePoint(arg.getNodeName(), 0);
            if (i2 >= 0) {
                this.nodes.insertElementAt(arg, i2);
            } else {
                i2 = -1 - i2;
                if (null == this.nodes) {
                    this.nodes = new Vector(5, 10);
                }
                this.nodes.insertElementAt(arg, i2);
            }
        }
        return i2;
    }

    protected Vector cloneMap(Vector list) {
        if (list == null) {
            list = new Vector(5, 10);
        }
        list.setSize(0);
        if (this.nodes != null) {
            for (int i2 = 0; i2 < this.nodes.size(); ++i2) {
                list.insertElementAt(this.nodes.elementAt(i2), i2);
            }
        }
        return list;
    }

    protected int getNamedItemIndex(String namespaceURI, String localName) {
        return this.findNamePoint(namespaceURI, localName);
    }

    public void removeAll() {
        if (this.nodes != null) {
            this.nodes.removeAllElements();
        }
    }
}

