/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import javax.servlet.ServletInputStream;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.AbstractHttpConnection;

public class HttpInput
extends ServletInputStream {
    protected final AbstractHttpConnection _connection;
    protected final HttpParser _parser;

    public HttpInput(AbstractHttpConnection connection) {
        this._connection = connection;
        this._parser = (HttpParser)connection.getParser();
    }

    @Override
    public int read() throws IOException {
        byte[] bytes = new byte[1];
        int read = this.read(bytes, 0, 1);
        return read < 0 ? -1 : 0xFF & bytes[0];
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        int l2 = -1;
        Buffer content = this._parser.blockForContent(this._connection.getMaxIdleTime());
        if (content != null) {
            l2 = content.get(b2, off, len);
        } else if (this._connection.isEarlyEOF()) {
            throw new EofException("early EOF");
        }
        return l2;
    }

    @Override
    public int available() throws IOException {
        return this._parser.available();
    }
}

