/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.codegen;

import antlr.CommonToken;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStreamRewriteEngine;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.Tool;
import org.antlr.analysis.DFA;
import org.antlr.analysis.DFAOptimizer;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.Label;
import org.antlr.analysis.LookaheadSet;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.SemanticContext;
import org.antlr.analysis.Transition;
import org.antlr.codegen.ACyclicDFACodeGenerator;
import org.antlr.codegen.Target;
import org.antlr.grammar.v2.ANTLRLexer;
import org.antlr.grammar.v2.ANTLRParser;
import org.antlr.grammar.v2.CodeGenTreeWalker;
import org.antlr.grammar.v3.ActionTranslator;
import org.antlr.misc.BitSet;
import org.antlr.misc.IntSet;
import org.antlr.misc.Interval;
import org.antlr.misc.IntervalSet;
import org.antlr.misc.Utils;
import org.antlr.stringtemplate.CommonGroupLoader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateWriter;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;
import org.antlr.tool.AttributeScope;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarAST;
import org.antlr.tool.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeGenerator {
    public static final int MSCL_DEFAULT = 300;
    public static int MAX_SWITCH_CASE_LABELS = 300;
    public static final int MSA_DEFAULT = 3;
    public static int MIN_SWITCH_ALTS = 3;
    public boolean GENERATE_SWITCHES_WHEN_POSSIBLE = true;
    public static boolean EMIT_TEMPLATE_DELIMITERS = false;
    public static final int MADSI_DEFAULT = 10;
    public static int MAX_ACYCLIC_DFA_STATES_INLINE = 10;
    public String classpathTemplateRootDirectoryName = "org/antlr/codegen/templates";
    public Grammar grammar;
    protected String language;
    public Target target = null;
    protected StringTemplateGroup templates;
    protected StringTemplateGroup baseTemplates;
    protected StringTemplate recognizerST;
    protected StringTemplate outputFileST;
    protected StringTemplate headerFileST;
    protected int uniqueLabelNumber = 1;
    protected Tool tool;
    protected boolean debug;
    protected boolean trace;
    protected boolean profile;
    protected int lineWidth = 72;
    public ACyclicDFACodeGenerator acyclicDFAGenerator = new ACyclicDFACodeGenerator(this);
    public static final String VOCAB_FILE_EXTENSION = ".tokens";
    protected static final String vocabFilePattern = "<tokens:{<attr.name>=<attr.type>\n}><literals:{<attr.name>=<attr.type>\n}>";

    public CodeGenerator(Tool tool, Grammar grammar, String language) {
        this.tool = tool;
        this.grammar = grammar;
        this.language = language;
        this.target = CodeGenerator.loadLanguageTarget(language);
    }

    public static Target loadLanguageTarget(String language) {
        Target target = null;
        String targetName = "org.antlr.codegen." + language + "Target";
        try {
            Class<?> c = Class.forName(targetName);
            target = (Target)c.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            target = new Target();
        }
        catch (InstantiationException ie) {
            ErrorManager.error(23, (Object)targetName, ie);
        }
        catch (IllegalAccessException cnfe) {
            ErrorManager.error(23, (Object)targetName, cnfe);
        }
        return target;
    }

    public void loadTemplates(String language) {
        StringTemplateGroup coreTemplates;
        String templateDirs = this.classpathTemplateRootDirectoryName + ":" + this.classpathTemplateRootDirectoryName + "/" + language;
        CommonGroupLoader loader = new CommonGroupLoader(templateDirs, ErrorManager.getStringTemplateErrorListener());
        StringTemplateGroup.registerGroupLoader(loader);
        StringTemplateGroup.registerDefaultLexer(AngleBracketTemplateLexer.class);
        this.baseTemplates = coreTemplates = StringTemplateGroup.loadGroup(language);
        if (coreTemplates == null) {
            ErrorManager.error(20, language);
            return;
        }
        String outputOption = (String)this.grammar.getOption("output");
        if (outputOption != null && outputOption.equals("AST")) {
            if (this.debug && this.grammar.type != 1) {
                StringTemplateGroup astDbgTemplates;
                StringTemplateGroup astTemplates;
                StringTemplateGroup dbgTemplates;
                this.baseTemplates = dbgTemplates = StringTemplateGroup.loadGroup("Dbg", coreTemplates);
                StringTemplateGroup astParserTemplates = astTemplates = StringTemplateGroup.loadGroup("AST", dbgTemplates);
                astParserTemplates = this.grammar.type == 3 ? StringTemplateGroup.loadGroup("ASTTreeParser", astTemplates) : StringTemplateGroup.loadGroup("ASTParser", astTemplates);
                this.templates = astDbgTemplates = StringTemplateGroup.loadGroup("ASTDbg", astParserTemplates);
            } else {
                StringTemplateGroup astTemplates;
                StringTemplateGroup astParserTemplates = astTemplates = StringTemplateGroup.loadGroup("AST", coreTemplates);
                astParserTemplates = this.grammar.type == 3 ? StringTemplateGroup.loadGroup("ASTTreeParser", astTemplates) : StringTemplateGroup.loadGroup("ASTParser", astTemplates);
                this.templates = astParserTemplates;
            }
        } else if (outputOption != null && outputOption.equals("template")) {
            if (this.debug && this.grammar.type != 1) {
                StringTemplateGroup stTemplates;
                StringTemplateGroup dbgTemplates;
                this.baseTemplates = dbgTemplates = StringTemplateGroup.loadGroup("Dbg", coreTemplates);
                this.templates = stTemplates = StringTemplateGroup.loadGroup("ST", dbgTemplates);
            } else {
                this.templates = StringTemplateGroup.loadGroup("ST", coreTemplates);
            }
        } else if (this.debug && this.grammar.type != 1) {
            this.baseTemplates = this.templates = StringTemplateGroup.loadGroup("Dbg", coreTemplates);
        } else {
            this.templates = coreTemplates;
        }
        if (EMIT_TEMPLATE_DELIMITERS) {
            this.templates.emitDebugStartStopStrings(true);
            this.templates.doNotEmitDebugStringsForTemplate("codeFileExtension");
            this.templates.doNotEmitDebugStringsForTemplate("headerFileExtension");
        }
    }

    public StringTemplate genRecognizer() {
        this.loadTemplates(this.language);
        if (this.templates == null) {
            return null;
        }
        if (ErrorManager.doNotAttemptAnalysis()) {
            return null;
        }
        this.target.performGrammarAnalysis(this, this.grammar);
        if (ErrorManager.doNotAttemptCodeGen()) {
            return null;
        }
        DFAOptimizer optimizer = new DFAOptimizer(this.grammar);
        optimizer.optimize();
        this.outputFileST = this.templates.getInstanceOf("outputFile");
        if (this.templates.isDefined("headerFile")) {
            this.headerFileST = this.templates.getInstanceOf("headerFile");
        } else {
            this.headerFileST = new StringTemplate(this.templates, "");
            this.headerFileST.setName("dummy-header-file");
        }
        boolean filterMode = this.grammar.getOption("filter") != null && this.grammar.getOption("filter").equals("true");
        boolean canBacktrack = this.grammar.getSyntacticPredicates() != null || this.grammar.composite.getRootGrammar().atLeastOneBacktrackOption || filterMode;
        Map actions = this.grammar.getActions();
        this.verifyActionScopesOkForTarget(actions);
        this.translateActionAttributeReferences(actions);
        StringTemplate gateST = this.templates.getInstanceOf("actionGate");
        if (filterMode) {
            gateST = this.templates.getInstanceOf("filteringActionGate");
        }
        this.grammar.setSynPredGateIfNotAlready(gateST);
        this.headerFileST.setAttribute("actions", actions);
        this.outputFileST.setAttribute("actions", actions);
        this.headerFileST.setAttribute("buildTemplate", new Boolean(this.grammar.buildTemplate()));
        this.outputFileST.setAttribute("buildTemplate", new Boolean(this.grammar.buildTemplate()));
        this.headerFileST.setAttribute("buildAST", new Boolean(this.grammar.buildAST()));
        this.outputFileST.setAttribute("buildAST", new Boolean(this.grammar.buildAST()));
        this.outputFileST.setAttribute("rewriteMode", this.grammar.rewriteMode());
        this.headerFileST.setAttribute("rewriteMode", this.grammar.rewriteMode());
        this.outputFileST.setAttribute("backtracking", canBacktrack);
        this.headerFileST.setAttribute("backtracking", canBacktrack);
        String memoize = (String)this.grammar.getOption("memoize");
        this.outputFileST.setAttribute("memoize", this.grammar.atLeastOneRuleMemoizes || Boolean.valueOf(memoize != null && memoize.equals("true")) != false && canBacktrack);
        this.headerFileST.setAttribute("memoize", this.grammar.atLeastOneRuleMemoizes || Boolean.valueOf(memoize != null && memoize.equals("true")) != false && canBacktrack);
        this.outputFileST.setAttribute("trace", this.trace);
        this.headerFileST.setAttribute("trace", this.trace);
        this.outputFileST.setAttribute("profile", this.profile);
        this.headerFileST.setAttribute("profile", this.profile);
        if (this.grammar.type == 1) {
            this.recognizerST = this.templates.getInstanceOf("lexer");
            this.outputFileST.setAttribute("LEXER", true);
            this.headerFileST.setAttribute("LEXER", true);
            this.recognizerST.setAttribute("filterMode", filterMode);
        } else if (this.grammar.type == 2 || this.grammar.type == 4) {
            this.recognizerST = this.templates.getInstanceOf("parser");
            this.outputFileST.setAttribute("PARSER", true);
            this.headerFileST.setAttribute("PARSER", true);
        } else {
            this.recognizerST = this.templates.getInstanceOf("treeParser");
            this.outputFileST.setAttribute("TREE_PARSER", true);
            this.headerFileST.setAttribute("TREE_PARSER", true);
            this.recognizerST.setAttribute("filterMode", filterMode);
        }
        this.outputFileST.setAttribute("recognizer", this.recognizerST);
        this.headerFileST.setAttribute("recognizer", this.recognizerST);
        this.outputFileST.setAttribute("actionScope", this.grammar.getDefaultActionScope(this.grammar.type));
        this.headerFileST.setAttribute("actionScope", this.grammar.getDefaultActionScope(this.grammar.type));
        String targetAppropriateFileNameString = this.target.getTargetStringLiteralFromString(this.grammar.getFileName());
        this.outputFileST.setAttribute("fileName", targetAppropriateFileNameString);
        this.headerFileST.setAttribute("fileName", targetAppropriateFileNameString);
        this.outputFileST.setAttribute("ANTLRVersion", this.tool.VERSION);
        this.headerFileST.setAttribute("ANTLRVersion", this.tool.VERSION);
        this.outputFileST.setAttribute("generatedTimestamp", Tool.getCurrentTimeStamp());
        this.headerFileST.setAttribute("generatedTimestamp", Tool.getCurrentTimeStamp());
        CodeGenTreeWalker gen = new CodeGenTreeWalker();
        try {
            gen.grammar(this.grammar.getGrammarTree(), this.grammar, this.recognizerST, this.outputFileST, this.headerFileST);
        }
        catch (RecognitionException re) {
            ErrorManager.error(15, re);
        }
        this.genTokenTypeConstants(this.recognizerST);
        this.genTokenTypeConstants(this.outputFileST);
        this.genTokenTypeConstants(this.headerFileST);
        if (this.grammar.type != 1) {
            this.genTokenTypeNames(this.recognizerST);
            this.genTokenTypeNames(this.outputFileST);
            this.genTokenTypeNames(this.headerFileST);
        }
        Set<String> synpredNames = null;
        if (this.grammar.synPredNamesUsedInDFA.size() > 0) {
            synpredNames = this.grammar.synPredNamesUsedInDFA;
        }
        this.outputFileST.setAttribute("synpreds", synpredNames);
        this.headerFileST.setAttribute("synpreds", synpredNames);
        this.recognizerST.setAttribute("grammar", this.grammar);
        try {
            this.target.genRecognizerFile(this.tool, this, this.grammar, this.outputFileST);
            if (this.templates.isDefined("headerFile")) {
                StringTemplate extST = this.templates.getInstanceOf("headerFileExtension");
                this.target.genRecognizerHeaderFile(this.tool, this, this.grammar, this.headerFileST, extST.toString());
            }
            StringTemplate tokenVocabSerialization = this.genTokenVocabOutput();
            String vocabFileName = this.getVocabFileName();
            if (vocabFileName != null) {
                this.write(tokenVocabSerialization, vocabFileName);
            }
        }
        catch (IOException ioe) {
            ErrorManager.error(1, (Object)this.getVocabFileName(), ioe);
        }
        return this.outputFileST;
    }

    protected void verifyActionScopesOkForTarget(Map actions) {
        Set actionScopeKeySet = actions.keySet();
        for (String scope : actionScopeKeySet) {
            if (this.target.isValidActionScope(this.grammar.type, scope)) continue;
            Map scopeActions = (Map)actions.get(scope);
            GrammarAST actionAST = (GrammarAST)scopeActions.values().iterator().next();
            ErrorManager.grammarError(143, this.grammar, actionAST.getToken(), scope, this.grammar.getGrammarTypeString());
        }
    }

    protected void translateActionAttributeReferences(Map actions) {
        Set actionScopeKeySet = actions.keySet();
        for (String scope : actionScopeKeySet) {
            Map scopeActions = (Map)actions.get(scope);
            this.translateActionAttributeReferencesForSingleScope(null, scopeActions);
        }
    }

    public void translateActionAttributeReferencesForSingleScope(Rule r, Map scopeActions) {
        String ruleName = null;
        if (r != null) {
            ruleName = r.name;
        }
        Set actionNameSet = scopeActions.keySet();
        for (String name : actionNameSet) {
            GrammarAST actionAST = (GrammarAST)scopeActions.get(name);
            List chunks = this.translateAction(ruleName, actionAST);
            scopeActions.put(name, chunks);
        }
    }

    public void generateLocalFOLLOW(GrammarAST referencedElementNode, String referencedElementName, String enclosingRuleName, int elementIndex) {
        NFAState followingNFAState = referencedElementNode.followingNFAState;
        LookaheadSet follow = null;
        if (followingNFAState != null) {
            follow = this.grammar.FIRST(followingNFAState);
        }
        if (follow == null) {
            ErrorManager.internalError("no follow state or cannot compute follow");
            follow = new LookaheadSet();
        }
        if (follow.member(-1)) {
            follow.remove(-1);
        }
        List tokenTypeList = null;
        long[] words = null;
        if (follow.tokenTypeSet == null) {
            words = new long[1];
            tokenTypeList = new ArrayList();
        } else {
            BitSet bits = BitSet.of(follow.tokenTypeSet);
            words = bits.toPackedArray();
            tokenTypeList = follow.tokenTypeSet.toList();
        }
        String[] wordStrings = new String[words.length];
        for (int j = 0; j < words.length; ++j) {
            long w = words[j];
            wordStrings[j] = this.target.getTarget64BitStringFromValue(w);
        }
        this.recognizerST.setAttribute("bitsets.{name,inName,bits,tokenTypes,tokenIndex}", referencedElementName, enclosingRuleName, wordStrings, tokenTypeList, Utils.integer(elementIndex));
        this.outputFileST.setAttribute("bitsets.{name,inName,bits,tokenTypes,tokenIndex}", referencedElementName, enclosingRuleName, wordStrings, tokenTypeList, Utils.integer(elementIndex));
        this.headerFileST.setAttribute("bitsets.{name,inName,bits,tokenTypes,tokenIndex}", referencedElementName, enclosingRuleName, wordStrings, tokenTypeList, Utils.integer(elementIndex));
    }

    public StringTemplate genLookaheadDecision(StringTemplate recognizerST, DFA dfa) {
        StringTemplate decisionST;
        if (dfa.canInlineDecision()) {
            decisionST = this.acyclicDFAGenerator.genFixedLookaheadDecision(this.getTemplates(), dfa);
        } else {
            dfa.createStateTables(this);
            this.outputFileST.setAttribute("cyclicDFAs", dfa);
            this.headerFileST.setAttribute("cyclicDFAs", dfa);
            decisionST = this.templates.getInstanceOf("dfaDecision");
            String description = dfa.getNFADecisionStartState().getDescription();
            description = this.target.getTargetStringLiteralFromString(description);
            if (description != null) {
                decisionST.setAttribute("description", description);
            }
            decisionST.setAttribute("decisionNumber", Utils.integer(dfa.getDecisionNumber()));
        }
        return decisionST;
    }

    public StringTemplate generateSpecialState(DFAState s) {
        StringTemplate stateST = this.templates.getInstanceOf("cyclicDFAState");
        stateST.setAttribute("needErrorClause", true);
        stateST.setAttribute("semPredState", s.isResolvedWithPredicates());
        stateST.setAttribute("stateNumber", s.stateNumber);
        stateST.setAttribute("decisionNumber", s.dfa.decisionNumber);
        boolean foundGatedPred = false;
        StringTemplate eotST = null;
        for (int i = 0; i < s.getNumberOfTransitions(); ++i) {
            DFAState t;
            SemanticContext preds;
            StringTemplate edgeST;
            Transition edge = s.transition(i);
            if (edge.label.getAtom() == -2) {
                edgeST = this.templates.getInstanceOf("eotDFAEdge");
                stateST.removeAttribute("needErrorClause");
                eotST = edgeST;
            } else {
                edgeST = this.templates.getInstanceOf("cyclicDFAEdge");
                StringTemplate exprST = this.genLabelExpr(this.templates, edge, 1);
                edgeST.setAttribute("labelExpr", exprST);
            }
            edgeST.setAttribute("edgeNumber", Utils.integer(i + 1));
            edgeST.setAttribute("targetStateNumber", Utils.integer(edge.target.stateNumber));
            if (!edge.label.isSemanticPredicate() && (preds = (t = (DFAState)edge.target).getGatedPredicatesInNFAConfigurations()) != null) {
                foundGatedPred = true;
                StringTemplate predST = preds.genExpr(this, this.getTemplates(), t.dfa);
                edgeST.setAttribute("predicates", predST.toString());
            }
            if (edge.label.getAtom() == -2) continue;
            stateST.setAttribute("edges", edgeST);
        }
        if (foundGatedPred) {
            stateST.setAttribute("semPredState", new Boolean(foundGatedPred));
        }
        if (eotST != null) {
            stateST.setAttribute("edges", eotST);
        }
        return stateST;
    }

    protected StringTemplate genLabelExpr(StringTemplateGroup templates, Transition edge, int k) {
        Label label = edge.label;
        if (label.isSemanticPredicate()) {
            return this.genSemanticPredicateExpr(templates, edge);
        }
        if (label.isSet()) {
            return this.genSetExpr(templates, label.getSet(), k, true);
        }
        StringTemplate eST = templates.getInstanceOf("lookaheadTest");
        eST.setAttribute("atom", this.getTokenTypeAsTargetLabel(label.getAtom()));
        eST.setAttribute("atomAsInt", Utils.integer(label.getAtom()));
        eST.setAttribute("k", Utils.integer(k));
        return eST;
    }

    protected StringTemplate genSemanticPredicateExpr(StringTemplateGroup templates, Transition edge) {
        DFA dfa = ((DFAState)edge.target).dfa;
        Label label = edge.label;
        SemanticContext semCtx = label.getSemanticContext();
        return semCtx.genExpr(this, templates, dfa);
    }

    public StringTemplate genSetExpr(StringTemplateGroup templates, IntSet set, int k, boolean partOfDFA) {
        if (!(set instanceof IntervalSet)) {
            throw new IllegalArgumentException("unable to generate expressions for non IntervalSet objects");
        }
        IntervalSet iset = (IntervalSet)set;
        if (iset.getIntervals() == null || iset.getIntervals().size() == 0) {
            StringTemplate emptyST = new StringTemplate(templates, "");
            emptyST.setName("empty-set-expr");
            return emptyST;
        }
        String testSTName = "lookaheadTest";
        String testRangeSTName = "lookaheadRangeTest";
        if (!partOfDFA) {
            testSTName = "isolatedLookaheadTest";
            testRangeSTName = "isolatedLookaheadRangeTest";
        }
        StringTemplate setST = templates.getInstanceOf("setTest");
        Iterator<Interval> iter = iset.getIntervals().iterator();
        int rangeNumber = 1;
        while (iter.hasNext()) {
            StringTemplate eST;
            Interval I = iter.next();
            int a = I.a;
            int b = I.b;
            if (a == b) {
                eST = templates.getInstanceOf(testSTName);
                eST.setAttribute("atom", this.getTokenTypeAsTargetLabel(a));
                eST.setAttribute("atomAsInt", Utils.integer(a));
            } else {
                eST = templates.getInstanceOf(testRangeSTName);
                eST.setAttribute("lower", this.getTokenTypeAsTargetLabel(a));
                eST.setAttribute("lowerAsInt", Utils.integer(a));
                eST.setAttribute("upper", this.getTokenTypeAsTargetLabel(b));
                eST.setAttribute("upperAsInt", Utils.integer(b));
                eST.setAttribute("rangeNumber", Utils.integer(rangeNumber));
            }
            eST.setAttribute("k", Utils.integer(k));
            setST.setAttribute("ranges", eST);
            ++rangeNumber;
        }
        return setST;
    }

    protected void genTokenTypeConstants(StringTemplate code) {
        for (String tokenID : this.grammar.getTokenIDs()) {
            int tokenType = this.grammar.getTokenType(tokenID);
            if (tokenType != -1 && tokenType < 4) continue;
            code.setAttribute("tokens.{name,type}", tokenID, Utils.integer(tokenType));
        }
    }

    protected void genTokenTypeNames(StringTemplate code) {
        for (int t = 4; t <= this.grammar.getMaxTokenType(); ++t) {
            String tokenName = this.grammar.getTokenDisplayName(t);
            if (tokenName == null) continue;
            tokenName = this.target.getTargetStringLiteralFromString(tokenName, true);
            code.setAttribute("tokenNames", tokenName);
        }
    }

    public String getTokenTypeAsTargetLabel(int ttype) {
        if (this.grammar.type == 1) {
            String name = this.grammar.getTokenDisplayName(ttype);
            return this.target.getTargetCharLiteralFromANTLRCharLiteral(this, name);
        }
        return this.target.getTokenTypeAsTargetLabel(this, ttype);
    }

    protected StringTemplate genTokenVocabOutput() {
        StringTemplate vocabFileST = new StringTemplate(vocabFilePattern, AngleBracketTemplateLexer.class);
        vocabFileST.setName("vocab-file");
        for (String tokenID : this.grammar.getTokenIDs()) {
            int tokenType = this.grammar.getTokenType(tokenID);
            if (tokenType < 4) continue;
            vocabFileST.setAttribute("tokens.{name,type}", tokenID, Utils.integer(tokenType));
        }
        for (String literal : this.grammar.getStringLiterals()) {
            int tokenType = this.grammar.getTokenType(literal);
            if (tokenType < 4) continue;
            vocabFileST.setAttribute("tokens.{name,type}", literal, Utils.integer(tokenType));
        }
        return vocabFileST;
    }

    public List translateAction(String ruleName, GrammarAST actionTree) {
        if (actionTree.getType() == 60) {
            return this.translateArgAction(ruleName, actionTree);
        }
        ActionTranslator translator = new ActionTranslator(this, ruleName, actionTree);
        List chunks = translator.translateToChunks();
        chunks = this.target.postProcessAction(chunks, actionTree.token);
        return chunks;
    }

    public List<StringTemplate> translateArgAction(String ruleName, GrammarAST actionTree) {
        String actionText = actionTree.token.getText();
        List<String> args = CodeGenerator.getListOfArgumentsFromAction(actionText, 44);
        ArrayList<StringTemplate> translatedArgs = new ArrayList<StringTemplate>();
        for (String arg : args) {
            if (arg == null) continue;
            CommonToken actionToken = new CommonToken(40, arg);
            ActionTranslator translator = new ActionTranslator(this, ruleName, actionToken, actionTree.outerAltNum);
            List chunks = translator.translateToChunks();
            chunks = this.target.postProcessAction(chunks, actionToken);
            StringTemplate catST = new StringTemplate(this.templates, "<chunks>");
            catST.setAttribute("chunks", chunks);
            this.templates.createStringTemplate();
            translatedArgs.add(catST);
        }
        if (translatedArgs.size() == 0) {
            return null;
        }
        return translatedArgs;
    }

    public static List<String> getListOfArgumentsFromAction(String actionText, int separatorChar) {
        ArrayList<String> args = new ArrayList<String>();
        CodeGenerator.getListOfArgumentsFromAction(actionText, 0, -1, separatorChar, args);
        return args;
    }

    public static int getListOfArgumentsFromAction(String actionText, int start, int targetChar, int separatorChar, List<String> args) {
        String arg;
        int p;
        if (actionText == null) {
            return -1;
        }
        actionText = actionText.replaceAll("//.*\n", "");
        int n = actionText.length();
        int last = p = start;
        block8: while (p < n && actionText.charAt(p) != targetChar) {
            char c = actionText.charAt(p);
            switch (c) {
                case '\'': {
                    ++p;
                    while (p < n && actionText.charAt(p) != '\'') {
                        if (actionText.charAt(p) == '\\' && p + 1 < n && actionText.charAt(p + 1) == '\'') {
                            ++p;
                        }
                        ++p;
                    }
                    ++p;
                    continue block8;
                }
                case '\"': {
                    ++p;
                    while (p < n && actionText.charAt(p) != '\"') {
                        if (actionText.charAt(p) == '\\' && p + 1 < n && actionText.charAt(p + 1) == '\"') {
                            ++p;
                        }
                        ++p;
                    }
                    ++p;
                    continue block8;
                }
                case '(': {
                    p = CodeGenerator.getListOfArgumentsFromAction(actionText, p + 1, 41, separatorChar, args);
                    continue block8;
                }
                case '{': {
                    p = CodeGenerator.getListOfArgumentsFromAction(actionText, p + 1, 125, separatorChar, args);
                    continue block8;
                }
                case '<': {
                    if (actionText.indexOf(62, p + 1) >= p) {
                        p = CodeGenerator.getListOfArgumentsFromAction(actionText, p + 1, 62, separatorChar, args);
                        continue block8;
                    }
                    ++p;
                    continue block8;
                }
                case '[': {
                    p = CodeGenerator.getListOfArgumentsFromAction(actionText, p + 1, 93, separatorChar, args);
                    continue block8;
                }
            }
            if (c == separatorChar && targetChar == -1) {
                String arg2 = actionText.substring(last, p);
                args.add(arg2.trim());
                last = p + 1;
            }
            ++p;
        }
        if (targetChar == -1 && p <= n && (arg = actionText.substring(last, p).trim()).length() > 0) {
            args.add(arg.trim());
        }
        return ++p;
    }

    public StringTemplate translateTemplateConstructor(String ruleName, int outerAltNum, Token actionToken, String templateActionText) {
        ANTLRLexer lexer = new ANTLRLexer(new StringReader(templateActionText));
        lexer.setFilename(this.grammar.getFileName());
        lexer.setTokenObjectClass("antlr.TokenWithIndex");
        TokenStreamRewriteEngine tokenBuffer = new TokenStreamRewriteEngine(lexer);
        tokenBuffer.discard(85);
        tokenBuffer.discard(88);
        tokenBuffer.discard(86);
        tokenBuffer.discard(87);
        ANTLRParser parser = new ANTLRParser(tokenBuffer);
        parser.setFilename(this.grammar.getFileName());
        parser.setASTNodeClass("org.antlr.tool.GrammarAST");
        try {
            parser.rewrite_template();
        }
        catch (RecognitionException re) {
            ErrorManager.grammarError(146, this.grammar, actionToken, templateActionText);
        }
        catch (Exception tse) {
            ErrorManager.internalError("can't parse template action", tse);
        }
        GrammarAST rewriteTree = (GrammarAST)parser.getAST();
        CodeGenTreeWalker gen = new CodeGenTreeWalker();
        gen.init(this.grammar);
        gen.setCurrentRuleName(ruleName);
        gen.setOuterAltNum(outerAltNum);
        StringTemplate st = null;
        try {
            st = gen.rewrite_template(rewriteTree);
        }
        catch (RecognitionException re) {
            ErrorManager.error(15, re);
        }
        return st;
    }

    public void issueInvalidScopeError(String x, String y, Rule enclosingRule, Token actionToken, int outerAltNum) {
        Rule r = this.grammar.getRule(x);
        AttributeScope scope = this.grammar.getGlobalScope(x);
        if (scope == null && r != null) {
            scope = r.ruleScope;
        }
        if (scope == null) {
            ErrorManager.grammarError(140, this.grammar, actionToken, x);
        } else if (scope.getAttribute(y) == null) {
            ErrorManager.grammarError(141, this.grammar, actionToken, x, y);
        }
    }

    public void issueInvalidAttributeError(String x, String y, Rule enclosingRule, Token actionToken, int outerAltNum) {
        if (enclosingRule == null) {
            ErrorManager.grammarError(111, this.grammar, actionToken, x, y);
            return;
        }
        Grammar.LabelElementPair label = enclosingRule.getRuleLabel(x);
        if (label != null || enclosingRule.getRuleRefsInAlt(x, outerAltNum) != null) {
            Rule refdRule;
            AttributeScope scope;
            String refdRuleName = x;
            if (label != null) {
                refdRuleName = enclosingRule.getRuleLabel((String)x).referencedRuleName;
            }
            if ((scope = (refdRule = this.grammar.getRule(refdRuleName)).getAttributeScope(y)) == null) {
                ErrorManager.grammarError(116, this.grammar, actionToken, refdRuleName, y);
            } else if (scope.isParameterScope) {
                ErrorManager.grammarError(115, this.grammar, actionToken, refdRuleName, y);
            } else if (scope.isDynamicRuleScope) {
                ErrorManager.grammarError(112, this.grammar, actionToken, refdRuleName, y);
            }
        }
    }

    public void issueInvalidAttributeError(String x, Rule enclosingRule, Token actionToken, int outerAltNum) {
        if (enclosingRule == null) {
            ErrorManager.grammarError(111, this.grammar, actionToken, x);
            return;
        }
        Grammar.LabelElementPair label = enclosingRule.getRuleLabel(x);
        AttributeScope scope = enclosingRule.getAttributeScope(x);
        if (label != null || enclosingRule.getRuleRefsInAlt(x, outerAltNum) != null || enclosingRule.name.equals(x)) {
            ErrorManager.grammarError(117, this.grammar, actionToken, x);
        } else if (scope != null && scope.isDynamicRuleScope) {
            ErrorManager.grammarError(142, this.grammar, actionToken, x);
        } else {
            ErrorManager.grammarError(114, this.grammar, actionToken, x);
        }
    }

    public StringTemplateGroup getTemplates() {
        return this.templates;
    }

    public StringTemplateGroup getBaseTemplates() {
        return this.baseTemplates;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public void setProfile(boolean profile) {
        this.profile = profile;
        if (profile) {
            this.setDebug(true);
        }
    }

    public StringTemplate getRecognizerST() {
        return this.outputFileST;
    }

    public String getRecognizerFileName(String name, int type) {
        StringTemplate extST = this.templates.getInstanceOf("codeFileExtension");
        String recognizerName = this.grammar.getRecognizerName();
        return recognizerName + extST.toString();
    }

    public String getVocabFileName() {
        if (this.grammar.isBuiltFromString()) {
            return null;
        }
        return this.grammar.name + VOCAB_FILE_EXTENSION;
    }

    public void write(StringTemplate code, String fileName) throws IOException {
        long start = System.currentTimeMillis();
        Writer w = this.tool.getOutputFile(this.grammar, fileName);
        StringTemplateWriter wr = this.templates.getStringTemplateWriter(w);
        wr.setLineWidth(this.lineWidth);
        code.write(wr);
        w.close();
        long stop = System.currentTimeMillis();
    }

    protected boolean canGenerateSwitch(DFAState s) {
        if (!this.GENERATE_SWITCHES_WHEN_POSSIBLE) {
            return false;
        }
        int size = 0;
        for (int i = 0; i < s.getNumberOfTransitions(); ++i) {
            int EOTPredicts;
            Transition edge = s.transition(i);
            if (edge.label.isSemanticPredicate()) {
                return false;
            }
            if (edge.label.getAtom() == -2 && (EOTPredicts = ((DFAState)edge.target).getUniquelyPredictedAlt()) == -1) {
                return false;
            }
            if (((DFAState)edge.target).getGatedPredicatesInNFAConfigurations() != null) {
                return false;
            }
            size += edge.label.getSet().size();
        }
        return s.getNumberOfTransitions() >= MIN_SWITCH_ALTS && size <= MAX_SWITCH_CASE_LABELS;
    }

    public String createUniqueLabel(String name) {
        return new StringBuffer().append(name).append(this.uniqueLabelNumber++).toString();
    }
}

