/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.beans.editors;

import com.mathworks.beans.editors.ValueValidityEvent;
import com.mathworks.beans.editors.ValueValidityListener;
import com.mathworks.beans.editors.ValueValiditySource;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTable;
import com.mathworks.mwswing.MJTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class PrimitiveArrayEditPanel
extends MJPanel
implements ValueValiditySource,
ActionListener {
    private static final ResourceBundle fRes = ResourceBundle.getBundle("com.mathworks.beans.editors.resources.RES_Editors");
    private static Color sDefaultForeground = UIManager.getColor("textText");
    private static final String APPEND_TEXT = fRes.getString("button.append");
    private static final String INSERT_TXT = fRes.getString("button.insert");
    private static final String DEL_TXT = fRes.getString("button.delete");
    private static final String DUP_CMD = "AppendInsert";
    private static final String DEL_CMD = "Delete";
    private List<Double> fDoubleArray = null;
    private List<Integer> fIntArray = null;
    private Vector<ValueValidityListener> fEars = new Vector(2, 5);
    private boolean fValid;
    private boolean[] fValidByRow;
    private MJTable fTable;
    private DefaultTableModel fModel;
    private MJButton fDeleteButton;
    private MJButton fAppendInsertBtn;

    public PrimitiveArrayEditPanel(double[] dArray) {
        super((LayoutManager)new BorderLayout());
        this.fDoubleArray = new ArrayList<Double>();
        this.fTable = new MJTable();
        if (dArray != null) {
            this.initDouble(dArray);
        }
        this.finishSetup();
    }

    public PrimitiveArrayEditPanel(int[] nArray) {
        super((LayoutManager)new BorderLayout());
        this.fIntArray = new ArrayList<Integer>();
        this.fTable = new MJTable();
        if (nArray != null) {
            this.initInt(nArray);
        }
        this.finishSetup();
    }

    private void initDouble(double[] dArray) {
        this.fValidByRow = new boolean[dArray.length];
        this.fDoubleArray.clear();
        this.fModel = new DefaultTableModel(dArray.length, 1);
        for (int i = 0; i < dArray.length; ++i) {
            this.fModel.setValueAt(Double.toString(dArray[i]), i, 0);
            this.fDoubleArray.add(dArray[i]);
            this.fValidByRow[i] = true;
        }
        this.fTable.setModel((TableModel)this.fModel);
        this.fTable.getColumnModel().getColumn(0).setHeaderValue("Double Values");
        ValidationCellEditor validationCellEditor = new ValidationCellEditor();
        validationCellEditor.setClickCountToStart(2);
        this.fTable.getColumnModel().getColumn(0).setCellEditor(validationCellEditor);
        this.fTable.getColumnModel().getColumn(0).setCellRenderer(new ValidationCellRenderer());
    }

    private void initInt(int[] nArray) {
        this.fValidByRow = new boolean[nArray.length];
        this.fIntArray.clear();
        this.fModel = new DefaultTableModel(nArray.length, 1);
        for (int i = 0; i < nArray.length; ++i) {
            this.fModel.setValueAt(nArray[i], i, 0);
            this.fIntArray.add(nArray[i]);
            this.fValidByRow[i] = true;
        }
        this.fTable.setModel((TableModel)this.fModel);
        this.fTable.getColumnModel().getColumn(0).setHeaderValue("Integer Values");
        ValidationCellEditor validationCellEditor = new ValidationCellEditor();
        validationCellEditor.setClickCountToStart(2);
        this.fTable.getColumnModel().getColumn(0).setCellEditor(validationCellEditor);
        this.fTable.getColumnModel().getColumn(0).setCellRenderer(new ValidationCellRenderer());
    }

    private void finishSetup() {
        this.fValid = true;
        this.fTable.setFillsViewportHeight(true);
        this.fTable.setShowGrid(false);
        this.fTable.setSelectionMode(0);
        this.fTable.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        this.fTable.setAutoResizeMode(4);
        this.fTable.setSurrendersFocusOnKeystroke(true);
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.fTable);
        mJScrollPane.setPreferredSize(new Dimension(200, 200));
        this.fTable.setTableHeader(null);
        mJScrollPane.setColumnHeaderView(null);
        this.add((Component)mJScrollPane, "Center");
        this.fAppendInsertBtn = new MJButton(APPEND_TEXT);
        this.fAppendInsertBtn.setActionCommand(DUP_CMD);
        this.fAppendInsertBtn.addActionListener((ActionListener)this);
        this.fDeleteButton = new MJButton(DEL_TXT);
        this.fDeleteButton.setActionCommand(DEL_CMD);
        this.fDeleteButton.addActionListener((ActionListener)this);
        this.fDeleteButton.setEnabled(false);
        MJPanel mJPanel = new MJPanel((LayoutManager)new FlowLayout(0));
        mJPanel.add((Component)this.fAppendInsertBtn);
        mJPanel.add((Component)this.fDeleteButton);
        this.add((Component)mJPanel, "South");
        this.fTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    PrimitiveArrayEditPanel.this.processSelectionChange();
                }
            }
        });
    }

    public double[] getDoubleArray() {
        double[] dArray = null;
        if (this.fModel.getRowCount() > 0) {
            dArray = new double[this.fDoubleArray.size()];
            for (int i = 0; i < this.fDoubleArray.size(); ++i) {
                dArray[i] = this.fDoubleArray.get(i);
            }
        }
        return dArray;
    }

    public int[] getIntArray() {
        int[] nArray = null;
        if (this.fModel.getRowCount() > 0) {
            nArray = new int[this.fIntArray.size()];
            for (int i = 0; i < this.fIntArray.size(); ++i) {
                nArray[i] = this.fIntArray.get(i);
            }
        }
        return nArray;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.fTable.getSelectedRow();
        if (DUP_CMD.equals(actionEvent.getActionCommand())) {
            if (this.fValidByRow == null) {
                if (this.fDoubleArray != null) {
                    double[] dArray = new double[]{0.0};
                    this.initDouble(dArray);
                } else if (this.fIntArray != null) {
                    int[] nArray = new int[]{0};
                    this.initInt(nArray);
                }
            } else {
                String string = "";
                if (this.fDoubleArray != null) {
                    double d;
                    if (n < 0) {
                        d = 0.0;
                        this.fDoubleArray.add(d);
                    } else {
                        d = this.fDoubleArray.get(n);
                        this.fDoubleArray.add(n, d);
                    }
                    string = Double.toString(d);
                } else if (this.fIntArray != null) {
                    int n2;
                    if (n < 0) {
                        n2 = 0;
                        this.fIntArray.add(n2);
                    } else {
                        n2 = this.fIntArray.get(n);
                        this.fIntArray.add(n, n2);
                    }
                    string = Integer.toString(n2);
                }
                if (n >= 0) {
                    this.fModel.insertRow(n, new String[]{string});
                } else {
                    this.fModel.insertRow(0, new String[]{string});
                }
                int n3 = this.fValidByRow.length;
                boolean[] blArray = new boolean[n3 + 1];
                if (n < 0) {
                    System.arraycopy(this.fValidByRow, 0, blArray, 0, this.fValidByRow.length);
                    blArray[n3] = true;
                } else {
                    System.arraycopy(this.fValidByRow, 0, blArray, 0, n);
                    blArray[n] = true;
                    System.arraycopy(this.fValidByRow, n, blArray, n + 1, n3 - n);
                }
                this.fValidByRow = blArray;
            }
        } else if (DEL_CMD.equals(actionEvent.getActionCommand())) {
            int n4;
            this.fModel.removeRow(n);
            int n5 = n4 = n <= this.fModel.getRowCount() - 1 ? n : this.fModel.getRowCount() - 1;
            if (n4 >= 0) {
                this.fTable.setRowSelectionInterval(n4, n4);
            }
            if (this.fDoubleArray != null) {
                this.fDoubleArray.remove(n);
            } else if (this.fIntArray != null) {
                this.fIntArray.remove(n);
            }
            boolean[] blArray = new boolean[this.fValidByRow.length - 1];
            int n6 = n;
            while (n6-- > 0) {
                blArray[n6] = this.fValidByRow[n6];
            }
            n6 = n;
            while (n6 < blArray.length) {
                blArray[n6++] = this.fValidByRow[n6];
            }
            this.fValidByRow = blArray;
            this.fAppendInsertBtn.setText(APPEND_TEXT);
            this.fDeleteButton.setEnabled(false);
            if (n >= this.fTable.getRowCount()) {
                n = this.fTable.getRowCount() - 1;
            }
            if (n >= 0) {
                this.fTable.setRowSelectionInterval(n, n);
                this.fDeleteButton.setEnabled(true);
            }
        }
        this.validityChanged();
    }

    private void processSelectionChange() {
        int n = this.fTable.getSelectedRow();
        this.fDeleteButton.setEnabled(n >= 0);
        this.fAppendInsertBtn.setText(n >= 0 ? INSERT_TXT : APPEND_TEXT);
    }

    @Override
    public boolean isValueValid() {
        return this.fValid;
    }

    @Override
    public void addValueValidityListener(ValueValidityListener valueValidityListener) {
        this.fEars.addElement(valueValidityListener);
    }

    @Override
    public void removeValueValidityListener(ValueValidityListener valueValidityListener) {
        this.fEars.removeElement(valueValidityListener);
    }

    private synchronized void fireValidityEvent(boolean bl) {
        Enumeration<ValueValidityListener> enumeration = this.fEars.elements();
        ValueValidityEvent valueValidityEvent = new ValueValidityEvent(this, bl);
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().valueValidityChanged(valueValidityEvent);
        }
    }

    private boolean checkValidity(String string, int n) {
        boolean bl = false;
        if (string != null && !string.isEmpty()) {
            try {
                if (this.fDoubleArray != null) {
                    double d = Double.valueOf(string);
                    this.fDoubleArray.set(n, d);
                } else if (this.fIntArray != null) {
                    int n2 = Integer.parseInt(string);
                    this.fIntArray.set(n, n2);
                }
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        if (this.fValidByRow[n] != bl) {
            this.fValidByRow[n] = bl;
            this.validityChanged();
        }
        return bl;
    }

    private void validityChanged() {
        boolean bl = true;
        int n = 0;
        while (bl && n < this.fValidByRow.length) {
            bl = this.fValidByRow[n++];
        }
        if (bl != this.fValid) {
            this.fValid = bl;
            this.fireValidityEvent(bl);
        }
    }

    private class ValidationCellEditor
    extends DefaultCellEditor {
        public ValidationCellEditor() {
            super((JTextField)new MJTextField());
            ((JTextField)this.getComponent()).setHorizontalAlignment(2);
        }

        @Override
        public boolean stopCellEditing() {
            String string = (String)super.getCellEditorValue();
            int n = PrimitiveArrayEditPanel.this.fTable.getSelectedRow();
            PrimitiveArrayEditPanel.this.checkValidity(string, n);
            return super.stopCellEditing();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            MJTextField mJTextField = (MJTextField)super.getTableCellEditorComponent(jTable, "", bl, n, n2);
            mJTextField.setSelectAllOnFocus(false);
            return mJTextField;
        }
    }

    private class ValidationCellRenderer
    extends DefaultTableCellRenderer {
        private ValidationCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (!bl && !PrimitiveArrayEditPanel.this.fValidByRow[n]) {
                component.setForeground(Color.RED);
            } else {
                component.setForeground(sDefaultForeground);
            }
            return component;
        }
    }
}

