/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.beans.editors;

import com.mathworks.beans.editors.MWPropertyEditorSupport;
import com.mathworks.beans.editors.StringLiner;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTextArea;
import java.awt.Component;
import java.awt.Image;
import java.awt.SystemColor;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;

public class StringArrayEditor
extends MWPropertyEditorSupport {
    public static final String ALLOW_BLANKS = "StringArrayEditor.AllowBlanks";
    private static final String DELIM = System.getProperty("line.separator");
    private static Image sIcon = null;
    private MJTextArea fTextArea;
    private boolean fAllowBlanks = true;

    @Override
    public String getAsText() {
        String string = "";
        Object object = this.getValue();
        if (object instanceof String[]) {
            String[] stringArray = (String[])this.getValue();
            if (stringArray != null && stringArray.length > 0) {
                string = stringArray[0];
            }
        } else if (object != null) {
            string = object.toString();
        }
        return string;
    }

    @Override
    public void setAsText(String string) {
        Object object = this.getValue();
        if (object instanceof String[]) {
            String[] stringArray = (String[])this.getValue();
            if (stringArray == null || stringArray.length == 0) {
                stringArray = new String[]{string};
            }
            this.setValue(stringArray);
        } else {
            this.setValue(string);
        }
    }

    @Override
    public boolean supportsInPlaceEditing() {
        return true;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        if (this.fTextArea == null) {
            this.fTextArea = new MJTextArea(12, 40);
        }
        this.fTextArea.requestFocus();
        Object object = this.getValue();
        if (object instanceof String[]) {
            this.fTextArea.setText(StringArrayEditor.arrayToDelimited((String[])this.getValue()));
        } else if (object != null) {
            this.fTextArea.setText(object.toString());
        }
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.fTextArea);
        mJScrollPane.setBorder(BorderFactory.createLineBorder(SystemColor.controlShadow));
        return mJScrollPane;
    }

    @Override
    public boolean canApply() {
        return true;
    }

    @Override
    public void apply() {
        String string = this.fTextArea != null ? this.fTextArea.getText() : "";
        String[] stringArray = StringArrayEditor.delimitedToArray(string);
        this.setValue(stringArray);
    }

    @Override
    public Image getIcon() {
        if (sIcon == null) {
            sIcon = new ImageIcon(this.getClass().getResource("resources/StringArrayIcon.gif")).getImage();
        }
        return sIcon;
    }

    @Override
    public boolean hasAttachedData() {
        return true;
    }

    @Override
    public String getDataKey() {
        return ALLOW_BLANKS;
    }

    @Override
    public void setData(Object object) {
        if (object instanceof Boolean) {
            this.fAllowBlanks = (Boolean)object;
        }
    }

    private static final String arrayToDelimited(String[] stringArray) {
        String string = "";
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                string = string + stringArray[i] + DELIM;
            }
        }
        return string;
    }

    private static final String[] delimitedToArray(String string) {
        Object[] objectArray = null;
        Vector<String> vector = new Vector<String>();
        if (string != null) {
            StringLiner stringLiner = new StringLiner(string);
            while (stringLiner.hasMoreLines()) {
                vector.addElement(stringLiner.nextLine());
            }
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }
}

