/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.connector.api;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import sun.misc.CompoundEnumeration;

public class DirectLoadURLClassLoader
extends URLClassLoader {
    private String[] packagesToDirectlyLoad;

    public DirectLoadURLClassLoader(String[] packagesToDirectlyLoad, URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.packagesToDirectlyLoad = packagesToDirectlyLoad;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> loadedClass = this.findLoadedClass(name);
        if (loadedClass == null) {
            for (String pack : this.packagesToDirectlyLoad) {
                if (!name.startsWith(pack)) continue;
                return this.findClass(name);
            }
            loadedClass = super.loadClass(name);
        }
        return loadedClass;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        for (String pack : this.packagesToDirectlyLoad) {
            if (!name.startsWith(pack)) continue;
            Enumeration[] tmp = new Enumeration[]{this.findResources(name)};
            return new CompoundEnumeration(tmp);
        }
        return super.getResources(name);
    }
}

