/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtils {
    public static void callSetBoolean(Object object, String string, boolean bl) throws Exception {
        Class[] classArray = new Class[]{Boolean.TYPE};
        Object[] objectArray = new Object[]{bl ? Boolean.TRUE : Boolean.FALSE};
        Method method = object.getClass().getMethod(string, classArray);
        method.invoke(object, objectArray);
    }

    public static void callSetInt(Object object, String string, int n) throws Exception {
        Class[] classArray = new Class[]{Integer.TYPE};
        Object[] objectArray = new Object[]{n};
        Method method = object.getClass().getMethod(string, classArray);
        method.invoke(object, objectArray);
    }

    public static void callSet(Object object, String string, Object object2) throws Exception {
        Class[] classArray = new Class[]{object2.getClass()};
        Object[] objectArray = new Object[]{object2};
        Method method = object.getClass().getMethod(string, classArray);
        method.invoke(object, objectArray);
    }

    public static Object callGet(Object object, String string) throws Exception {
        Method method = object.getClass().getMethod(string, null);
        return method.invoke(object, (Object[])null);
    }

    public static void call(Object object, String string) throws Exception {
        Method method = object.getClass().getMethod(string, null);
        method.invoke(object, (Object[])null);
    }

    public static Object callAny(Object object, String string, Object[] objectArray) throws Exception {
        Class[] classArray = null;
        if (objectArray != null) {
            classArray = new Class[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                classArray[i] = objectArray[i].getClass();
            }
        }
        return ReflectionUtils.callAny(object, string, classArray, objectArray);
    }

    public static Object callAny(Object object, String string, Class<?>[] classArray, Object[] objectArray) throws Exception {
        Method method = object.getClass().getMethod(string, classArray);
        return method.invoke(object, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object callAnyWithoutException(Object object, Class<?> clazz, String string, Class<?>[] classArray, Object[] objectArray) {
        Method method;
        try {
            method = clazz.getDeclaredMethod(string, classArray);
        }
        catch (Exception exception) {
            method = null;
        }
        if (method != null) {
            try {
                method.setAccessible(true);
                Object object2 = method.invoke(object, objectArray);
                return object2;
            }
            catch (Exception exception) {
                Object var7_9 = null;
                return var7_9;
            }
            finally {
                method.setAccessible(false);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object callStatic(Class<?> clazz, String string, Class<?>[] classArray, Object[] objectArray) throws Exception {
        Method method = clazz.getMethod(string, classArray);
        Object object = null;
        if (method != null) {
            try {
                method.setAccessible(true);
                object = method.invoke(null, objectArray);
            }
            finally {
                method.setAccessible(false);
            }
        }
        return object;
    }

    public static Object createInstance(String string, Class<?>[] classArray, Object[] objectArray) {
        Object var3_3 = null;
        try {
            Class<?> clazz = Class.forName(string);
            if (classArray != null && classArray.length != 0) {
                Constructor<?> constructor = clazz.getConstructor(classArray);
                var3_3 = constructor.newInstance(objectArray);
            } else {
                var3_3 = clazz.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return var3_3;
    }
}

