/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.connector.api.matlab;

import com.mathworks.mvm.MVM;
import com.mathworks.mvm.context.MvmContext;
import com.mathworks.mvm.eventmgr.EventMgr;
import com.mathworks.mvm.eventmgr.MvmListener;
import com.mathworks.mvm.eventmgr.prompt.InputRequestEvent;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

class RunOnInputRequestEvent {
    private static final Logger logger = Logger.getLogger(RunOnInputRequestEvent.class.getName());

    RunOnInputRequestEvent() {
    }

    public static void invoke(Runnable taskToRun, int retryInterval, int maxRetries) {
        RunOnInputRequestEvent.runAsync(new RetryEventMgrRunnable(taskToRun, retryInterval, maxRetries));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runAsync(Runnable runnable) {
        ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName("Connector Runnable");
                thread.setDaemon(true);
                return thread;
            }
        });
        try {
            executor.submit(runnable);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to run task.", e);
        }
        finally {
            executor.shutdown();
        }
    }

    private static class TaskListener
    implements MvmListener<InputRequestEvent> {
        public static final AtomicBoolean waitingToRun = new AtomicBoolean(true);
        private final EventMgr eventMgr;
        private final Runnable serviceToRun;

        TaskListener(EventMgr eventMgr, Runnable serviceToRun) {
            this.eventMgr = eventMgr;
            this.serviceToRun = serviceToRun;
        }

        public void mvmChanged(InputRequestEvent event) {
            block3: {
                try {
                    this.eventMgr.removeMvmListener((MvmListener)this, InputRequestEvent.class);
                    if (waitingToRun.compareAndSet(true, false)) {
                        this.serviceToRun.run();
                    }
                }
                catch (Exception e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError();
                }
            }
        }
    }

    private static class RetryEventMgrRunnable
    implements Runnable {
        private final int retryInterval;
        private final int maxRetries;
        private final Runnable taskToRun;

        public RetryEventMgrRunnable(Runnable taskToRun, int retryInterval, int maxRetries) {
            this.retryInterval = retryInterval;
            this.maxRetries = maxRetries;
            this.taskToRun = taskToRun;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.maxRetries && TaskListener.waitingToRun.get(); ++i) {
                MVM mvm = MvmContext.get();
                EventMgr eventMgr = mvm.getEventMgr();
                TaskListener listener = new TaskListener(eventMgr, this.taskToRun);
                eventMgr.addMvmListener((MvmListener)listener, InputRequestEvent.class);
                try {
                    Thread.sleep(this.retryInterval);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

