/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.product.dao.productdatafile;

import com.mathworks.install.InstalledProduct;
import com.mathworks.install.InstalledProductFactory;
import com.mathworks.product.AbstractProduct;
import com.mathworks.product.Product;
import com.mathworks.product.dao.ProductDao;
import com.mathworks.product.dao.config.DaoConfig;
import com.mathworks.product.dao.config.file.FileDaoConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;

final class ProductDataFileDao
implements ProductDao {
    private static final Logger log = Logger.getLogger("com.mathworks.product.dao.contentsm.ProductDataFileDao");
    private String matlabRootPath = "";

    public ProductDataFileDao(DaoConfig daoConfig) {
        FileDaoConfig fileDaoConfig = (FileDaoConfig)daoConfig;
        this.matlabRootPath = fileDaoConfig.getPath();
    }

    @Override
    public Collection<Product> getInstalledProducts() {
        Collection collection = InstalledProductFactory.getInstalledProducts((String)this.matlabRootPath);
        ArrayList<Product> arrayList = new ArrayList<Product>();
        for (InstalledProduct installedProduct : collection) {
            MWProductAdapter mWProductAdapter = new MWProductAdapter(installedProduct);
            arrayList.add(mWProductAdapter);
        }
        log.fine("ProductDataFileDao getInstalledProducts returning a collection of size: " + arrayList.size());
        return arrayList;
    }

    private final class MWProductAdapter
    extends AbstractProduct {
        private final String name;
        private final int number;
        private final String version;
        private final String release;

        public MWProductAdapter(InstalledProduct installedProduct) {
            this.name = installedProduct.getName();
            this.number = installedProduct.getNumber();
            this.version = installedProduct.getVersion();
            this.release = installedProduct.getRelease();
        }

        @Override
        public Integer getBitNumber() {
            return this.number;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public String getRelease() {
            return this.release;
        }

        @Override
        public String getDate() {
            return "";
        }

        public String toString() {
            return this.name;
        }
    }
}

