/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util.tree;

import com.mathworks.util.tree.Tree;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class DefaultMutableTree<T>
implements Tree<T> {
    private T fRoot;
    private Map<T, List<T>> fChildren;
    private Map<T, T> fParents;

    public DefaultMutableTree() {
        this(null);
    }

    public DefaultMutableTree(T t) {
        this.fRoot = t;
        this.fChildren = new HashMap<T, List<T>>();
        this.fParents = new HashMap<T, T>();
    }

    public void addChild(T t, T t2) {
        List<T> list = this.fChildren.get(t);
        if (list == null) {
            list = new Vector<T>();
            this.fChildren.put(t, list);
        }
        list.add(t2);
        this.fParents.put(t2, t);
    }

    public void removeChild(T t, T t2) {
        List<T> list = this.fChildren.get(t);
        if (list != null) {
            list.remove(t2);
        }
        this.fParents.remove(t2);
    }

    public void removeChild(T t, int n) {
        List<T> list = this.fChildren.get(t);
        if (list != null) {
            this.fParents.remove(list.get(n));
            list.remove(n);
        }
    }

    @Override
    public T getRoot() {
        return this.fRoot;
    }

    @Override
    public T getChild(T t, int n) {
        return this.fChildren.get(t).get(n);
    }

    @Override
    public T getParent(T t) {
        return this.fParents.get(t);
    }

    @Override
    public int getChildCount(T t) {
        List<T> list = this.fChildren.get(t);
        return list == null ? 0 : list.size();
    }
}

