/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BluetoothConnectionParams;
import com.intel.bluetooth.EmulatorLinkedConnection;
import com.intel.bluetooth.EmulatorLocalDevice;
import java.io.IOException;

class EmulatorL2CAPClient
extends EmulatorLinkedConnection {
    private int receiveMTU;
    private int transmitMTU;

    EmulatorL2CAPClient(EmulatorLocalDevice localDevice, long handle) {
        super(localDevice, handle);
    }

    void connect(BluetoothConnectionParams params, int receiveMTU, int transmitMTU) throws IOException {
        this.connectVerify(params);
        this.connectionHandle = this.localDevice.getDeviceManagerService().l2Connect(this.localDevice.getAddress(), params.address, params.channel, params.authenticate, params.encrypt, receiveMTU, params.timeout);
        this.remoteAddress = params.address;
        this.receiveMTU = receiveMTU;
        this.transmitMTU = transmitMTU;
        int remoteDeviceReceiveMTU = this.localDevice.getDeviceManagerService().l2RemoteDeviceReceiveMTU(this.localDevice.getAddress(), this.connectionHandle);
        if (this.transmitMTU == -1) {
            this.transmitMTU = remoteDeviceReceiveMTU;
        } else if (this.transmitMTU >= remoteDeviceReceiveMTU) {
            this.transmitMTU = remoteDeviceReceiveMTU;
        }
    }

    void connect(long remoteAddress, long connectionHandle, int receiveMTU, int transmitMTU) throws IOException {
        super.connect(remoteAddress, connectionHandle);
        this.receiveMTU = receiveMTU;
        this.transmitMTU = transmitMTU;
    }

    int getReceiveMTU() throws IOException {
        return this.receiveMTU;
    }

    int getTransmitMTU() throws IOException {
        return this.transmitMTU;
    }

    boolean ready() throws IOException {
        return this.localDevice.getDeviceManagerService().l2Ready(this.localDevice.getAddress(), this.connectionHandle);
    }

    int receive(byte[] inBuf) throws IOException {
        byte[] packetData = this.localDevice.getDeviceManagerService().l2Receive(this.localDevice.getAddress(), this.connectionHandle, this.receiveMTU);
        int length = packetData.length;
        if (length > inBuf.length) {
            length = inBuf.length;
        }
        System.arraycopy(packetData, 0, inBuf, 0, length);
        return length;
    }

    void send(byte[] data) throws IOException {
        if (data.length > this.transmitMTU) {
            byte[] b = new byte[this.transmitMTU];
            System.arraycopy(data, 0, b, 0, this.transmitMTU);
            data = b;
        }
        this.localDevice.getDeviceManagerService().l2Send(this.localDevice.getAddress(), this.connectionHandle, data);
    }
}

