/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.emu;

import com.intel.bluetooth.emu.Device;
import com.intel.bluetooth.emu.DeviceDescriptor;
import com.intel.bluetooth.emu.MonitorItem;
import java.io.IOException;
import java.io.ObjectOutputStream;

public class MonitorDevice
implements MonitorItem {
    private static final long serialVersionUID = 1L;
    private transient Device device;
    protected DeviceDescriptor deviceDescriptor;
    private boolean hasServices;
    private boolean listening;
    private Long[] connectedTo;

    protected MonitorDevice() {
    }

    MonitorDevice(Device device) {
        this.device = device;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.updateFields();
        out.defaultWriteObject();
    }

    protected void updateFields() {
        if (this.device != null) {
            this.deviceDescriptor = this.device.getDescriptor();
            this.hasServices = this.device.isHasServices();
            this.listening = this.device.isListening();
            this.connectedTo = this.device.getConnectedTo();
        }
    }

    public DeviceDescriptor getDeviceDescriptor() {
        return this.deviceDescriptor;
    }

    public boolean isHasServices() {
        return this.hasServices;
    }

    public boolean isListening() {
        return this.listening;
    }

    public Long[] getConnectedTo() {
        return this.connectedTo;
    }
}

