/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import com.mathworks.util.PlatformInfo;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.TextAction;

public final class Log {
    public static volatile boolean LOGGING = false;
    private static volatile PrintStream sPs = null;
    private static volatile boolean sExiting = false;
    private static final AtomicBoolean STARTED = new AtomicBoolean(false);

    private Log() {
    }

    private static boolean logging() {
        return LOGGING && !sExiting;
    }

    private static synchronized void defaultSink() {
        if (sPs == null && !sExiting) {
            try (TextAreaOutputStream textAreaOutputStream = new TextAreaOutputStream();){
                Log.setSink(textAreaOutputStream);
            }
        }
    }

    public static synchronized void log(String string) {
        if (Log.logging()) {
            Log.defaultSink();
            sPs.print(string);
        }
    }

    public static synchronized void logException(Exception exception) {
        if (Log.logging()) {
            Log.logThrowable(exception);
        }
    }

    public static synchronized void dumpStack() {
        if (Log.logging()) {
            Log.defaultSink();
            Exception exception = new Exception("Stack trace");
            Log.logException(exception);
        }
    }

    public static synchronized void logThrowable(Throwable throwable) {
        if (Log.logging()) {
            Log.defaultSink();
            String string = throwable.getMessage();
            if (throwable instanceof BadLocationException) {
                string = string + " at offset " + ((BadLocationException)throwable).offsetRequested();
            }
            sPs.println(string);
            throwable.printStackTrace(sPs);
        }
    }

    public static synchronized void printLn(String string) {
        if (Log.logging()) {
            Log.defaultSink();
            sPs.println(string);
        }
    }

    public static void setLogging(boolean bl) {
        LOGGING = bl;
        if (bl && STARTED.compareAndSet(false, true) && sPs == null) {
            Log.defaultSink();
        }
    }

    public static synchronized boolean isLogging() {
        return LOGGING;
    }

    public static synchronized boolean isVisible() {
        return TextAreaOutputStream.isVisible();
    }

    public static synchronized String getContent() throws BadLocationException {
        return TextAreaOutputStream.getContent();
    }

    public static synchronized void setSink(OutputStream outputStream) {
        if (sPs != null) {
            sPs.flush();
            sPs.close();
        }
        sPs = new PrintStream(outputStream, true);
        System.setErr(sPs);
    }

    public static synchronized void exiting() {
        if (sExiting) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TextAreaOutputStream.exiting();
                if (sPs != null) {
                    sPs.close();
                    sPs = null;
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
        sExiting = true;
    }

    private static final class TextAreaOutputStream
    extends OutputStream {
        private static JFrame sFrame = null;
        private static JTextArea sTestLog = null;
        private static String sConfigString = null;
        private static boolean sExitingCalled = false;

        TextAreaOutputStream() {
            try {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        sFrame = new JFrame("Log Window");
                        sTestLog = new JTextArea(30, 60);
                        sTestLog.setEditable(false);
                        sTestLog.setWrapStyleWord(true);
                        sTestLog.setLineWrap(true);
                        float f = PlatformInfo.isMacintosh() ? 72 : Toolkit.getDefaultToolkit().getScreenResolution();
                        Font font = new Font("Monospaced", 0, 12);
                        float f2 = (float)font.getSize() * (f / 72.0f);
                        font = font.deriveFont(f2);
                        sTestLog.setFont(font);
                        JScrollPane jScrollPane = new JScrollPane(sTestLog);
                        JMenuBar jMenuBar = new JMenuBar();
                        jMenuBar.add(TextAreaOutputStream.makeTheMenu());
                        sFrame.setName("Log Output Window");
                        sFrame.setJMenuBar(jMenuBar);
                        sFrame.getContentPane().add(jScrollPane);
                        sFrame.setLocation(10, 10);
                        sFrame.pack();
                        sFrame.setVisible(false);
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    SwingUtilities.invokeAndWait(runnable);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private static String getContent() throws BadLocationException {
            assert (sTestLog != null);
            return sTestLog.getDocument().getText(0, sTestLog.getDocument().getLength());
        }

        @Override
        public void close() {
            if (!sExitingCalled) {
                this.flush();
            }
        }

        @Override
        public void flush() {
            if (!sExitingCalled) {
                sTestLog.repaint();
            }
        }

        private static void lazyShow() {
            assert (sFrame != null);
            if (!sFrame.isVisible()) {
                if (sConfigString == null) {
                    String string = System.getProperty("os.name");
                    string = string + ", " + System.getProperty("os.arch");
                    string = string + ", " + System.getProperty("os.version");
                    sConfigString = "Operating System: " + string + "\n";
                    String string2 = System.getProperty("java.vendor");
                    string2 = string2 + ", " + System.getProperty("java.version");
                    sConfigString = sConfigString + "JRE Version: " + string2 + "\n\n";
                }
                assert (sTestLog != null);
                sTestLog.setText(null);
                sTestLog.append(sConfigString);
                sFrame.setVisible(true);
            }
        }

        static boolean isVisible() {
            return sFrame != null && sFrame.isVisible();
        }

        static void exiting() {
            sExitingCalled = true;
            if (sFrame != null) {
                sFrame.setVisible(false);
                sFrame.dispose();
            }
        }

        private static JMenu makeTheMenu() {
            JMenu jMenu = new JMenu("Edit");
            jMenu.add(new LogSelectAction());
            DefaultEditorKit.CopyAction copyAction = new DefaultEditorKit.CopyAction();
            copyAction.putValue("Name", "Copy");
            jMenu.add(copyAction);
            return jMenu;
        }

        @Override
        public void write(byte[] byArray) {
            TextAreaOutputStream.appendText(new String(byArray));
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
            TextAreaOutputStream.appendText(new String(byArray, n, n2));
        }

        @Override
        public void write(int n) {
            TextAreaOutputStream.appendText(new String(new byte[]{(byte)n}));
        }

        private static void appendText(final String string) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (!sExitingCalled) {
                        TextAreaOutputStream.lazyShow();
                        sTestLog.append(string);
                        sTestLog.setCaretPosition(sTestLog.getText().length());
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }

        private static final class LogSelectAction
        extends TextAction {
            LogSelectAction() {
                super("Select Message");
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                sTestLog.getCaret().setDot(0);
                int n = sTestLog.getDocument().getLength();
                sTestLog.moveCaretPosition(n);
            }
        }
    }
}

