/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import com.mathworks.util.NativeJava;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.nio.ByteOrder;

public final class PlatformInfo {
    public static final int DEFAULT_APPEARANCE = -1;
    public static final int MACINTOSH = 0;
    public static final int WINDOWS = 1;
    public static final int UNIX = 2;
    public static final int UNKNOWN = 0;
    public static final int APPLE = 2;
    public static final int VERSION_118 = 1;
    public static final int VERSION_117 = 2;
    public static final int VERSION_12 = 3;
    public static final int VERSION_13 = 4;
    public static final int VERSION_14 = 5;
    public static final int VERSION_15 = 6;
    public static final int VERSION_16 = 7;
    public static final int VERSION_17 = 8;
    public static final int UNKNOWN_VM_VERSION = Integer.MAX_VALUE;
    private static final int UNINITIALIZED = -2;
    public static final int CLASSIC = -1;
    public static final int BLUE = 0;
    public static final int GREEN = 1;
    public static final int SILVER = 2;
    private static final int WIN_98 = 1;
    private static final int WIN_NT = 2;
    private static final int WIN_ME = 3;
    private static final int WIN_2000 = 4;
    private static final int WIN_XP = 5;
    private static final int WIN_VISTA = 6;
    private static final int WIN_7 = 7;
    private static final int LINUX = 8;
    private static final int SOLARIS = 9;
    private static final int LINUX_64 = 10;
    private static final int TIGER = 11;
    private static final int LEOPARD = 12;
    private static final int WIN_8 = 13;
    private static final int POWERPC = 0;
    private static final int INTEL = 1;
    private static int sPlatform;
    private static int sVersion;
    private static int sOSVersion;
    private static int sScheme;
    private static int sMacArch;
    private static boolean sIs64Bit;
    private static boolean sIsBigEndian;
    private static final String XP_THEME_ACTIVE_PROPERTY = "win.xpstyle.themeActive";
    private static final String XP_THEME_COLOR_PROPERTY = "win.xpstyle.colorName";
    public static final int MAC_THEME_BLUE = 1;
    public static final int MAC_THEME_GRAPHITE = 6;

    private PlatformInfo() {
    }

    private static int determinePlatform() {
        int n;
        String string = System.getProperty("sun.arch.data.model");
        sIs64Bit = string != null && string.equals("64");
        sIsBigEndian = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
        String string2 = System.getProperty("os.name");
        if (string2.startsWith("Mac OS")) {
            String string3 = System.getProperty("os.version");
            if (string3.startsWith("10.4")) {
                sOSVersion = 11;
            } else if (string3.startsWith("10.5")) {
                sOSVersion = 12;
            }
            n = 0;
            String string4 = System.getProperty("os.arch");
            if ("ppc".equals(string4)) {
                sMacArch = 0;
            } else if ("i386".equals(string4) || "x86_64".equals(string4)) {
                sMacArch = 1;
            }
        } else if (string2.startsWith("Windows")) {
            n = 1;
            if (string2.contains("98")) {
                sOSVersion = 1;
            } else if (string2.contains("ME")) {
                sOSVersion = 3;
            } else if (string2.contains("NT")) {
                sOSVersion = 2;
                String string5 = System.getProperty("os.version");
                if (string5 != null && string5.length() > 0 && string5.charAt(0) == '6') {
                    sOSVersion = 6;
                }
            } else if (string2.contains("2000")) {
                sOSVersion = 4;
                String string6 = System.getProperty("os.version");
                if (string6 != null && string6.length() > 2) {
                    char c = string6.charAt(0);
                    char c2 = string6.charAt(2);
                    if (Character.isDigit(c) && Character.isDigit(c2)) {
                        int n2 = Character.getNumericValue(c);
                        int n3 = Character.getNumericValue(c2);
                        if (n2 == 5 && n3 > 0 || n2 > 5) {
                            sOSVersion = 5;
                        }
                    }
                }
            } else {
                sOSVersion = string2.contains("2003") ? 5 : (string2.contains("XP") ? 5 : (string2.contains("Vista") ? 6 : (string2.contains("Windows 7") ? 7 : (string2.contains("Windows 8") ? 13 : 1))));
            }
        } else {
            n = 2;
            if (string2.contains("Linux")) {
                String string7 = System.getProperty("os.arch");
                sOSVersion = string7 != null && string7.contains("64") ? 10 : 8;
            } else if (string2.contains("SunOS")) {
                sOSVersion = 9;
            }
        }
        return n;
    }

    public static int getPlatform() {
        return sPlatform;
    }

    public static boolean isMacintosh() {
        return sPlatform == 0;
    }

    public static boolean isIntelMac() {
        return PlatformInfo.isMacintosh() && sMacArch == 1;
    }

    public static boolean isIntelMac64() {
        return PlatformInfo.isMacintosh() && sMacArch == 1 && sIs64Bit;
    }

    public static boolean isMacOSLeopardOrLater() {
        String string = System.getProperty("os.version");
        return PlatformInfo.isMacintosh() && string.matches("10\\.[5-9].*");
    }

    public static boolean isUnix() {
        return sPlatform == 2 || sPlatform == 0;
    }

    public static boolean isXWindows() {
        return sPlatform == 2;
    }

    public static boolean isWindows() {
        return sPlatform == 1;
    }

    public static boolean isWindows2000() {
        return sOSVersion == 4;
    }

    public static boolean isWindowsXP() {
        return sOSVersion == 5;
    }

    public static boolean isWindowsVista() {
        return sOSVersion == 6;
    }

    public static boolean isWindowsVistaAndAbove() {
        return PlatformInfo.isWindows() && sOSVersion >= 6;
    }

    public static boolean isWindows64() {
        return PlatformInfo.isWindows() && sIs64Bit;
    }

    public static boolean isWindows7() {
        return PlatformInfo.isWindows() && sOSVersion == 7;
    }

    public static boolean isWindows8() {
        return PlatformInfo.isWindows() && sOSVersion == 13;
    }

    public static boolean isLinux() {
        return sOSVersion == 8 || sOSVersion == 10;
    }

    public static boolean isLinux64() {
        return sOSVersion == 10;
    }

    public static boolean isSolaris() {
        return sOSVersion == 9;
    }

    public static boolean isSolaris64() {
        return PlatformInfo.isSolaris() && sIs64Bit;
    }

    public static boolean is64Bit() {
        return sIs64Bit;
    }

    public static boolean isBigEndian() {
        return sIsBigEndian;
    }

    public static boolean isBlackdownVM() {
        return false;
    }

    private static int determineVersion() {
        String string = System.getProperty("java.version");
        int n = string.startsWith("1.1.8") ? 1 : (string.startsWith("1.3") ? 4 : (string.startsWith("1.4") ? 5 : (string.startsWith("1.5") ? 6 : (string.startsWith("1.6") ? 7 : (string.startsWith("1.7") ? 8 : (string.startsWith("1.2") ? 3 : (string.startsWith("1.1.7") ? 2 : Integer.MAX_VALUE)))))));
        return n;
    }

    public static int getVersion() {
        return sVersion;
    }

    public static boolean isVersion118() {
        return sVersion == 1;
    }

    public static boolean isVersion14() {
        return sVersion == 5;
    }

    public static boolean isVersion15() {
        return sVersion == 6;
    }

    public static boolean isVersion16() {
        return sVersion == 7;
    }

    public static boolean isVersion17() {
        return sVersion == 8;
    }

    public static boolean isVersion2() {
        return sVersion != 2 && sVersion != 1;
    }

    public static int getAppearance() {
        return PlatformInfo.getPlatform();
    }

    public static boolean useWindowsXPAppearance() {
        return PlatformInfo.isWindowsModernAppearance();
    }

    public static boolean isWindowsXPAppearance() {
        return PlatformInfo.isWindowsXP() && !PlatformInfo.isWindowsClassicAppearance();
    }

    public static boolean isWindowsVistaAppearance() {
        return PlatformInfo.isWindowsVistaAndAbove() && !PlatformInfo.isWindowsClassicAppearance();
    }

    public static boolean isWindowsModernAppearance() {
        return PlatformInfo.isWindows() && !PlatformInfo.isWindowsClassicAppearance();
    }

    public static boolean isWindowsClassicAppearance() {
        return PlatformInfo.isWindows() && PlatformInfo.getWindowsColorScheme() == -1;
    }

    public static int getWindowsXPScheme() {
        return PlatformInfo.getWindowsColorScheme();
    }

    public static int getWindowsColorScheme() {
        if (sScheme == -2) {
            String string;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Boolean bl = (Boolean)toolkit.getDesktopProperty(XP_THEME_ACTIVE_PROPERTY);
            sScheme = bl == null || bl == false ? -1 : ((string = (String)toolkit.getDesktopProperty(XP_THEME_COLOR_PROPERTY)) == null || string.equals("NormalColor") ? 0 : (string.equals("HomeStead") ? 1 : (string.equals("Metallic") ? 2 : 0)));
        }
        return sScheme;
    }

    public static int getMacAppearanceTheme() {
        assert (PlatformInfo.isMacintosh()) : "Call PlatformInfo.isMacintosh() before calling getMacAppearanceTheme";
        return NativeJava.getMacControlTint();
    }

    static {
        sScheme = -2;
        sPlatform = PlatformInfo.determinePlatform();
        sVersion = PlatformInfo.determineVersion();
        if (PlatformInfo.isWindowsXP()) {
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    sScheme = -2;
                }
            };
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit.getDesktopProperty(XP_THEME_ACTIVE_PROPERTY);
            toolkit.getDesktopProperty(XP_THEME_COLOR_PROPERTY);
            toolkit.addPropertyChangeListener(XP_THEME_ACTIVE_PROPERTY, propertyChangeListener);
            toolkit.addPropertyChangeListener(XP_THEME_COLOR_PROPERTY, propertyChangeListener);
        }
    }
}

