/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.dataHandlers;

import com.mathworks.ide.arrayeditor.ArrayView;
import com.mathworks.ide.arrayeditor.MatlabVariableData;
import com.mathworks.mwt.table.LabeledImageResource;
import com.mathworks.mwt.table.Table;
import com.mathworks.mwt.table.TableDataEvent;
import com.mathworks.mwt.table.TableDataListener;
import com.mathworks.mwt.table.TableEvent;
import com.mathworks.mwt.table.TableListener;
import com.mathworks.mwt.table.ValueEvent;
import com.mathworks.mwt.table.ValueListener;
import com.mathworks.peermodel.pageddata.DataModelHandler;
import com.mathworks.peermodel.pageddata.ServerPagedData;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import sun.awt.image.ToolkitImage;

public class MwtTableDataHandler
implements DataModelHandler,
TableListener,
ValueListener,
TableDataListener {
    private final Table table;
    private ServerPagedData serverPagedData;
    private AtomicBoolean dirty = new AtomicBoolean(false);
    private static ScheduledExecutorService threadPool = Executors.newScheduledThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("mwt table handler");
            thread.setDaemon(true);
            return thread;
        }
    });
    private CachedValue cachedValue;

    public MwtTableDataHandler(Table table) {
        this.table = table;
        table.addTableListener((TableListener)this);
        table.addValueListener((ValueListener)this);
        table.getData().addDataListener((TableDataListener)this);
    }

    public void update(ServerPagedData serverPagedData) {
        this.serverPagedData = serverPagedData;
    }

    public void destroy() {
        this.table.removeTableListener((ValueListener)this);
        this.table.removeValueListener((ValueListener)this);
    }

    public int getRowCount() {
        return this.table.getData().getHeight();
    }

    public int getColumnCount() {
        return this.table.getData().getWidth();
    }

    public boolean is2D() {
        return true;
    }

    public Object getValueAt(int row) {
        throw new UnsupportedOperationException("Not supported with 2D data models");
    }

    public void setValueAt(Object value, int row) {
        throw new UnsupportedOperationException("Not supported with 2D data models");
    }

    public Object getValueAt(int row, int col) {
        if (this.dirty.get() || this.cachedValue == null || row != this.cachedValue.row || col != this.cachedValue.col) {
            Object cell = this.table.getData().getData(row, col);
            if (cell instanceof LabeledImageResource) {
                LabeledImageResource imageResource = (LabeledImageResource)cell;
                HashMap<String, Object> data = new HashMap<String, Object>();
                Image rawImage = imageResource.getImage();
                if (rawImage instanceof ToolkitImage) {
                    ToolkitImage toolkitImage = (ToolkitImage)rawImage;
                    BufferedImage icon = new BufferedImage(toolkitImage.getWidth(), toolkitImage.getHeight(), 1);
                    icon.getGraphics().drawImage(toolkitImage, 0, 0, null);
                    data.put("icon", icon);
                }
                data.put("value", imageResource.getLabel());
                return data;
            }
            return cell;
        }
        return this.cachedValue.value;
    }

    public void setValueAt(Object value, int row, int col) {
        this.cachedValue = new CachedValue(value, row, col);
        if (this.table.getData() instanceof MatlabVariableData && this.table instanceof ArrayView) {
            ((MatlabVariableData)this.table.getData()).setData(row, col, value, (ArrayView)this.table);
        } else {
            this.table.getData().setData(row, col, value);
        }
    }

    public void dispatchCellEvent(int row, int column, Map<String, Object> data) {
        throw new UnsupportedOperationException("Not supported with mwt Tables");
    }

    public void editCommitted(TableEvent tableEvent) {
        this.markDirty();
    }

    public void editCancelled(TableEvent tableEvent) {
        this.markDirty();
    }

    public void valueChanged(ValueEvent valueEvent) {
        this.markDirty();
    }

    public void dataChanged(TableDataEvent tableDataEvent) {
        this.markDirty();
    }

    public void dataBoundsChanging(TableDataEvent tableDataEvent) {
        this.markDirty();
    }

    public void dataBoundsChanged(TableDataEvent tableDataEvent) {
        this.markDirty();
    }

    public void rowsAdded(TableDataEvent tableDataEvent) {
        this.markDirty();
    }

    public void rowsRemoved(TableDataEvent tableDataEvent) {
        this.markDirty();
    }

    protected void markDirty() {
        this.dirty.set(true);
        threadPool.schedule(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (MwtTableDataHandler.this.serverPagedData != null && MwtTableDataHandler.this.dirty.compareAndSet(true, false)) {
                            MwtTableDataHandler.this.serverPagedData.update();
                        }
                    }
                });
            }
        }, 50L, TimeUnit.MILLISECONDS);
    }

    private class CachedValue {
        final Object value;
        final int row;
        final int col;

        public CachedValue(Object value, int row, int col) {
            this.value = value;
            this.row = row;
            this.col = col;
        }
    }
}

