/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.componentHandlers;

import com.mathworks.matlabserver.jcp.ComponentConstants;
import com.mathworks.matlabserver.jcp.contextMenus.ContextMenuManager;
import com.mathworks.matlabserver.jcp.contextMenus.ContextMenuMatcher;
import com.mathworks.matlabserver.jcp.contextMenus.InstanceContextMenuMatcher;
import com.mathworks.matlabserver.jcp.filters.FilterFactory;
import com.mathworks.matlabserver.jcp.handlers.Handler;
import com.mathworks.matlabserver.jcp.handlers.HandlerVisitor;
import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.events.Event;
import com.mathworks.peermodel.events.Observer;
import com.mathworks.widgets.DropdownButton;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicComboPopup;

public abstract class AbstractComponentHandler
implements Handler,
ComponentConstants {
    private static final int EDT_LOOP_COUNT = 10;
    private static boolean focusTrackingEnabled = false;
    private Handler parentHandler;
    private List<Handler> children = new Vector<Handler>();
    protected Component component;
    private Container parentContainer = null;
    protected PeerNode peerNode;
    private boolean active = false;
    private boolean filtered = false;
    protected List<ContextMenuMatcher> menuMatchers = new ArrayList<ContextMenuMatcher>();
    private ComponentListener componentListener = new ComponentListener(){

        @Override
        public void componentResized(ComponentEvent e) {
            AbstractComponentHandler.this.markDirty();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            AbstractComponentHandler.this.markDirty();
        }

        @Override
        public void componentShown(ComponentEvent e) {
            AbstractComponentHandler.this.doComponentShown();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            AbstractComponentHandler.this.doComponentHidden();
        }
    };
    private FocusListener focusListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent e) {
            AbstractComponentHandler.this.markDirty();
        }

        @Override
        public void focusLost(FocusEvent e) {
            AbstractComponentHandler.this.markDirty();
        }
    };
    private Observer focusedPropertyListener = new Observer(){

        public void handle(Event event) {
            if (!AbstractComponentHandler.this.ORIGIN.equals(event.getOriginator()) && "focused".equals(event.getData().get("key")) && AbstractComponentHandler.this.peerNode.hasProperty("focused") && ((Boolean)AbstractComponentHandler.this.peerNode.getProperty("focused")).booleanValue()) {
                AbstractComponentHandler.this.invokeLaterEDT(new Runnable(){

                    @Override
                    public void run() {
                        AbstractComponentHandler.this.component.requestFocusInWindow();
                    }
                });
            }
        }
    };
    protected boolean updatingPeerNode = false;
    protected Object ORIGIN = new Object();
    private AWTEventListener awtComponentListener = new AWTEventListener(){

        @Override
        public void eventDispatched(AWTEvent event) {
            if (event.getSource().equals(AbstractComponentHandler.this.component)) {
                AbstractComponentHandler.this.markDirty();
            }
        }
    };
    private PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            AbstractComponentHandler.this.markDirty();
        }
    };

    public static boolean isFocusTrackingEnabled() {
        return focusTrackingEnabled;
    }

    public static void setFocusTrackingEnabled(boolean enabled) {
        focusTrackingEnabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doComponentShown() {
        this.markDirty();
        this.updatingPeerNode = true;
        try {
            this.peerNode.setProperty("visibility", (Object)true, this.ORIGIN);
        }
        finally {
            this.updatingPeerNode = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doComponentHidden() {
        this.markDirty();
        this.updatingPeerNode = true;
        try {
            this.peerNode.setProperty("visibility", (Object)false, this.ORIGIN);
        }
        finally {
            this.updatingPeerNode = false;
        }
    }

    @Override
    public abstract String getType();

    @Override
    public void handle(Handler parentHandler, Component component, PeerNode parentNode, Container parentContainer) {
        this.parentContainer = parentContainer;
        this.handle(parentHandler, component, parentNode);
    }

    @Override
    public void handle(Handler parentHandler, Component component, PeerNode parentNode) {
        this.parentHandler = parentHandler;
        if (parentHandler != null) {
            boolean addedHandler = false;
            if (this.parentContainer != null) {
                for (int i = 0; i < this.parentContainer.getComponentCount(); ++i) {
                    if (!this.parentContainer.getComponent(i).equals(component)) continue;
                    parentHandler.addChildHandler(this, i);
                    addedHandler = true;
                    break;
                }
            }
            if (!addedHandler) {
                parentHandler.addChildHandler(this);
            }
        }
        if (this.parentContainer == null) {
            this.parentContainer = component.getParent();
        }
        if (!this.active) {
            this.component = component;
            this.createPeerNode(parentNode);
            this.addEventListeners();
            this.active = true;
        }
    }

    @Override
    public void destroy() {
        if (this.active) {
            this.removeEventListeners();
            PeerNode node = this.getPeerNode();
            int count = 0;
            while (this.active && count < 10) {
                try {
                    ++count;
                    if (node.hasParent()) {
                        node.destroy(this.ORIGIN);
                    }
                    this.active = false;
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {}
            }
            this.active = false;
        }
        if (this.parentHandler != null && this.parentHandler instanceof AbstractComponentHandler) {
            ((AbstractComponentHandler)this.parentHandler).removeChildHandler(this);
        }
    }

    @Override
    public final PeerNode getPeerNode() {
        return this.peerNode;
    }

    protected void addEventListeners() {
        this.component.addComponentListener(this.componentListener);
        this.component.addPropertyChangeListener(this.propertyChangeListener);
        Toolkit.getDefaultToolkit().addAWTEventListener(this.awtComponentListener, 1L);
        if (AbstractComponentHandler.isFocusTrackingEnabled()) {
            this.component.addFocusListener(this.focusListener);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractComponentHandler.this.addContextMenuListeners();
            }
        });
        this.addPeerNodeListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void markDirty() {
        this.updatingPeerNode = true;
        try {
            if (this.peerNode != null) {
                this.peerNode.setProperties(this.getProperties(), this.ORIGIN);
            }
        }
        finally {
            this.updatingPeerNode = false;
        }
    }

    protected void removeEventListeners() {
        this.component.removeComponentListener(this.componentListener);
        this.component.removePropertyChangeListener(this.propertyChangeListener);
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.awtComponentListener);
        if (AbstractComponentHandler.isFocusTrackingEnabled()) {
            this.component.removeFocusListener(this.focusListener);
        }
        this.removeContextMenuListeners();
        this.removePeerNodeListeners();
    }

    protected void addContextMenuListeners() {
        if (this.component != null && this.component.isValid() && !(this.component instanceof MenuElement)) {
            ArrayList<JPopupMenu> menus = new ArrayList<JPopupMenu>();
            this.getContextMenus(this.component, this.component.getClass(), menus);
            for (JPopupMenu menu : menus) {
                InstanceContextMenuMatcher matcher = new InstanceContextMenuMatcher(menu);
                this.menuMatchers.add(matcher);
                ContextMenuManager.getInstance().addContextMenuHandler(matcher);
            }
        }
    }

    protected void getContextMenus(Object component, Class aClass, List<JPopupMenu> menus) {
        for (Field field : aClass.getDeclaredFields()) {
            if (JPopupMenu.class.isAssignableFrom(field.getType())) {
                field.setAccessible(true);
                try {
                    JPopupMenu menu = (JPopupMenu)field.get(component);
                    if (menu == null || menu instanceof BasicComboPopup || component instanceof DropdownButton) continue;
                    menus.add(menu);
                }
                catch (IllegalAccessException ignore) {}
                continue;
            }
            if (!field.getName().equals("this$0")) continue;
            field.setAccessible(true);
            try {
                Object enclosing = field.get(component);
                if (enclosing == null) continue;
                this.getContextMenus(enclosing, enclosing.getClass(), menus);
            }
            catch (IllegalAccessException ignore) {
                // empty catch block
            }
        }
        if (!aClass.getSuperclass().equals(Object.class)) {
            this.getContextMenus(component, aClass.getSuperclass(), menus);
        }
    }

    protected void removeContextMenuListeners() {
        for (ContextMenuMatcher matcher : this.menuMatchers) {
            ContextMenuManager.getInstance().removeContextMenuHandler(matcher);
        }
        this.menuMatchers.clear();
    }

    protected void addPeerNodeListeners() {
        if (AbstractComponentHandler.isFocusTrackingEnabled()) {
            this.peerNode.addEventListener("propertySet", this.focusedPropertyListener);
        }
    }

    protected void removePeerNodeListeners() {
        if (this.peerNode.hasEventListener("propertySet", this.focusedPropertyListener)) {
            this.peerNode.removeEventListener("propertySet", this.focusedPropertyListener);
        }
    }

    protected void createPeerNode(PeerNode parent) {
        if (this.parentContainer != null) {
            for (int i = 0; i < this.parentContainer.getComponentCount(); ++i) {
                if (!this.parentContainer.getComponent(i).equals(this.component)) continue;
                this.peerNode = parent.addChild(this.getType(), this.getProperties(), i);
                return;
            }
        }
        this.peerNode = parent.addChild(this.getType(), this.getProperties());
    }

    protected final Map<String, Object> getProperties() {
        Map<String, Object> properties = this.doGetProperties(this.component);
        FilterFactory.getInstance().getFilterRules(this).updateAll(this, properties);
        properties.put("filtered", this.filtered);
        return properties;
    }

    protected Map<String, Object> doGetProperties(Component component) {
        String name;
        ConcurrentHashMap<String, Object> properties = new ConcurrentHashMap<String, Object>();
        properties.put("swingType", this.getComponentSwingType());
        properties.put("position", this.getComponentBounds(component));
        properties.put("enabled", component.isEnabled());
        properties.put("visibility", component.isVisible());
        properties.put("focusable", component.isFocusable());
        properties.put("focused", component.isFocusOwner());
        if (component.isBackgroundSet() && component.getBackground() != null) {
            properties.put("background", new int[]{component.getBackground().getRed(), component.getBackground().getGreen(), component.getBackground().getBlue()});
        }
        if ((name = this.getComponentName()) != null && name.length() > 0) {
            properties.put("name", name);
        }
        if (component.getAccessibleContext() != null && component.getAccessibleContext().getAccessibleDescription() != null) {
            properties.put("tooltip", component.getAccessibleContext().getAccessibleDescription());
        }
        return properties;
    }

    protected Rectangle getComponentBounds(Component component) {
        return component.getBounds();
    }

    @Override
    public final Component getComponent() {
        return this.component;
    }

    @Override
    public boolean ownsComponent(Component component) {
        return this.component.equals(component);
    }

    @Override
    public final List<Handler> getChildrenHandlers() {
        return this.children;
    }

    @Override
    public final void addChildHandler(Handler child) {
        this.children.add(child);
    }

    @Override
    public final void addChildHandler(Handler child, int location) {
        if ((location = Math.max(0, location)) >= this.children.size()) {
            this.children.add(child);
        } else {
            this.children.add(location, child);
        }
    }

    protected final Handler getChildHandler(Component component) {
        for (Handler child : this.children) {
            if (!child.ownsComponent(component)) continue;
            return child;
        }
        return null;
    }

    protected final void removeChildHandler(Handler child) {
        this.children.remove(child);
    }

    @Override
    public final Handler getParentHandler() {
        return this.parentHandler;
    }

    @Override
    public String getComponentName() {
        return this.component.getName();
    }

    @Override
    public String getComponentSwingType() {
        return this.component.getClass().getSimpleName();
    }

    @Override
    public final void setFiltered(boolean newFiltered) {
        this.filtered = newFiltered;
        if (this.peerNode != null) {
            this.peerNode.setProperty("filtered", (Object)this.filtered, this.ORIGIN);
        }
    }

    @Override
    public final boolean isFiltered() {
        if (this.peerNode != null && this.peerNode.hasProperty("filtered")) {
            return (Boolean)this.peerNode.getProperty("filtered");
        }
        return this.filtered;
    }

    protected final void invokeLaterEDT(final Runnable runnable) {
        final int[] count = new int[]{0};
        Runnable looper = new Runnable(){

            @Override
            public void run() {
                if (count[0] < 10) {
                    count[0] = count[0] + 1;
                    SwingUtilities.invokeLater(this);
                } else {
                    runnable.run();
                }
            }
        };
        SwingUtilities.invokeLater(looper);
    }

    protected final void invokeAndWaitEDT(Runnable runnable) {
        try {
            for (int i = 0; i < 10; ++i) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
            }
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void accept(HandlerVisitor visitor) {
        visitor.visit(this);
        for (Handler child : this.children) {
            child.accept(visitor);
        }
    }

    @Override
    public void acceptPostOrder(HandlerVisitor visitor) {
        for (Handler child : this.children) {
            child.acceptPostOrder(visitor);
        }
        visitor.visit(this);
    }

    @Override
    public boolean accept(HandlerVisitor.Cancellable visitor) {
        if (visitor.visit(this)) {
            return true;
        }
        for (Handler child : this.children) {
            if (!child.accept(visitor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptPostOrder(HandlerVisitor.Cancellable visitor) {
        for (Handler child : this.children) {
            if (!child.acceptPostOrder(visitor)) continue;
            return true;
        }
        return visitor.visit(this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.buildHandlerString(builder);
        return builder.toString();
    }

    protected void buildHandlerString(StringBuilder builder) {
        builder.append(this.getType());
        builder.append(":");
        builder.append(this.getClass().getSimpleName());
        builder.append(" - ");
        if (this.getPeerNode() != null) {
            builder.append(this.getPeerNode().getId());
            builder.append(":");
        }
        builder.append(this.getComponent().getClass().getSimpleName());
    }

    @Override
    public void buildString(StringBuilder builder, int depth) {
        for (int i = 0; i < depth; ++i) {
            builder.append("  ");
        }
        this.buildHandlerString(builder);
        builder.append("\n");
        for (Handler child : this.getChildrenHandlers()) {
            child.buildString(builder, depth + 1);
        }
    }
}

