/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.componentHandlers;

import com.mathworks.matlabserver.jcp.handlers.Handler;
import com.mathworks.matlabserver.jcp.handlers.componentHandlers.AbstractTextComponentHandler;
import com.mathworks.matlabserver.jcp.utils.ImageUtils;
import com.mathworks.matlabserver.jcp.utils.MouseHandler;
import com.mathworks.matlabserver.jcp.utils.WindowUtils;
import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.events.Event;
import com.mathworks.peermodel.events.Observer;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.SwingUtilities;

public class JButtonHandler
extends AbstractTextComponentHandler {
    protected AbstractButton button;
    private MouseHandler mouseHandler;
    private Observer buttonClickObserver;
    private ItemListener modelChangedListener;
    private ItemListener stateChangedListener;

    @Override
    public String getType() {
        return "Button";
    }

    @Override
    public void handle(Handler parentHandler, Component component, PeerNode parent) {
        this.button = (AbstractButton)component;
        this.mouseHandler = new MouseHandler(this.button);
        super.handle(parentHandler, component, parent);
    }

    @Override
    protected Map<String, Object> doGetProperties(Component component) {
        Map<String, Object> properties = super.doGetProperties(component);
        if (this.button.getIcon() != null) {
            properties.put("icon", ImageUtils.getImageFromIcon(this.button.getIcon(), this.button));
        }
        properties.put("selected", this.button.isSelected());
        return properties;
    }

    @Override
    protected void addEventListeners() {
        super.addEventListeners();
        this.modelChangedListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JButtonHandler.this.markDirty();
            }
        };
        this.button.getModel().addItemListener(this.modelChangedListener);
        this.stateChangedListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JButtonHandler.this.markDirty();
            }
        };
        this.button.addItemListener(this.stateChangedListener);
    }

    @Override
    protected void removeEventListeners() {
        super.removeEventListeners();
        this.button.getModel().removeItemListener(this.modelChangedListener);
        this.button.removeItemListener(this.stateChangedListener);
    }

    @Override
    protected void addPeerNodeListeners() {
        super.addPeerNodeListeners();
        this.buttonClickObserver = new Observer(){

            public void handle(Event event) {
                JButtonHandler.this.invokeLaterEDT(new Runnable(){

                    @Override
                    public void run() {
                        JButtonHandler.this.doClick(JButtonHandler.this.button);
                    }
                });
            }
        };
        this.peerNode.addPeerEventListener("buttonClicked", this.buttonClickObserver);
    }

    @Override
    protected void removePeerNodeListeners() {
        super.removePeerNodeListeners();
        this.peerNode.removePeerEventListener("buttonClicked", this.buttonClickObserver);
    }

    protected void doClick(AbstractButton button) {
        if (this.shouldDoClick(button)) {
            if (button.getClass().getName().contains("hg.peer")) {
                button.requestFocus();
                this.mouseHandler.click(new Point(button.getWidth() / 2, button.getHeight() / 2));
            } else {
                button.doClick();
            }
        } else {
            this.markDirty();
        }
    }

    protected boolean shouldDoClick(AbstractButton button) {
        Window buttonWindow = SwingUtilities.getWindowAncestor(button);
        if (!WindowUtils.isModal(buttonWindow)) {
            Window[] windows;
            for (Window window : windows = Window.getWindows()) {
                if (window == buttonWindow || !window.isVisible() || !WindowUtils.isModal(window)) continue;
                return false;
            }
        }
        return true;
    }
}

