/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.componentHandlers;

import com.mathworks.matlabserver.jcp.handlers.Handler;
import com.mathworks.matlabserver.jcp.handlers.componentHandlers.AbstractTextComponentHandler;
import com.mathworks.matlabserver.jcp.utils.KeyboardUtils;
import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.events.Event;
import com.mathworks.peermodel.events.Observer;
import java.awt.Component;
import java.util.Map;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class JTextFieldHandler
extends AbstractTextComponentHandler
implements DocumentListener {
    private JTextField textField;
    private Observer peerEventObserver = new Observer(){

        public void handle(Event event) {
            String type = event.getData().get("type").toString();
            if (type.equals("enter")) {
                this.onEnter();
            } else if (type.equals("blur")) {
                this.onBlur();
            }
        }

        private synchronized void onEnter() {
            JTextFieldHandler.this.invokeAndWaitEDT(new Runnable(){

                @Override
                public void run() {
                    KeyboardUtils.keyDown(JTextFieldHandler.this.textField, 10, '\n', 0);
                    KeyboardUtils.keyUp(JTextFieldHandler.this.textField, 10, '\n', 0);
                    JTextFieldHandler.this.textField.postActionEvent();
                    JTextFieldHandler.this.markDirty();
                }
            });
        }

        private synchronized void onBlur() {
            JTextFieldHandler.this.invokeAndWaitEDT(new Runnable(){

                @Override
                public void run() {
                    JTextFieldHandler.this.textField.requestFocus();
                }
            });
            JTextFieldHandler.this.invokeAndWaitEDT(new Runnable(){

                @Override
                public void run() {
                    JTextFieldHandler.this.textField.transferFocus();
                    JTextFieldHandler.this.markDirty();
                }
            });
        }
    };
    private Observer propertySetObserver = new Observer(){

        public void handle(Event event) {
            String key = event.getData().get("key").toString();
            if (event.getOriginator() != JTextFieldHandler.this.ORIGIN && key.equals("text")) {
                JTextFieldHandler.this.invokeLaterEDT(new Runnable(){

                    @Override
                    public void run() {
                        JTextFieldHandler.this.textField.setText((String)JTextFieldHandler.this.getPeerNode().getProperty("text"));
                        JTextFieldHandler.this.markDirty();
                    }
                });
            }
        }
    };

    @Override
    public void handle(Handler parentHandler, Component component, PeerNode parentNode) {
        this.textField = (JTextField)component;
        super.handle(parentHandler, component, parentNode);
    }

    @Override
    public String getType() {
        return "TextBox";
    }

    @Override
    protected void addEventListeners() {
        super.addEventListeners();
        this.textField.getDocument().addDocumentListener(this);
    }

    @Override
    protected void removeEventListeners() {
        super.removeEventListeners();
        this.textField.getDocument().removeDocumentListener(this);
    }

    @Override
    protected Map<String, Object> doGetProperties(Component component) {
        Map<String, Object> props = super.doGetProperties(component);
        props.put("editable", this.textField.isEditable());
        return props;
    }

    @Override
    protected void addPeerNodeListeners() {
        super.addPeerNodeListeners();
        this.peerNode.addEventListener("peerEvent", this.peerEventObserver);
        this.peerNode.addEventListener("propertySet", this.propertySetObserver);
    }

    @Override
    protected void removePeerNodeListeners() {
        super.removePeerNodeListeners();
        this.peerNode.removeEventListener("peerEvent", this.peerEventObserver);
        this.peerNode.removeEventListener("propertySet", this.propertySetObserver);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.markDirty();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.markDirty();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.markDirty();
    }
}

