/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.componentHandlers;

import com.mathworks.hg.peer.TextObjectEdit;
import com.mathworks.matlabserver.jcp.handlers.Handler;
import com.mathworks.matlabserver.jcp.handlers.componentHandlers.AbstractTextComponentHandler;
import com.mathworks.matlabserver.jcp.utils.KeyboardUtils;
import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.events.Event;
import com.mathworks.peermodel.events.Observer;
import java.awt.Component;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class JTextPaneHandler
extends AbstractTextComponentHandler
implements DocumentListener {
    private JTextComponent textPane;
    private Observer peerEventObserver = new Observer(){

        public void handle(Event event) {
            String type = event.getData().get("type").toString();
            if (type.equals("blur")) {
                this.onBlur();
                this.onEscape();
            } else if (type.equals("escape")) {
                this.onEscape();
            }
        }

        private void onBlur() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JTextPaneHandler.this.textPane.transferFocus();
                }
            });
        }

        private void onEscape() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    KeyboardUtils.keyDown(JTextPaneHandler.this.textPane, 27, '\uffff', 0);
                    KeyboardUtils.keyUp(JTextPaneHandler.this.textPane, 27, '\uffff', 0);
                }
            });
        }
    };
    private Observer propSetObserver = new Observer(){

        public void handle(Event event) {
            String key = event.getData().get("key").toString();
            if (event.getOriginator() != JTextPaneHandler.this.ORIGIN && key.equals("text")) {
                final String text = event.getData().get("newValue").toString();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Object innerObject;
                        Field this$0;
                        if (JTextPaneHandler.this.textPane.getText().equals(text)) {
                            return;
                        }
                        JTextPaneHandler.this.textPane.requestFocus();
                        JTextPaneHandler.this.textPane.setText(text);
                        if (JTextPaneHandler.this.autoResize) {
                            try {
                                this$0 = JTextPaneHandler.this.textPane.getClass().getDeclaredField("this$0");
                                this$0.setAccessible(true);
                                innerObject = this$0.get(JTextPaneHandler.this.textPane);
                                Method updateSize = innerObject.getClass().getDeclaredMethod("updateSize", Boolean.TYPE, Integer.TYPE);
                                updateSize.setAccessible(true);
                                updateSize.invoke(innerObject, true, 1);
                            }
                            catch (Exception ignore) {
                                // empty catch block
                            }
                            JTextPaneHandler.this.textPane.getParent().doLayout();
                        }
                        try {
                            this$0 = JTextPaneHandler.this.textPane.getClass().getDeclaredField("this$0");
                            this$0.setAccessible(true);
                            innerObject = this$0.get(JTextPaneHandler.this.textPane);
                            Method commitEditAction = innerObject.getClass().getDeclaredMethod("commitEditAction", new Class[0]);
                            commitEditAction.invoke(innerObject, new Object[0]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        }
    };
    private boolean autoResize = false;

    @Override
    public void handle(Handler parentHandler, Component component, PeerNode parent) {
        this.textPane = component instanceof JScrollPane ? (JTextComponent)((JScrollPane)component).getViewport().getComponent(0) : (JTextComponent)component;
        try {
            Field this$0 = this.textPane.getClass().getDeclaredField("this$0");
            this$0.setAccessible(true);
            Object innerObject = this$0.get(this.textPane);
            this.autoResize = innerObject instanceof TextObjectEdit;
        }
        catch (Exception ignore) {
            // empty catch block
        }
        super.handle(parentHandler, component, parent);
    }

    @Override
    public String getType() {
        return "MultiLineTextBox";
    }

    @Override
    public String getComponentSwingType() {
        return this.textPane.getClass().getSimpleName();
    }

    @Override
    public boolean ownsComponent(Component component) {
        return super.ownsComponent(component) || this.textPane.equals(component);
    }

    @Override
    public String getComponentName() {
        return this.textPane.getName();
    }

    @Override
    protected Map<String, Object> doGetProperties(Component component) {
        Map<String, Object> properties = super.doGetProperties(component);
        Map<String, Object> textPaneProperties = super.doGetProperties(this.textPane);
        properties.put("background", textPaneProperties.get("background"));
        Map<String, Object> textProps = this.doGetTextProperties(this.textPane);
        try {
            Field wrapField = this.textPane.getClass().getSuperclass().getSuperclass().getDeclaredField("fWrapEnabled");
            wrapField.setAccessible(true);
            textProps.put("wrapping", wrapField.get(this.textPane));
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (this.autoResize) {
            textProps.put("autoResize", this.autoResize);
        }
        textProps.put("editable", this.textPane.isEditable());
        properties.put("focusable", this.textPane.isFocusable());
        properties.putAll(textProps);
        return properties;
    }

    @Override
    protected void addEventListeners() {
        super.addEventListeners();
        Document document = this.textPane.getDocument();
        document.addDocumentListener(this);
    }

    @Override
    protected void removeEventListeners() {
        super.removeEventListeners();
        Document document = this.textPane.getDocument();
        document.removeDocumentListener(this);
    }

    @Override
    protected void addPeerNodeListeners() {
        super.addPeerNodeListeners();
        this.peerNode.addEventListener("peerEvent", this.peerEventObserver);
        this.peerNode.addEventListener("propertySet", this.propSetObserver);
    }

    @Override
    protected void removePeerNodeListeners() {
        super.removePeerNodeListeners();
        this.peerNode.removeEventListener("peerEvent", this.peerEventObserver);
        this.peerNode.removeEventListener("propertySet", this.propSetObserver);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.markDirty();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.markDirty();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.markDirty();
    }
}

