/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.containerHandlers;

import com.mathworks.matlabserver.jcp.handlers.Handler;
import com.mathworks.matlabserver.jcp.handlers.containerHandlers.AbstractContainerHandler;
import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.events.Event;
import com.mathworks.peermodel.events.Observer;
import java.awt.Color;
import java.awt.Component;
import java.util.Map;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class JSplitPaneHandler
extends AbstractContainerHandler {
    private JSplitPane pane;
    private float[] color = new float[3];
    private Observer listener = new Observer(){

        public void handle(Event event) {
            if (event.getData().get("type").equals("setDividerLocation") && event.getData().containsKey("dividerLocation")) {
                final int divider = (int)Math.round((Double)event.getData().get("dividerLocation"));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JSplitPaneHandler.this.pane.setDividerLocation(divider);
                    }
                });
            }
        }
    };

    @Override
    public String getType() {
        return "SplitPane";
    }

    @Override
    public void handle(Handler parentHandler, Component component, PeerNode parent) {
        this.pane = (JSplitPane)component;
        super.handle(parentHandler, component, parent);
    }

    @Override
    protected Map<String, Object> doGetProperties(Component component) {
        Map<String, Object> props = super.doGetProperties(component);
        Border border = this.pane.getBorder();
        if (border != null && border instanceof LineBorder) {
            Color lineColor = ((LineBorder)border).getLineColor();
            props.put("borderColor", lineColor.getRGBColorComponents(this.color));
            props.put("borderWidth", ((LineBorder)border).getThickness());
        }
        props.put("orientation", this.pane.getOrientation() == 0 ? "vertical" : "horizontal");
        props.put("dividerLocation", this.pane.getDividerLocation());
        props.put("dividerSize", this.pane.getDividerSize());
        return props;
    }

    @Override
    protected void addPeerNodeListeners() {
        super.addPeerNodeListeners();
        this.peerNode.addEventListener("peerEvent", this.listener);
    }

    @Override
    protected void removePeerNodeListeners() {
        super.removePeerNodeListeners();
        this.peerNode.removeEventListener("peerEvent", this.listener);
    }
}

