/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.pixelHandlers;

import com.mathworks.hg.peer.JavaSceneServerPeer;
import com.mathworks.matlabserver.jcp.contextMenus.ClassNameContextMenuMatcher;
import com.mathworks.matlabserver.jcp.contextMenus.ContextMenuManager;
import com.mathworks.matlabserver.jcp.contextMenus.ContextMenuMatcher;
import com.mathworks.matlabserver.jcp.handlers.pixelHandlers.AbstractPixelHandler;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.SwingUtilities;

public abstract class JavaSceneServerHandler
extends AbstractPixelHandler {
    private ContextMenuMatcher contextMenuListener = new ClassNameContextMenuMatcher("ContextMenuPeer");
    private static Method printOffscreenMethod;
    private static Method grabBufferedImageMethod;
    private static Method getFrameImageMethod;

    @Override
    protected BufferedImage getComponentImage(final BufferedImage image) {
        final BufferedImage[] newImage = new BufferedImage[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        Component comp;
                        JavaSceneServerPeer peer = JavaSceneServerHandler.this.getJavaSceneServerPeer();
                        if (peer != null && (comp = peer.getComponent()) != null && comp.getWidth() > 0 && comp.getHeight() > 0 && comp.isDisplayable() && comp.isVisible()) {
                            if (printOffscreenMethod != null && image != null && image.getWidth() == comp.getWidth() && image.getHeight() == comp.getHeight()) {
                                try {
                                    printOffscreenMethod.invoke((Object)peer, comp, image.createGraphics());
                                }
                                catch (Exception e) {
                                    newImage[0] = JavaSceneServerHandler.this.grabNewImage(peer);
                                }
                            } else {
                                newImage[0] = JavaSceneServerHandler.this.grabNewImage(peer);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (newImage[0] != null) {
            return newImage[0];
        }
        return image;
    }

    private BufferedImage grabNewImage(JavaSceneServerPeer peer) {
        if (grabBufferedImageMethod != null) {
            try {
                return (BufferedImage)grabBufferedImageMethod.invoke((Object)peer, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                return (BufferedImage)getFrameImageMethod.invoke(null, peer.getComponent().getParent(), false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private JavaSceneServerPeer getJavaSceneServerPeer() {
        try {
            Field field = this.component.getClass().getDeclaredField("fJSSP");
            field.setAccessible(true);
            return (JavaSceneServerPeer)field.get(this.component);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected void addEventListeners() {
        super.addEventListeners();
        ContextMenuManager.getInstance().addContextMenuHandler(this.contextMenuListener);
    }

    @Override
    protected void removeEventListeners() {
        super.removeEventListeners();
        ContextMenuManager.getInstance().removeContextMenuHandler(this.contextMenuListener);
    }

    static {
        try {
            printOffscreenMethod = JavaSceneServerPeer.class.getMethod("printOffscreen", Component.class, Graphics2D.class);
        }
        catch (Exception e) {
            printOffscreenMethod = null;
        }
        try {
            grabBufferedImageMethod = JavaSceneServerPeer.class.getMethod("grabBufferedImage", new Class[0]);
        }
        catch (Exception e) {
            grabBufferedImageMethod = null;
        }
        try {
            ClassLoader loader = JavaSceneServerHandler.class.getClassLoader();
            Class<?> outputHelperClass = loader.loadClass("com.mathworks.hg.util.HGGetframeOutputHelper");
            getFrameImageMethod = outputHelperClass.getMethod("getFrameImage", Component.class, Boolean.TYPE);
        }
        catch (Exception e) {
            getFrameImageMethod = null;
        }
        if (grabBufferedImageMethod == null && getFrameImageMethod == null) {
            throw new IllegalStateException("Did not find any methods which can create HG2 axes images. MGG axes will not work.");
        }
    }
}

