/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.pixelHandlers.image;

import com.mathworks.matlabserver.jcp.handlers.pixelHandlers.image.ImageStreamClient;
import com.mathworks.matlabserver.jcp.handlers.pixelHandlers.image.ImageStreamHandler;
import com.mathworks.matlabserver.jcp.handlers.pixelHandlers.image.ImageStreamServer;
import com.mathworks.matlabserver.jcp.handlers.pixelHandlers.image.StreamBufferedImage;
import com.mathworks.messageservice.Message;
import com.mathworks.messageservice.MessageService;
import com.mathworks.messageservice.MessageServiceFactory;
import com.mathworks.messageservice.Subscriber;
import com.mathworks.peermodel.synchronizer.utils.ImageDifferencer;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ImageStreamServerImpl
implements ImageStreamServer,
Subscriber {
    private static ExecutorService executor = Executors.newFixedThreadPool(2, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("image stream");
            thread.setDaemon(true);
            return thread;
        }
    });
    private final Object lock = new Object();
    private final String channel;
    private MessageService messageService;
    private boolean dirty = true;
    private boolean clientReady = false;
    private ImageStreamHandler handler;
    private BufferedImage image;
    private boolean serverReady = false;
    private AtomicInteger pendingRunnables = new AtomicInteger(0);

    public ImageStreamServerImpl(String channel, ImageStreamHandler handler) {
        this(channel, handler, MessageServiceFactory.getMessageService());
    }

    public ImageStreamServerImpl(String channel, ImageStreamHandler handler, MessageService messageService) {
        this.channel = channel;
        this.handler = handler;
        this.messageService = messageService;
    }

    @Override
    public void markDirty() {
        this.pendingRunnables.incrementAndGet();
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ImageStreamServerImpl.this.lock;
                synchronized (object) {
                    ImageStreamServerImpl.this.dirty = true;
                    ImageStreamServerImpl.this.sendDiffIfDirtyAndReady();
                }
                ImageStreamServerImpl.this.pendingRunnables.decrementAndGet();
            }
        });
    }

    @Override
    public void start() {
        this.serverReady = true;
        this.messageService.subscribe(this.channel + "/*", (Subscriber)this);
        this.messageService.publish(this.channel + "/ready", (Object)"");
    }

    @Override
    public void stop() {
        this.serverReady = false;
        this.messageService.unsubscribe(this.channel + "/*", (Subscriber)this);
    }

    @Override
    public BufferedImage getImage() {
        try {
            return this.handler.getImage();
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.image;
        }
    }

    @Override
    public String getChannel() {
        return this.channel;
    }

    public void handle(Message message) {
        if (message.getChannel().endsWith("ready")) {
            this.clientReady();
        } else if (message.getChannel().endsWith("getFullUpdate")) {
            this.sendFullUpdate();
        } else if (message.getChannel().endsWith("error")) {
            this.sendFullUpdate();
        }
    }

    private void clientReady() {
        this.pendingRunnables.incrementAndGet();
        executor.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ImageStreamServerImpl.this.lock;
                synchronized (object) {
                    ImageStreamServerImpl.this.setClientReady(true);
                    ImageStreamServerImpl.this.sendDiffIfDirtyAndReady();
                }
                ImageStreamServerImpl.this.pendingRunnables.decrementAndGet();
            }
        });
    }

    private void sendFullUpdate() {
        if (!this.serverReady) {
            return;
        }
        this.pendingRunnables.incrementAndGet();
        executor.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ImageStreamServerImpl.this.lock;
                synchronized (object) {
                    BufferedImage oldImage = null;
                    try {
                        if (ImageStreamServerImpl.this.dirty && ImageStreamServerImpl.this.handler != null) {
                            ImageStreamServerImpl.this.image = ImageStreamServerImpl.this.handler.getImage();
                            ImageStreamServerImpl.this.dirty = false;
                        }
                        oldImage = ImageStreamServerImpl.this.image;
                    }
                    catch (Exception e) {
                        ImageStreamServerImpl.this.dirty = true;
                    }
                    if (oldImage != null) {
                        ImageStreamServerImpl.this.messageService.publish(ImageStreamServerImpl.this.channel + "/fullUpdate", (Object)new StreamBufferedImage(oldImage));
                    }
                }
                ImageStreamServerImpl.this.pendingRunnables.decrementAndGet();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDiffIfDirtyAndReady() {
        Collection diffs = null;
        BufferedImage newImage = null;
        Object object = this.lock;
        synchronized (object) {
            if (!this.serverReady || !this.isClientReady()) {
                return;
            }
            try {
                if (this.dirty && this.handler != null) {
                    newImage = this.handler.getImage();
                    if (this.image != null && newImage != null && this.image.getType() == newImage.getType() && this.image.getWidth() == newImage.getWidth() && this.image.getHeight() == newImage.getHeight()) {
                        diffs = ImageDifferencer.computeImageDifferences((BufferedImage)this.image, (BufferedImage)newImage);
                        this.setClientReady(diffs.size() == 0);
                    } else {
                        this.setClientReady(false);
                    }
                    this.image = newImage;
                    this.dirty = false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.dirty = true;
            }
        }
        if (diffs != null && diffs.size() > 0) {
            for (Map diff : diffs) {
                diff.put("image", new StreamBufferedImage((BufferedImage)diff.get("image")));
            }
            this.messageService.publish(this.channel + "/diff", (Object)diffs);
        } else if (newImage != null && diffs == null) {
            this.messageService.publish(this.channel + "/fullUpdate", (Object)new StreamBufferedImage(newImage));
        }
    }

    protected void setClientReady(boolean clientReady) {
        this.clientReady = clientReady;
        if (clientReady) {
            this.handler.clientStateChange(ImageStreamClient.State.READY);
        } else {
            this.handler.clientStateChange(ImageStreamClient.State.NOT_READY);
        }
    }

    public boolean isClientReady() {
        return this.clientReady;
    }

    void flushPending() {
        while (this.pendingRunnables.get() > 0) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

