/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.tableHandlers;

import com.mathworks.matlabserver.jcp.contextMenus.AllDelegatesMenuMatcher;
import com.mathworks.matlabserver.jcp.contextMenus.ContextMenuManager;
import com.mathworks.matlabserver.jcp.contextMenus.ContextMenuMatcher;
import com.mathworks.matlabserver.jcp.contextMenus.InvokerOrChildContextMenuMatcher;
import com.mathworks.matlabserver.jcp.contextMenus.NotInvokerClassMenuMatcher;
import com.mathworks.matlabserver.jcp.handlers.componentHandlers.AbstractComponentHandler;
import com.mathworks.matlabserver.jcp.utils.KeyboardUtils;
import com.mathworks.matlabserver.jcp.utils.MouseUtils;
import com.mathworks.peermodel.events.Event;
import com.mathworks.peermodel.events.Observer;
import com.mathworks.peermodel.pageddata.DataModelHandler;
import com.mathworks.peermodel.pageddata.impl.PagedDataImpl;
import java.awt.Component;
import java.awt.Point;
import java.lang.reflect.Array;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;

public abstract class AbstractTableHandler
extends AbstractComponentHandler {
    protected boolean updating = false;
    protected Observer peerEventObserver = new Observer(){

        public void handle(final Event event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (event.getData().get("type").equals("contextMenu")) {
                        Point pos = AbstractTableHandler.this.getClickedPoint();
                        MouseUtils.performClick(AbstractTableHandler.this.getTable(AbstractTableHandler.this.component), pos.x, pos.y, 0, 4100, 1);
                    } else if (event.getData().get("type").equals("doubleClick")) {
                        Point point = AbstractTableHandler.this.getPointFromEventData(event.getData());
                        Point pos = AbstractTableHandler.this.getClickedPoint(point.x, point.y);
                        MouseUtils.performClick(AbstractTableHandler.this.getTable(AbstractTableHandler.this.component), pos.x, pos.y, 0, 1040, 2);
                    } else if (event.getData().get("type").equals("cellEvent")) {
                        Point point = AbstractTableHandler.this.getPointFromEventData(event.getData());
                        AbstractTableHandler.this.getTableDataHandler().dispatchCellEvent(point.x, point.y, event.getData());
                    }
                    KeyboardUtils.handleKeyEvent(AbstractTableHandler.this.getTable(AbstractTableHandler.this.component), event.getData());
                }
            });
        }
    };
    protected Observer propSetObserver = new Observer(){

        public void handle(final Event event) {
            if (AbstractTableHandler.this.updatingPeerNode) {
                return;
            }
            if (event.getData().get("key").equals("selectedIndices")) {
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object[] newObjs = (Object[])event.getData().get("newValue");
                        AbstractTableHandler.this.updating = true;
                        try {
                            AbstractTableHandler.this.clearSelection();
                            for (Object obj : newObjs) {
                                int row = 0;
                                int col = 0;
                                if (obj.getClass().isArray()) {
                                    Object rowTemp = Array.get(obj, 0);
                                    Object colTemp = Array.get(obj, 1);
                                    if (rowTemp instanceof Double) {
                                        row = ((Double)rowTemp).intValue();
                                        col = ((Double)colTemp).intValue();
                                    } else {
                                        row = (Integer)rowTemp;
                                        col = (Integer)colTemp;
                                    }
                                } else if (obj instanceof Double) {
                                    if (AbstractTableHandler.this.getTableSelectionType() == SELECTION_TYPE.Row) {
                                        row = ((Double)obj).intValue();
                                    } else {
                                        col = ((Double)obj).intValue();
                                    }
                                } else if (AbstractTableHandler.this.getTableSelectionType() == SELECTION_TYPE.Row) {
                                    row = (Integer)obj;
                                } else {
                                    col = (Integer)obj;
                                }
                                AbstractTableHandler.this.setSelection(row, col, true);
                            }
                        }
                        finally {
                            AbstractTableHandler.this.updating = false;
                        }
                    }
                });
            } else if (event.getData().get("key").equals("columns")) {
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object[] newObjs = (Object[])event.getData().get("newValue");
                        AbstractTableHandler.this.updating = true;
                        try {
                            for (int i = 0; i < newObjs.length; ++i) {
                                if (!(newObjs[i] instanceof Map)) continue;
                                Map column = (Map)newObjs[i];
                                Object w = column.get("width");
                                if (w instanceof Integer) {
                                    AbstractTableHandler.this.setColumnWidth(i, (Integer)w);
                                    continue;
                                }
                                if (!(w instanceof Double)) continue;
                                AbstractTableHandler.this.setColumnWidth(i, ((Double)w).intValue());
                            }
                        }
                        finally {
                            AbstractTableHandler.this.updating = false;
                        }
                    }
                });
            }
        }
    };

    private Point getPointFromEventData(Map<String, Object> data) {
        return new Point(((Double)data.get("row")).intValue(), ((Double)data.get("column")).intValue());
    }

    @Override
    protected Map<String, Object> doGetProperties(Component component) {
        Map<String, Object> props = super.doGetProperties(component);
        this.setTableSelectionProperties(props);
        this.setTableHeaderAndBorderProperties(props);
        this.setTableColumns(props);
        props.put("rowHeight", this.getRowHeight());
        return props;
    }

    protected void setTableSelectionProperties(Map<String, Object> tableProperties) {
        if (this.updating) {
            return;
        }
        SELECTION_MODE selection_mode = this.getTableSelectionMode();
        tableProperties.put("selectionMode", selection_mode.toString().toLowerCase());
        SELECTION_TYPE type = this.getTableSelectionType();
        tableProperties.put("selectionType", type.toString().toLowerCase());
        tableProperties.put("selectedIndices", this.getSelectedIndices());
    }

    protected abstract Object getSelectedIndices();

    protected abstract void clearSelection();

    protected abstract void setSelection(int var1, int var2, boolean var3);

    protected abstract void setColumnWidth(int var1, int var2);

    protected abstract int getRowHeight();

    protected abstract int getColumnHeaderHeight();

    protected abstract Component getTable(Component var1);

    protected abstract void setTableColumns(Map<String, Object> var1);

    protected abstract void setColumnTypeProperties(Map<String, Object> var1, int var2);

    protected abstract void setTableHeaderAndBorderProperties(Map<String, Object> var1);

    protected abstract DataModelHandler getTableDataHandler();

    protected abstract SELECTION_MODE getTableSelectionMode();

    protected abstract SELECTION_TYPE getTableSelectionType();

    protected abstract Point getClickedPoint();

    protected abstract Point getClickedPoint(int var1, int var2);

    @Override
    public String getType() {
        return "Table";
    }

    @Override
    protected void addContextMenuListeners() {
        super.addContextMenuListeners();
        AllDelegatesMenuMatcher matcher = new AllDelegatesMenuMatcher(new ContextMenuMatcher[]{new NotInvokerClassMenuMatcher(JComboBox.class), new InvokerOrChildContextMenuMatcher(this.component)});
        this.menuMatchers.add(matcher);
        ContextMenuManager.getInstance().addContextMenuHandler(matcher);
    }

    @Override
    protected void addPeerNodeListeners() {
        super.addPeerNodeListeners();
        this.peerNode.addEventListener("peerEvent", this.peerEventObserver);
        this.peerNode.addEventListener("propertySet", this.propSetObserver);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PagedDataImpl pagedData = new PagedDataImpl(AbstractTableHandler.this.peerNode, "dataModel", AbstractTableHandler.this.getTableDataHandler());
                AbstractTableHandler.this.peerNode.setProperty("dataModel", (Object)pagedData);
            }
        });
    }

    @Override
    protected void removePeerNodeListeners() {
        super.removePeerNodeListeners();
        this.peerNode.removeEventListener("peerEvent", this.peerEventObserver);
        this.peerNode.removeEventListener("propertySet", this.propSetObserver);
        if (this.peerNode.hasProperty("dataModel")) {
            ((PagedDataImpl)this.peerNode.getProperty("dataModel")).destroy();
        }
    }

    protected static enum SELECTION_TYPE {
        Cell,
        Row,
        Column,
        None;

    }

    protected static enum SELECTION_MODE {
        NONE,
        SINGLE,
        EXTENDED;

    }
}

