/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.tableHandlers;

import com.mathworks.matlabserver.jcp.contextMenus.ContextMenuManager;
import com.mathworks.matlabserver.jcp.contextMenus.InvokerOrChildContextMenuMatcher;
import com.mathworks.matlabserver.jcp.handlers.Handler;
import com.mathworks.matlabserver.jcp.handlers.componentHandlers.AbstractComponentHandler;
import com.mathworks.matlabserver.jcp.handlers.tableHandlers.ReflectionNodeConverter;
import com.mathworks.matlabserver.jcp.handlers.tableHandlers.TreeModelHandler;
import com.mathworks.matlabserver.jcp.utils.MouseHandler;
import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.events.Event;
import com.mathworks.peermodel.events.Observer;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class JTreeHandler
extends AbstractComponentHandler
implements TreeSelectionListener,
TreeExpansionListener {
    private JTree tree;
    private TreeModelHandler handler;
    private MouseHandler mouseHandler;
    private boolean updating = false;
    private Observer propertySetListener = new Observer(){

        public void handle(Event event) {
            if (event.getData().get("key").equals("selectedNodes")) {
                final Object[] ids = (Object[])event.getData().get("newValue");
                final Object[] oldIds = (Object[])event.getData().get("oldValue");
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        HashSet oldIdSet = new HashSet();
                        Collections.addAll(oldIdSet, oldIds);
                        HashSet newIdSet = new HashSet();
                        Collections.addAll(newIdSet, ids);
                        JTreeHandler.this.updating = true;
                        try {
                            TreePath path;
                            PeerNode node;
                            oldIdSet.removeAll(newIdSet);
                            for (Object oldId : oldIdSet) {
                                if (!JTreeHandler.this.peerNode.hasDescendant((String)oldId)) continue;
                                node = JTreeHandler.this.peerNode.getDescendant((String)oldId);
                                path = JTreeHandler.this.handler.getPathFromPeerNode(node);
                                if (!JTreeHandler.this.tree.isPathSelected(path)) continue;
                                JTreeHandler.this.tree.removeSelectionPath(path);
                            }
                            for (Object id : newIdSet) {
                                if (!JTreeHandler.this.peerNode.hasDescendant((String)id)) continue;
                                node = JTreeHandler.this.peerNode.getDescendant((String)id);
                                path = JTreeHandler.this.handler.getPathFromPeerNode(node);
                                if (JTreeHandler.this.tree.isPathSelected(path)) continue;
                                JTreeHandler.this.tree.addSelectionPath(path);
                            }
                        }
                        finally {
                            JTreeHandler.this.updating = false;
                        }
                    }
                });
            } else if (event.getData().get("key").equals("expandedNodes")) {
                final Object[] ids = (Object[])event.getData().get("newValue");
                final Object[] oldIds = (Object[])event.getData().get("oldValue");
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        HashSet oldIdSet = new HashSet();
                        Collections.addAll(oldIdSet, oldIds);
                        HashSet newIdSet = new HashSet();
                        Collections.addAll(newIdSet, ids);
                        JTreeHandler.this.updating = true;
                        try {
                            TreePath path;
                            PeerNode node;
                            oldIdSet.removeAll(newIdSet);
                            for (Object oldId : oldIdSet) {
                                if (!JTreeHandler.this.peerNode.hasDescendant((String)oldId)) continue;
                                node = JTreeHandler.this.peerNode.getDescendant((String)oldId);
                                path = JTreeHandler.this.handler.getPathFromPeerNode(node);
                                if (!JTreeHandler.this.tree.isExpanded(path)) continue;
                                JTreeHandler.this.tree.collapsePath(path);
                            }
                            for (Object id : newIdSet) {
                                if (!JTreeHandler.this.peerNode.hasDescendant((String)id)) continue;
                                node = JTreeHandler.this.peerNode.getDescendant((String)id);
                                path = JTreeHandler.this.handler.getPathFromPeerNode(node);
                                if (!JTreeHandler.this.tree.isCollapsed(path)) continue;
                                JTreeHandler.this.tree.expandPath(path);
                            }
                        }
                        finally {
                            JTreeHandler.this.updating = false;
                        }
                    }
                });
            }
        }
    };
    private Observer doubleClickListener = new Observer(){

        public void handle(final Event event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String id = (String)event.getData().get("node");
                    if (JTreeHandler.this.peerNode.hasDescendant(id)) {
                        PeerNode node = JTreeHandler.this.peerNode.getDescendant(id);
                        Rectangle r = JTreeHandler.this.tree.getPathBounds(JTreeHandler.this.handler.getPathFromPeerNode(node));
                        if (r != null) {
                            JTreeHandler.this.mouseHandler.doubleClick(new Point(r.x + 1, r.y + 1), 0, 0);
                        }
                    }
                }
            });
        }
    };
    private Observer contextMenuListener = new Observer(){

        public void handle(final Event event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String id = (String)event.getData().get("node");
                    if (JTreeHandler.this.peerNode.hasDescendant(id)) {
                        PeerNode node = JTreeHandler.this.peerNode.getDescendant(id);
                        Rectangle r = JTreeHandler.this.tree.getPathBounds(JTreeHandler.this.handler.getPathFromPeerNode(node));
                        if (r != null) {
                            JTreeHandler.this.mouseHandler.click(new Point(r.x + 1, r.y + 1), 0, 3);
                        }
                    }
                }
            });
        }
    };

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (!this.updating) {
            this.peerNode.setProperty("selectedNodes", (Object)this.getSelectedNodes());
        }
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        if (!this.updating) {
            HashSet<String> ids = new HashSet<String>();
            if (this.peerNode.hasProperty("expandedNodes")) {
                Collections.addAll(ids, (Object[])this.peerNode.getProperty("expandedNodes"));
            }
            if (event.getPath() != null) {
                List<PeerNode> newNodes = this.handler.getPeerNodesFromPath(event.getPath().getPath());
                for (PeerNode newNode : newNodes) {
                    ids.add(newNode.getId());
                }
            }
            Object[] idArray = ids.toArray(new String[ids.size()]);
            Arrays.sort(idArray);
            this.peerNode.setProperty("expandedNodes", (Object)idArray);
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        if (!this.updating) {
            PeerNode newNode;
            ArrayList ids = new ArrayList();
            if (this.peerNode.hasProperty("expandedNodes")) {
                Collections.addAll(ids, (Object[])this.peerNode.getProperty("expandedNodes"));
            }
            if (event.getPath() != null && (newNode = this.handler.getPeerNodeFromPath(event.getPath().getPath())) != null) {
                ids.remove(newNode.getId());
            }
            Object[] idArray = ids.toArray(new String[ids.size()]);
            Arrays.sort(idArray);
            this.peerNode.setProperty("expandedNodes", (Object)idArray);
        }
    }

    @Override
    public String getType() {
        return "Tree";
    }

    @Override
    public void handle(Handler parentHandler, Component component, PeerNode parentNode) {
        this.tree = component instanceof JScrollPane ? (JTree)((JScrollPane)component).getViewport().getComponent(0) : (JTree)component;
        this.handler = this.createTreeModelHandler();
        this.mouseHandler = new MouseHandler(this.tree);
        super.handle(parentHandler, component, parentNode);
        if (this.tree.getModel() != null) {
            this.handler.handle(this.tree, this.peerNode);
        }
    }

    protected TreeModelHandler createTreeModelHandler() {
        TreeModelHandler handler = new TreeModelHandler();
        handler.setNodeConverter(new ReflectionNodeConverter(this.tree, this.getBlackList()));
        return handler;
    }

    @Override
    protected Map<String, Object> doGetProperties(Component component) {
        Map<String, Object> props = super.doGetProperties(this.tree);
        Map<String, Object> otherProps = super.doGetProperties(component);
        props.put("position", otherProps.get("position"));
        props.put("enabled", otherProps.get("enabled"));
        props.put("visibility", otherProps.get("visibility"));
        props.put("rootVisible", this.tree.isRootVisible());
        props.put("selectedNodes", this.getSelectedNodes());
        props.put("expandedNodes", this.getExpandedNodes());
        if (this.handler.getModel() != this.tree.getModel()) {
            this.handler.destroy();
            if (this.peerNode != null) {
                this.handler.handle(this.tree, this.peerNode);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JTreeHandler.this.markDirty();
                    }
                });
            }
        }
        return props;
    }

    private String[] getExpandedNodes() {
        HashSet<String> ids = new HashSet<String>();
        if (this.tree.getModel() != null) {
            this.getExpandedNodesHelper(ids, new TreePath(this.tree.getModel().getRoot()));
        }
        Object[] idArray = ids.toArray(new String[ids.size()]);
        Arrays.sort(idArray);
        return idArray;
    }

    private void getExpandedNodesHelper(Set<String> ids, TreePath treePath) {
        if (this.tree.isExpanded(treePath)) {
            PeerNode peerNode = this.handler.getPeerNodeFromPath(treePath.getPath());
            if (peerNode != null) {
                ids.add(peerNode.getId());
            }
            for (int i = 0; i < this.tree.getModel().getChildCount(treePath.getLastPathComponent()); ++i) {
                TreePath childPath = treePath.pathByAddingChild(this.tree.getModel().getChild(treePath.getLastPathComponent(), i));
                this.getExpandedNodesHelper(ids, childPath);
            }
        }
    }

    private String[] getSelectedNodes() {
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths != null) {
            ArrayList<String> ids = new ArrayList<String>(paths.length);
            for (TreePath path : paths) {
                PeerNode newNode = this.handler.getPeerNodeFromPath(path.getPath());
                if (newNode == null) continue;
                ids.add(newNode.getId());
            }
            Object[] idArray = ids.toArray(new String[ids.size()]);
            Arrays.sort(idArray);
            return idArray;
        }
        return new String[0];
    }

    @Override
    protected void addEventListeners() {
        super.addEventListeners();
        this.tree.addTreeSelectionListener(this);
        this.tree.addTreeExpansionListener(this);
    }

    @Override
    protected void removeEventListeners() {
        super.removeEventListeners();
        this.tree.removeTreeSelectionListener(this);
        this.tree.removeTreeExpansionListener(this);
    }

    @Override
    protected void addPeerNodeListeners() {
        super.addPeerNodeListeners();
        this.peerNode.addEventListener("propertySet", this.propertySetListener);
        this.peerNode.addPeerEventListener("mouseDoubleClick", this.doubleClickListener);
        this.peerNode.addPeerEventListener("contextMenu", this.contextMenuListener);
    }

    @Override
    protected void removePeerNodeListeners() {
        super.removePeerNodeListeners();
        this.peerNode.removeEventListener("propertySet", this.propertySetListener);
        this.peerNode.removePeerEventListener("mouseDoubleClick", this.doubleClickListener);
        this.peerNode.removePeerEventListener("contextMenu", this.contextMenuListener);
    }

    @Override
    protected void addContextMenuListeners() {
        super.addContextMenuListeners();
        InvokerOrChildContextMenuMatcher matcher = new InvokerOrChildContextMenuMatcher(this.tree);
        ContextMenuManager.getInstance().addContextMenuHandler(matcher);
        this.menuMatchers.add(matcher);
    }

    public String[] getBlackList() {
        return new String[]{"allowsChildren", "childCount", "depth", "level", "root", "leaf", "label", "siblingCount", "leafCount", "comboIcon", "tearOff"};
    }
}

