/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.windowHandlers;

import com.mathworks.matlabserver.jcp.handlers.Handler;
import com.mathworks.matlabserver.jcp.handlers.HandlerFactory;
import com.mathworks.matlabserver.jcp.handlers.windowHandlers.JFrameHandler;
import com.mathworks.matlabserver.jcp.utils.WindowUtils;
import com.mathworks.peermodel.PeerNode;
import com.mathworks.widgets.desk.DTToolBarContainer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.util.Map;
import javax.swing.JToolBar;

public class JFrameHandlerWithToolbar
extends JFrameHandler {
    private Handler toolBarHandler = null;
    private Component toolBar;

    @Override
    public void handle(Handler parentHandler, Component component, PeerNode parent) {
        this.toolBar = WindowUtils.getToolBarRoot(component);
        super.handle(parentHandler, component, parent);
        this.updateToolBarHandler();
    }

    @Override
    protected Map<String, Object> doGetProperties(Component component) {
        Map<String, Object> props = super.doGetProperties(component);
        props.put("hasToolBar", this.toolBar != null);
        return props;
    }

    @Override
    protected void doAddChild(Component child, PeerNode peerNode, Container container) {
        if (child instanceof DTToolBarContainer || child instanceof JToolBar) {
            this.updateToolBarHandler();
        } else {
            super.doAddChild(child, peerNode, container);
        }
    }

    @Override
    protected void doRemoveChild(Component child) {
        if (child instanceof DTToolBarContainer || child instanceof JToolBar) {
            this.updateToolBarHandler();
        } else {
            super.doRemoveChild(child);
        }
    }

    private void updateToolBarHandler() {
        this.toolBar = WindowUtils.getToolBarRoot(this.getWindow());
        if (this.toolBarHandler == null || this.toolBar != this.toolBarHandler.getComponent()) {
            if (this.toolBarHandler != null) {
                this.toolBarHandler.destroy();
                this.toolBarHandler = null;
            }
            if (this.toolBar != null) {
                this.toolBarHandler = HandlerFactory.getHandler(this.toolBar);
                this.toolBarHandler.handle(this, this.toolBar, this.peerNode);
            }
        }
    }

    @Override
    protected Rectangle getComponentBounds(Component component) {
        int height = WindowUtils.getWindowContentHeight(component);
        Rectangle rect = super.getComponentBounds(component);
        return new Rectangle(rect.x, rect.y, rect.width, height);
    }

    @Override
    public void destroy() {
        if (this.toolBarHandler != null) {
            this.toolBarHandler.destroy();
            this.toolBarHandler = null;
        }
        super.destroy();
    }
}

