/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch;

import com.mathworks.helpsearch.CategoryUtils;
import com.mathworks.helpsearch.ContentFormat;
import com.mathworks.helpsearch.DisplayableResult;
import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.InformationType;
import com.mathworks.helpsearch.ResultCategory;
import com.mathworks.helpsearch.product.DocCenterItemResolver;
import com.mathworks.helpsearch.product.DocSetItem;
import com.mathworks.helpsearch.product.DocSetItemResolver;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.search.HighlightProvider;
import com.mathworks.search.SearchHighlight;
import com.mathworks.search.SearchResult;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DocumentationSearchResult
implements DisplayableResult {
    private static final int DESCRIPTION_TRIM_LENGTH = 250;
    private static final Pattern TRIM_DESCRIPTION_PATTERN = Pattern.compile(".{0," + String.valueOf(247) + "}\\w\\b");
    private final SearchResult fRawResult;
    private final DocSetItemResolver fDocSetItemResolver;
    private final ContentFormat fFormat;
    private final HighlightProvider fProvider;
    private List<SearchHighlight> fHighlights;

    public DocumentationSearchResult(SearchResult rawResult, DocumentationSet docSet, HighlightProvider provider) {
        this(rawResult, new DocCenterItemResolver(docSet), docSet.getFormat(), provider);
    }

    public DocumentationSearchResult(SearchResult rawResult, DocSetItemResolver docSetItemResolver, ContentFormat format, HighlightProvider provider) {
        this.fRawResult = rawResult;
        this.fDocSetItemResolver = docSetItemResolver;
        this.fFormat = format;
        this.fProvider = provider;
    }

    @Override
    public String getPath() {
        return this.getFieldValue(DocumentationSearchField.RELATIVE_PATH);
    }

    @Override
    public String getSummary() {
        String summary = this.getFieldValue(DocumentationSearchField.SUMMARY);
        if (summary != null && summary.length() > 0) {
            return summary;
        }
        return null;
    }

    @Override
    public String getTitle() {
        return this.getFieldValue(DocumentationSearchField.TITLE_DISPLAY);
    }

    @Override
    public DocSetItem getDocSetItem() {
        String prodString = this.getFieldValue(DocumentationSearchField.PRODUCT);
        return this.fDocSetItemResolver.getDocSetItemByIndexString(prodString);
    }

    public String getDescription() {
        String description = this.getFieldValue(DocumentationSearchField.DESCRIPTION);
        return description == null ? "" : DocumentationSearchResult.trimDescription(description);
    }

    private static String trimDescription(String description) {
        Matcher matcher;
        if (description.length() > 250 && (matcher = TRIM_DESCRIPTION_PATTERN.matcher(description)).find()) {
            return matcher.group() + "...";
        }
        return description;
    }

    @Override
    public SearchHighlight highlightText(String text) {
        if (this.fProvider != null) {
            return text == null ? null : this.fProvider.getTextHighlighter().addHighlightsToString(text);
        }
        return text == null ? null : new SearchHighlight(text);
    }

    public List<SearchHighlight> getHighlights() {
        if (this.fHighlights == null && this.fProvider != null) {
            this.populateHighlights();
        }
        return Collections.unmodifiableList(this.fHighlights);
    }

    private void populateHighlights() {
        try {
            String body = this.getFieldValue(DocumentationSearchField.BODY);
            this.fHighlights = this.fProvider.getHighlights(body);
        }
        catch (Exception e) {
            this.fHighlights = Collections.emptyList();
        }
    }

    public List<ResultCategory> getBreadCrumbs() {
        String breadCrumbText = this.getFieldValue(DocumentationSearchField.ANCESTOR_LABEL);
        return CategoryUtils.parseSearchIndexString(breadCrumbText);
    }

    public InformationType getType() {
        String type = this.getFieldValue(DocumentationSearchField.RESULT_TYPE);
        return this.fFormat.getInfoTypeByIndexString(type);
    }

    private String getFieldValue(DocumentationSearchField field) {
        return this.fRawResult.getFieldValue(field.getFieldName());
    }
}

