/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch;

import com.mathworks.helpsearch.HelpLocation;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class RelativeHelpLocation
extends HelpLocation {
    private final List<String> pathParts;

    public RelativeHelpLocation(String path) {
        this(path.split("[\\\\/]+"));
    }

    public RelativeHelpLocation(String[] pathParts) {
        this(Arrays.asList(pathParts));
    }

    public RelativeHelpLocation(List<String> pathParts) {
        this.pathParts = new ArrayList<String>(pathParts.size());
        for (String pathPart : pathParts) {
            if (pathPart == null || pathPart.isEmpty()) continue;
            this.pathParts.add(pathPart);
        }
    }

    @Override
    protected List<String> getRelativePathParts() {
        return Collections.unmodifiableList(this.pathParts);
    }

    @Override
    protected File toFile(File docRoot) {
        File helpLocationFile = docRoot;
        for (String pathPart : this.pathParts) {
            helpLocationFile = new File(helpLocationFile, pathPart);
        }
        return helpLocationFile;
    }

    @Override
    public Collection<List<String>> getLookupPaths() {
        ArrayList<List<String>> paths = new ArrayList<List<String>>(1);
        paths.add(this.getRelativePathParts());
        return paths;
    }

    public String toString() {
        return this.toString("/");
    }

    public String toString(String separator) {
        if (this.pathParts.isEmpty()) {
            return "";
        }
        StringBuilder path = new StringBuilder(this.pathParts.get(0));
        for (int i = 1; i < this.pathParts.size(); ++i) {
            path.append(separator).append(this.pathParts.get(i));
        }
        return path.toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof RelativeHelpLocation && this.pathParts.equals(((RelativeHelpLocation)obj).pathParts);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

