/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.csh;

import com.mathworks.helpsearch.DocLanguage;
import com.mathworks.helpsearch.FileHelpPathBuilder;
import com.mathworks.helpsearch.csh.CshFileBundle;
import com.mathworks.helpsearch.csh.CshSearchField;
import com.mathworks.helpsearch.index.IndexDocumentIterator;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.search.IndexDocument;
import com.mathworks.search.SearchField;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

abstract class CshIndexDocumentIterator
implements IndexDocumentIterator {
    private final File fHelpLocation;
    private final DocProduct fProduct;
    private final DocLanguage fLanguage;
    private Iterator<IndexDocument<CshSearchField>> fIterator;

    protected CshIndexDocumentIterator(File docRoot, DocProduct product, DocLanguage language) {
        this.fHelpLocation = product.getHelpLocation().buildHelpPath(docRoot, new FileHelpPathBuilder(), new String[0]);
        this.fProduct = product;
        this.fLanguage = language;
    }

    @Override
    public void beforeIndex() {
        this.fIterator = this.getIndexDocuments().iterator();
    }

    @Override
    public boolean hasNext() {
        return this.fIterator.hasNext();
    }

    @Override
    public IndexDocument<CshSearchField> next() {
        return this.fIterator.next();
    }

    @Override
    public void remove() {
    }

    @Override
    public void afterIndex() {
    }

    private Iterable<IndexDocument<CshSearchField>> getIndexDocuments() {
        try {
            return this.findAllCshEntries();
        }
        catch (IOException ioe) {
            return Collections.emptyList();
        }
    }

    private Iterable<IndexDocument<CshSearchField>> findAllCshEntries() throws IOException {
        ArrayList<IndexDocument<CshSearchField>> documents = new ArrayList<IndexDocument<CshSearchField>>();
        List<CshFileBundle> cshFiles = this.findCshFiles(this.fHelpLocation);
        for (CshFileBundle cshFile : cshFiles) {
            documents.addAll(this.createIndexDocuments(cshFile));
        }
        return Collections.unmodifiableList(documents);
    }

    List<IndexDocument<CshSearchField>> createIndexDocuments(CshFileBundle bundle) throws IOException {
        Map<String, String> entries = bundle.getCshFileEntries();
        ArrayList<IndexDocument<CshSearchField>> documents = new ArrayList<IndexDocument<CshSearchField>>(entries.size());
        for (Map.Entry<String, String> entry : entries.entrySet()) {
            IndexDocument<CshSearchField> indexDoc = this.createIndexDocument(bundle.getBaseFile(), entry.getKey(), entry.getValue());
            if (indexDoc == null) continue;
            indexDoc.addFieldValue((SearchField)CshSearchField.CSH_PRODUCT, this.getProduct().getShortName());
            documents.add(indexDoc);
        }
        return documents;
    }

    protected abstract List<CshFileBundle> findCshFiles(File var1);

    protected abstract IndexDocument<CshSearchField> createIndexDocument(File var1, String var2, String var3);

    protected String getRelativePathToCshFile(File cshFile) {
        StringBuilder relativePath = new StringBuilder(cshFile.getName());
        for (File currentFile = cshFile.getParentFile(); currentFile != null && !currentFile.equals(this.fHelpLocation); currentFile = currentFile.getParentFile()) {
            relativePath.insert(0, '/').insert(0, currentFile.getName());
        }
        return relativePath.toString();
    }

    protected final DocProduct getProduct() {
        return this.fProduct;
    }

    protected final DocLanguage getLanguage() {
        return this.fLanguage;
    }
}

